/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.File;
import java.util.List;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.http.ssl.KeyStoreTestUtil;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestHBaseTestingUtility {
    private final Log LOG = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testMultiClusters() throws Exception {
        HBaseTestingUtility htu1 = new HBaseTestingUtility();
        htu1.getConfiguration().set("zookeeper.znode.parent", "/1");
        htu1.startMiniZKCluster();
        HBaseTestingUtility htu2 = new HBaseTestingUtility();
        htu2.getConfiguration().set("zookeeper.znode.parent", "/2");
        htu2.getConfiguration().set("hbase.zookeeper.property.clientPort", htu1.getConfiguration().get("hbase.zookeeper.property.clientPort", "-1"));
        htu2.setZkCluster(htu1.getZkCluster());
        HBaseTestingUtility htu3 = new HBaseTestingUtility();
        htu3.getConfiguration().set("zookeeper.znode.parent", "/3");
        htu3.getConfiguration().set("hbase.zookeeper.property.clientPort", htu1.getConfiguration().get("hbase.zookeeper.property.clientPort", "-1"));
        htu3.setZkCluster(htu1.getZkCluster());
        try {
            htu1.startMiniCluster();
            htu2.startMiniCluster();
            htu3.startMiniCluster();
            TableName TABLE_NAME = TableName.valueOf("test");
            byte[] FAM_NAME = Bytes.toBytes("fam");
            byte[] ROW = Bytes.toBytes("row");
            byte[] QUAL_NAME = Bytes.toBytes("qual");
            byte[] VALUE = Bytes.toBytes("value");
            HTable table1 = htu1.createTable(TABLE_NAME, FAM_NAME);
            HTable table2 = htu2.createTable(TABLE_NAME, FAM_NAME);
            Put put = new Put(ROW);
            put.add(FAM_NAME, QUAL_NAME, VALUE);
            table1.put(put);
            Get get = new Get(ROW);
            get.addColumn(FAM_NAME, QUAL_NAME);
            Result res = table1.get(get);
            Assert.assertEquals((long)1L, (long)res.size());
            res = table2.get(get);
            Assert.assertEquals((long)0L, (long)res.size());
            table1.close();
            table2.close();
        }
        finally {
            htu3.shutdownMiniCluster();
            htu2.shutdownMiniCluster();
            htu1.shutdownMiniCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMiniCluster() throws Exception {
        HBaseTestingUtility hbt = new HBaseTestingUtility();
        MiniHBaseCluster cluster = hbt.startMiniCluster();
        try {
            Assert.assertEquals((long)1L, (long)cluster.getLiveRegionServerThreads().size());
        }
        finally {
            hbt.shutdownMiniCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMiniClusterBindToWildcard() throws Exception {
        HBaseTestingUtility hbt = new HBaseTestingUtility();
        hbt.getConfiguration().set("hbase.regionserver.ipc.address", "0.0.0.0");
        MiniHBaseCluster cluster = hbt.startMiniCluster();
        try {
            Assert.assertEquals((long)1L, (long)cluster.getLiveRegionServerThreads().size());
        }
        finally {
            hbt.shutdownMiniCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMiniClusterWithSSLOn() throws Exception {
        String BASEDIR = System.getProperty("test.build.dir", "target/test-dir") + "/" + TestHBaseTestingUtility.class.getSimpleName();
        String sslConfDir = KeyStoreTestUtil.getClasspathDir(TestHBaseTestingUtility.class);
        String keystoresDir = new File(BASEDIR).getAbsolutePath();
        HBaseTestingUtility hbt = new HBaseTestingUtility();
        File base = new File(BASEDIR);
        FileUtil.fullyDelete((File)base);
        base.mkdirs();
        KeyStoreTestUtil.setupSSLConfig(keystoresDir, sslConfDir, hbt.getConfiguration(), false);
        hbt.getConfiguration().set("hbase.ssl.enabled", "true");
        hbt.getConfiguration().addResource("ssl-server.xml");
        hbt.getConfiguration().addResource("ssl-client.xml");
        MiniHBaseCluster cluster = hbt.startMiniCluster();
        try {
            Assert.assertEquals((long)1L, (long)cluster.getLiveRegionServerThreads().size());
        }
        finally {
            hbt.shutdownMiniCluster();
        }
    }

    @Test
    public void testMultipleStartStop() throws Exception {
        HBaseTestingUtility htu1 = new HBaseTestingUtility();
        Path foo = new Path("foo");
        htu1.startMiniCluster();
        htu1.getDFSCluster().getFileSystem().create(foo);
        Assert.assertTrue((boolean)htu1.getDFSCluster().getFileSystem().exists(foo));
        htu1.shutdownMiniCluster();
        htu1.startMiniCluster();
        Assert.assertFalse((boolean)htu1.getDFSCluster().getFileSystem().exists(foo));
        htu1.getDFSCluster().getFileSystem().create(foo);
        Assert.assertTrue((boolean)htu1.getDFSCluster().getFileSystem().exists(foo));
        htu1.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMiniZooKeeperWithOneServer() throws Exception {
        HBaseTestingUtility hbt = new HBaseTestingUtility();
        MiniZooKeeperCluster cluster1 = hbt.startMiniZKCluster();
        try {
            Assert.assertEquals((long)0L, (long)cluster1.getBackupZooKeeperServerNum());
            Assert.assertTrue((cluster1.killCurrentActiveZooKeeperServer() == -1 ? 1 : 0) != 0);
        }
        finally {
            hbt.shutdownMiniZKCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMiniZooKeeperWithMultipleServers() throws Exception {
        HBaseTestingUtility hbt = new HBaseTestingUtility();
        MiniZooKeeperCluster cluster2 = hbt.startMiniZKCluster(5, new int[0]);
        int defaultClientPort = 21818;
        cluster2.setDefaultClientPort(defaultClientPort);
        try {
            Assert.assertEquals((long)4L, (long)cluster2.getBackupZooKeeperServerNum());
            int currentActivePort = cluster2.killCurrentActiveZooKeeperServer();
            Assert.assertTrue((currentActivePort >= defaultClientPort ? 1 : 0) != 0);
            Assert.assertTrue((cluster2.getClientPort() == currentActivePort ? 1 : 0) != 0);
            currentActivePort = cluster2.killCurrentActiveZooKeeperServer();
            Assert.assertTrue((currentActivePort >= defaultClientPort ? 1 : 0) != 0);
            Assert.assertTrue((cluster2.getClientPort() == currentActivePort ? 1 : 0) != 0);
            Assert.assertEquals((long)2L, (long)cluster2.getBackupZooKeeperServerNum());
            Assert.assertEquals((long)3L, (long)cluster2.getZooKeeperServerNum());
            cluster2.killOneBackupZooKeeperServer();
            cluster2.killOneBackupZooKeeperServer();
            Assert.assertEquals((long)0L, (long)cluster2.getBackupZooKeeperServerNum());
            Assert.assertEquals((long)1L, (long)cluster2.getZooKeeperServerNum());
            currentActivePort = cluster2.killCurrentActiveZooKeeperServer();
            Assert.assertTrue((currentActivePort == -1 ? 1 : 0) != 0);
            Assert.assertTrue((cluster2.getClientPort() == currentActivePort ? 1 : 0) != 0);
            cluster2.killOneBackupZooKeeperServer();
            Assert.assertEquals((long)-1L, (long)cluster2.getBackupZooKeeperServerNum());
            Assert.assertEquals((long)0L, (long)cluster2.getZooKeeperServerNum());
        }
        finally {
            hbt.shutdownMiniZKCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMiniZooKeeperWithMultipleClientPorts() throws Exception {
        int j;
        int i;
        int defaultClientPort = 8888;
        HBaseTestingUtility hbt = new HBaseTestingUtility();
        int[] clientPortList1 = new int[]{1111, 1112, 1113};
        MiniZooKeeperCluster cluster1 = hbt.startMiniZKCluster(clientPortList1.length, clientPortList1);
        try {
            List<Integer> clientPortListInCluster = cluster1.getClientPortList();
            for (i = 0; i < clientPortListInCluster.size(); ++i) {
                Assert.assertEquals((long)clientPortListInCluster.get(i).intValue(), (long)clientPortList1[i]);
            }
        }
        finally {
            hbt.shutdownMiniZKCluster();
        }
        hbt.getConfiguration().setInt("test.hbase.zookeeper.property.clientPort", defaultClientPort);
        int[] clientPortList2 = new int[]{2222, 2223};
        MiniZooKeeperCluster cluster2 = hbt.startMiniZKCluster(clientPortList2.length + 2, clientPortList2);
        try {
            List<Integer> clientPortListInCluster = cluster2.getClientPortList();
            j = 0;
            for (i = 0; i < clientPortListInCluster.size(); ++i) {
                if (i < clientPortList2.length) {
                    Assert.assertEquals((long)clientPortListInCluster.get(i).intValue(), (long)clientPortList2[i]);
                    continue;
                }
                Assert.assertEquals((long)clientPortListInCluster.get(i).intValue(), (long)(defaultClientPort + j));
                ++j;
            }
        }
        finally {
            hbt.shutdownMiniZKCluster();
        }
        hbt.getConfiguration().setInt("test.hbase.zookeeper.property.clientPort", defaultClientPort);
        int[] clientPortList3 = new int[]{3333, -3334, 3335, 0};
        MiniZooKeeperCluster cluster3 = hbt.startMiniZKCluster(clientPortList3.length + 1, clientPortList3);
        try {
            List<Integer> clientPortListInCluster = cluster3.getClientPortList();
            j = 0;
            for (i = 0; i < clientPortListInCluster.size(); ++i) {
                if (i < clientPortList3.length && clientPortList3[i] > 0) {
                    Assert.assertEquals((long)clientPortListInCluster.get(i).intValue(), (long)clientPortList3[i]);
                    continue;
                }
                Assert.assertEquals((long)clientPortListInCluster.get(i).intValue(), (long)(defaultClientPort + j));
                ++j;
            }
        }
        finally {
            hbt.shutdownMiniZKCluster();
        }
        hbt.getConfiguration().setInt("test.hbase.zookeeper.property.clientPort", defaultClientPort);
        int[] clientPortList4 = new int[]{-4444, defaultClientPort + 2, 4446, defaultClientPort};
        MiniZooKeeperCluster cluster4 = hbt.startMiniZKCluster(clientPortList4.length + 1, clientPortList4);
        try {
            List<Integer> clientPortListInCluster = cluster4.getClientPortList();
            j = 1;
            for (i = 0; i < clientPortListInCluster.size(); ++i) {
                if (i < clientPortList4.length && clientPortList4[i] > 0) {
                    Assert.assertEquals((long)clientPortListInCluster.get(i).intValue(), (long)clientPortList4[i]);
                    continue;
                }
                Assert.assertEquals((long)clientPortListInCluster.get(i).intValue(), (long)(defaultClientPort + j));
                j += 2;
            }
        }
        finally {
            hbt.shutdownMiniZKCluster();
        }
        int[] clientPortList5 = new int[]{5555, 5556, 5556};
        try {
            MiniZooKeeperCluster cluster5 = hbt.startMiniZKCluster(clientPortList5.length, clientPortList5);
            Assert.assertTrue((cluster5.getClientPort() == -1 ? 1 : 0) != 0);
        }
        catch (Exception e) {
        }
        finally {
            hbt.shutdownMiniZKCluster();
        }
    }

    @Test
    public void testMiniDFSCluster() throws Exception {
        HBaseTestingUtility hbt = new HBaseTestingUtility();
        MiniDFSCluster cluster = hbt.startMiniDFSCluster(null);
        DistributedFileSystem dfs = cluster.getFileSystem();
        Path dir = new Path("dir");
        Path qualifiedDir = dfs.makeQualified(dir);
        this.LOG.info("dir=" + dir + ", qualifiedDir=" + qualifiedDir);
        Assert.assertFalse((boolean)dfs.exists(qualifiedDir));
        Assert.assertTrue((boolean)dfs.mkdirs(qualifiedDir));
        Assert.assertTrue((boolean)dfs.delete(qualifiedDir, true));
        hbt.shutdownMiniCluster();
    }

    @Test
    public void testSetupClusterTestBuildDir() throws Exception {
        HBaseTestingUtility hbt = new HBaseTestingUtility();
        Path testdir = hbt.getClusterTestDir();
        this.LOG.info("uuid-subdir=" + testdir);
        FileSystem fs = hbt.getTestFileSystem();
        Assert.assertFalse((boolean)fs.exists(testdir));
        hbt.startMiniDFSCluster(null);
        Assert.assertTrue((boolean)fs.exists(testdir));
        hbt.shutdownMiniCluster();
        Assert.assertFalse((boolean)fs.exists(testdir));
    }

    @Test
    public void testTestDir() throws Exception {
        HBaseTestingUtility hbt = new HBaseTestingUtility();
        Path testdir = hbt.getDataTestDir();
        this.LOG.info("testdir=" + testdir);
        FileSystem fs = hbt.getTestFileSystem();
        Assert.assertTrue((!fs.exists(testdir) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.mkdirs(testdir));
        Assert.assertTrue((boolean)hbt.cleanupTestDir());
    }
}

