/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestFSTableDescriptorForceCreation {
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    @Test
    public void testShouldCreateNewTableDescriptorIfForcefulCreationIsFalse() throws IOException {
        String name = "newTable2";
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        Path rootdir = new Path(UTIL.getDataTestDir(), "newTable2");
        FSTableDescriptors fstd = new FSTableDescriptors(UTIL.getConfiguration(), fs, rootdir);
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf("newTable2"));
        Assert.assertTrue((String)"Should create new table descriptor", (boolean)fstd.createTableDescriptor(htd, false));
    }

    @Test
    public void testShouldNotCreateTheSameTableDescriptorIfForcefulCreationIsFalse() throws IOException {
        String name = "testAlreadyExists";
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        Path rootdir = new Path(UTIL.getDataTestDir(), "testAlreadyExists");
        FSTableDescriptors fstd = new FSTableDescriptors(UTIL.getConfiguration(), fs, rootdir);
        HTableDescriptor htd = new HTableDescriptor("testAlreadyExists");
        fstd.add(htd);
        Assert.assertFalse((String)"Should not create new table descriptor", (boolean)fstd.createTableDescriptor(htd, false));
    }

    @Test
    public void testShouldAllowForcefulCreationOfAlreadyExistingTableDescriptor() throws Exception {
        String name = "createNewTableNew2";
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        Path rootdir = new Path(UTIL.getDataTestDir(), "createNewTableNew2");
        FSTableDescriptors fstd = new FSTableDescriptors(UTIL.getConfiguration(), fs, rootdir);
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf("createNewTableNew2"));
        fstd.createTableDescriptor(htd, false);
        Assert.assertTrue((String)"Should create new table descriptor", (boolean)fstd.createTableDescriptor(htd, true));
    }
}

