/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableSnapshotScanner;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hive.com.google.common.base.Stopwatch;
import org.apache.hive.org.apache.commons.cli.CommandLine;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class ScanPerformanceEvaluation
extends AbstractHBaseTool {
    private static final String HBASE_COUNTER_GROUP_NAME = "HBase Counters";
    private String type;
    private String file;
    private String tablename;
    private String snapshotName;
    private String restoreDir;
    private String caching;

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        try {
            Path rootDir = FSUtils.getRootDir(conf);
            rootDir.getFileSystem(conf);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected void addOptions() {
        this.addRequiredOptWithArg("t", "type", "the type of the test. One of the following: streaming|scan|snapshotscan|scanmapreduce|snapshotscanmapreduce");
        this.addOptWithArg("f", "file", "the filename to read from");
        this.addOptWithArg("tn", "table", "the tablename to read from");
        this.addOptWithArg("sn", "snapshot", "the snapshot name to read from");
        this.addOptWithArg("rs", "restoredir", "the directory to restore the snapshot");
        this.addOptWithArg("ch", "caching", "scanner caching value");
    }

    @Override
    protected void processOptions(CommandLine cmd) {
        this.type = cmd.getOptionValue("type");
        this.file = cmd.getOptionValue("file");
        this.tablename = cmd.getOptionValue("table");
        this.snapshotName = cmd.getOptionValue("snapshot");
        this.restoreDir = cmd.getOptionValue("restoredir");
        this.caching = cmd.getOptionValue("caching");
    }

    protected void testHdfsStreaming(Path filename) throws IOException {
        int read;
        byte[] buf = new byte[1024];
        FileSystem fs = filename.getFileSystem(this.getConf());
        Stopwatch fileOpenTimer = new Stopwatch();
        Stopwatch streamTimer = new Stopwatch();
        fileOpenTimer.start();
        FSDataInputStream in = fs.open(filename);
        fileOpenTimer.stop();
        long totalBytes = 0L;
        streamTimer.start();
        while ((read = in.read(buf)) >= 0) {
            totalBytes += (long)read;
        }
        streamTimer.stop();
        double throughput = (double)totalBytes / (double)streamTimer.elapsedTime(TimeUnit.SECONDS);
        System.out.println("HDFS streaming: ");
        System.out.println("total time to open: " + fileOpenTimer.elapsedMillis() + " ms");
        System.out.println("total time to read: " + streamTimer.elapsedMillis() + " ms");
        System.out.println("total bytes: " + totalBytes + " bytes (" + StringUtils.humanReadableInt((long)totalBytes) + ")");
        System.out.println("throghput  : " + StringUtils.humanReadableInt((long)((long)throughput)) + "B/s");
    }

    private Scan getScan() {
        Scan scan = new Scan();
        scan.setCacheBlocks(false);
        scan.setMaxVersions(1);
        scan.setScanMetricsEnabled(true);
        if (this.caching != null) {
            scan.setCaching(Integer.parseInt(this.caching));
        }
        return scan;
    }

    public void testScan() throws IOException {
        Result result;
        Stopwatch tableOpenTimer = new Stopwatch();
        Stopwatch scanOpenTimer = new Stopwatch();
        Stopwatch scanTimer = new Stopwatch();
        tableOpenTimer.start();
        HTable table = new HTable(this.getConf(), TableName.valueOf(this.tablename));
        tableOpenTimer.stop();
        Scan scan = this.getScan();
        scanOpenTimer.start();
        ResultScanner scanner = table.getScanner(scan);
        scanOpenTimer.stop();
        long numRows = 0L;
        long numCells = 0L;
        scanTimer.start();
        while ((result = scanner.next()) != null) {
            ++numRows;
            numCells += (long)result.rawCells().length;
        }
        scanTimer.stop();
        scanner.close();
        table.close();
        ScanMetrics metrics = scan.getScanMetrics();
        long totalBytes = metrics.countOfBytesInResults.get();
        double throughput = (double)totalBytes / (double)scanTimer.elapsedTime(TimeUnit.SECONDS);
        double throughputRows = (double)numRows / (double)scanTimer.elapsedTime(TimeUnit.SECONDS);
        double throughputCells = (double)numCells / (double)scanTimer.elapsedTime(TimeUnit.SECONDS);
        System.out.println("HBase scan: ");
        System.out.println("total time to open table: " + tableOpenTimer.elapsedMillis() + " ms");
        System.out.println("total time to open scanner: " + scanOpenTimer.elapsedMillis() + " ms");
        System.out.println("total time to scan: " + scanTimer.elapsedMillis() + " ms");
        System.out.println("Scan metrics:\n" + metrics.getMetricsMap());
        System.out.println("total bytes: " + totalBytes + " bytes (" + StringUtils.humanReadableInt((long)totalBytes) + ")");
        System.out.println("throughput  : " + StringUtils.humanReadableInt((long)((long)throughput)) + "B/s");
        System.out.println("total rows  : " + numRows);
        System.out.println("throughput  : " + StringUtils.humanReadableInt((long)((long)throughputRows)) + " rows/s");
        System.out.println("total cells : " + numCells);
        System.out.println("throughput  : " + StringUtils.humanReadableInt((long)((long)throughputCells)) + " cells/s");
    }

    public void testSnapshotScan() throws IOException {
        Result result;
        Stopwatch snapshotRestoreTimer = new Stopwatch();
        Stopwatch scanOpenTimer = new Stopwatch();
        Stopwatch scanTimer = new Stopwatch();
        Path restoreDir = new Path(this.restoreDir);
        snapshotRestoreTimer.start();
        restoreDir.getFileSystem(this.conf).delete(restoreDir, true);
        snapshotRestoreTimer.stop();
        Scan scan = this.getScan();
        scanOpenTimer.start();
        TableSnapshotScanner scanner = new TableSnapshotScanner(this.conf, restoreDir, this.snapshotName, scan);
        scanOpenTimer.stop();
        long numRows = 0L;
        long numCells = 0L;
        scanTimer.start();
        while ((result = scanner.next()) != null) {
            ++numRows;
            numCells += (long)result.rawCells().length;
        }
        scanTimer.stop();
        scanner.close();
        ScanMetrics metrics = scanner.getScanMetrics();
        long totalBytes = metrics.countOfBytesInResults.get();
        double throughput = (double)totalBytes / (double)scanTimer.elapsedTime(TimeUnit.SECONDS);
        double throughputRows = (double)numRows / (double)scanTimer.elapsedTime(TimeUnit.SECONDS);
        double throughputCells = (double)numCells / (double)scanTimer.elapsedTime(TimeUnit.SECONDS);
        System.out.println("HBase scan snapshot: ");
        System.out.println("total time to restore snapshot: " + snapshotRestoreTimer.elapsedMillis() + " ms");
        System.out.println("total time to open scanner: " + scanOpenTimer.elapsedMillis() + " ms");
        System.out.println("total time to scan: " + scanTimer.elapsedMillis() + " ms");
        System.out.println("Scan metrics:\n" + metrics.getMetricsMap());
        System.out.println("total bytes: " + totalBytes + " bytes (" + StringUtils.humanReadableInt((long)totalBytes) + ")");
        System.out.println("throughput  : " + StringUtils.humanReadableInt((long)((long)throughput)) + "B/s");
        System.out.println("total rows  : " + numRows);
        System.out.println("throughput  : " + StringUtils.humanReadableInt((long)((long)throughputRows)) + " rows/s");
        System.out.println("total cells : " + numCells);
        System.out.println("throughput  : " + StringUtils.humanReadableInt((long)((long)throughputCells)) + " cells/s");
    }

    public void testScanMapReduce() throws IOException, InterruptedException, ClassNotFoundException {
        Stopwatch scanOpenTimer = new Stopwatch();
        Stopwatch scanTimer = new Stopwatch();
        Scan scan = this.getScan();
        String jobName = "testScanMapReduce";
        Job job = new Job(this.conf);
        job.setJobName(jobName);
        job.setJarByClass(this.getClass());
        TableMapReduceUtil.initTableMapperJob(this.tablename, scan, MyMapper.class, NullWritable.class, NullWritable.class, job);
        job.setNumReduceTasks(0);
        job.setOutputKeyClass(NullWritable.class);
        job.setOutputValueClass(NullWritable.class);
        job.setOutputFormatClass(NullOutputFormat.class);
        scanTimer.start();
        job.waitForCompletion(true);
        scanTimer.stop();
        Counters counters = job.getCounters();
        long numRows = counters.findCounter((Enum)ScanCounter.NUM_ROWS).getValue();
        long numCells = counters.findCounter((Enum)ScanCounter.NUM_CELLS).getValue();
        long totalBytes = counters.findCounter(HBASE_COUNTER_GROUP_NAME, "BYTES_IN_RESULTS").getValue();
        double throughput = (double)totalBytes / (double)scanTimer.elapsedTime(TimeUnit.SECONDS);
        double throughputRows = (double)numRows / (double)scanTimer.elapsedTime(TimeUnit.SECONDS);
        double throughputCells = (double)numCells / (double)scanTimer.elapsedTime(TimeUnit.SECONDS);
        System.out.println("HBase scan mapreduce: ");
        System.out.println("total time to open scanner: " + scanOpenTimer.elapsedMillis() + " ms");
        System.out.println("total time to scan: " + scanTimer.elapsedMillis() + " ms");
        System.out.println("total bytes: " + totalBytes + " bytes (" + StringUtils.humanReadableInt((long)totalBytes) + ")");
        System.out.println("throughput  : " + StringUtils.humanReadableInt((long)((long)throughput)) + "B/s");
        System.out.println("total rows  : " + numRows);
        System.out.println("throughput  : " + StringUtils.humanReadableInt((long)((long)throughputRows)) + " rows/s");
        System.out.println("total cells : " + numCells);
        System.out.println("throughput  : " + StringUtils.humanReadableInt((long)((long)throughputCells)) + " cells/s");
    }

    public void testSnapshotScanMapReduce() throws IOException, InterruptedException, ClassNotFoundException {
        Stopwatch scanOpenTimer = new Stopwatch();
        Stopwatch scanTimer = new Stopwatch();
        Scan scan = this.getScan();
        String jobName = "testSnapshotScanMapReduce";
        Job job = new Job(this.conf);
        job.setJobName(jobName);
        job.setJarByClass(this.getClass());
        TableMapReduceUtil.initTableSnapshotMapperJob(this.snapshotName, scan, MyMapper.class, NullWritable.class, NullWritable.class, job, true, new Path(this.restoreDir));
        job.setNumReduceTasks(0);
        job.setOutputKeyClass(NullWritable.class);
        job.setOutputValueClass(NullWritable.class);
        job.setOutputFormatClass(NullOutputFormat.class);
        scanTimer.start();
        job.waitForCompletion(true);
        scanTimer.stop();
        Counters counters = job.getCounters();
        long numRows = counters.findCounter((Enum)ScanCounter.NUM_ROWS).getValue();
        long numCells = counters.findCounter((Enum)ScanCounter.NUM_CELLS).getValue();
        long totalBytes = counters.findCounter(HBASE_COUNTER_GROUP_NAME, "BYTES_IN_RESULTS").getValue();
        double throughput = (double)totalBytes / (double)scanTimer.elapsedTime(TimeUnit.SECONDS);
        double throughputRows = (double)numRows / (double)scanTimer.elapsedTime(TimeUnit.SECONDS);
        double throughputCells = (double)numCells / (double)scanTimer.elapsedTime(TimeUnit.SECONDS);
        System.out.println("HBase scan mapreduce: ");
        System.out.println("total time to open scanner: " + scanOpenTimer.elapsedMillis() + " ms");
        System.out.println("total time to scan: " + scanTimer.elapsedMillis() + " ms");
        System.out.println("total bytes: " + totalBytes + " bytes (" + StringUtils.humanReadableInt((long)totalBytes) + ")");
        System.out.println("throughput  : " + StringUtils.humanReadableInt((long)((long)throughput)) + "B/s");
        System.out.println("total rows  : " + numRows);
        System.out.println("throughput  : " + StringUtils.humanReadableInt((long)((long)throughputRows)) + " rows/s");
        System.out.println("total cells : " + numCells);
        System.out.println("throughput  : " + StringUtils.humanReadableInt((long)((long)throughputCells)) + " cells/s");
    }

    @Override
    protected int doWork() throws Exception {
        if (this.type.equals("streaming")) {
            this.testHdfsStreaming(new Path(this.file));
        } else if (this.type.equals("scan")) {
            this.testScan();
        } else if (this.type.equals("snapshotscan")) {
            this.testSnapshotScan();
        } else if (this.type.equals("scanmapreduce")) {
            this.testScanMapReduce();
        } else if (this.type.equals("snapshotscanmapreduce")) {
            this.testSnapshotScanMapReduce();
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int ret = ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new ScanPerformanceEvaluation(), (String[])args);
        System.exit(ret);
    }

    public static class MyMapper<KEYOUT, VALUEOUT>
    extends TableMapper<KEYOUT, VALUEOUT> {
        protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
            context.getCounter((Enum)ScanCounter.NUM_ROWS).increment(1L);
            context.getCounter((Enum)ScanCounter.NUM_CELLS).increment((long)value.rawCells().length);
        }
    }

    public static enum ScanCounter {
        NUM_ROWS,
        NUM_CELLS;

    }
}

