/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;

public class PerformanceEvaluationCommons {
    static final Log LOG = LogFactory.getLog(PerformanceEvaluationCommons.class.getName());

    public static void assertValueSize(int expectedSize, int got) {
        if (got != expectedSize) {
            throw new AssertionError((Object)("Expected " + expectedSize + " but got " + got));
        }
    }

    public static void assertKey(byte[] expected, ByteBuffer got) {
        byte[] b = new byte[got.limit()];
        got.get(b, 0, got.limit());
        PerformanceEvaluationCommons.assertKey(expected, b);
    }

    public static void assertKey(byte[] expected, Cell c) {
        PerformanceEvaluationCommons.assertKey(expected, c.getRowArray(), c.getRowOffset(), c.getRowLength());
    }

    public static void assertKey(byte[] expected, byte[] got) {
        PerformanceEvaluationCommons.assertKey(expected, got, 0, got.length);
    }

    public static void assertKey(byte[] expected, byte[] gotArray, int gotArrayOffset, int gotArrayLength) {
        if (!Bytes.equals(expected, 0, expected.length, gotArray, gotArrayOffset, gotArrayLength)) {
            throw new AssertionError((Object)("Expected " + Bytes.toString(expected) + " but got " + Bytes.toString(gotArray, gotArrayOffset, gotArrayLength)));
        }
    }

    public static void concurrentReads(Runnable r) {
        boolean count = true;
        long now = System.currentTimeMillis();
        ArrayList<Thread> threads = new ArrayList<Thread>(1);
        for (int i = 0; i < 1; ++i) {
            Thread t = new Thread(r);
            t.setName("" + i);
            threads.add(t);
        }
        for (Thread t : threads) {
            t.start();
        }
        for (Thread t : threads) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        LOG.info("Test took " + (System.currentTimeMillis() - now));
    }
}

