/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;

public abstract class MultithreadedTestUtil {
    public static final Log LOG = LogFactory.getLog(MultithreadedTestUtil.class);

    public static <T> void assertOnFutures(List<Future<T>> threadResults) throws InterruptedException, ExecutionException {
        for (Future<T> threadResult : threadResults) {
            try {
                threadResult.get();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof AssertionError) {
                    throw (AssertionError)((Object)e.getCause());
                }
                throw e;
            }
        }
    }

    public static abstract class RepeatingTestThread
    extends TestThread {
        public RepeatingTestThread(TestContext ctx) {
            super(ctx);
        }

        @Override
        public final void doWork() throws Exception {
            while (this.ctx.shouldRun() && !this.stopped) {
                this.doAnAction();
            }
        }

        public abstract void doAnAction() throws Exception;
    }

    public static abstract class TestThread
    extends Thread {
        protected final TestContext ctx;
        protected boolean stopped;

        public TestThread(TestContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public void run() {
            try {
                this.doWork();
            }
            catch (Throwable t) {
                this.ctx.threadFailed(t);
            }
            this.ctx.threadDone();
        }

        public abstract void doWork() throws Exception;

        protected void stopTestThread() {
            this.stopped = true;
        }
    }

    public static class TestContext {
        private final Configuration conf;
        private Throwable err = null;
        private boolean stopped = false;
        private int threadDoneCount = 0;
        private Set<TestThread> testThreads = new HashSet<TestThread>();

        public TestContext(Configuration configuration) {
            this.conf = configuration;
        }

        protected Configuration getConf() {
            return this.conf;
        }

        public synchronized boolean shouldRun() {
            return !this.stopped && this.err == null;
        }

        public void addThread(TestThread t) {
            this.testThreads.add(t);
        }

        public void startThreads() {
            for (TestThread t : this.testThreads) {
                t.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitFor(long millis) throws Exception {
            long left;
            long endTime = System.currentTimeMillis() + millis;
            while (!this.stopped && (left = endTime - System.currentTimeMillis()) > 0L) {
                TestContext testContext = this;
                synchronized (testContext) {
                    this.checkException();
                    this.wait(left);
                }
            }
        }

        private synchronized void checkException() throws Exception {
            if (this.err != null) {
                throw new RuntimeException("Deferred", this.err);
            }
        }

        public synchronized void threadFailed(Throwable t) {
            if (this.err == null) {
                this.err = t;
            }
            LOG.error("Failed!", this.err);
            this.notify();
        }

        public synchronized void threadDone() {
            ++this.threadDoneCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setStopFlag(boolean s) throws Exception {
            TestContext testContext = this;
            synchronized (testContext) {
                this.stopped = s;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() throws Exception {
            TestContext testContext = this;
            synchronized (testContext) {
                this.stopped = true;
            }
            for (TestThread t : this.testThreads) {
                t.join();
            }
            this.checkException();
        }
    }
}

