/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseCluster;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.LocalHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MiniHBaseCluster
extends HBaseCluster {
    static final Log LOG = LogFactory.getLog(MiniHBaseCluster.class.getName());
    public LocalHBaseCluster hbaseCluster;
    private static int index;

    public MiniHBaseCluster(Configuration conf, int numRegionServers) throws IOException, InterruptedException {
        this(conf, 1, numRegionServers);
    }

    public MiniHBaseCluster(Configuration conf, int numMasters, int numRegionServers) throws IOException, InterruptedException {
        this(conf, numMasters, numRegionServers, null, null);
    }

    public MiniHBaseCluster(Configuration conf, int numMasters, int numRegionServers, Class<? extends HMaster> masterClass, Class<? extends MiniHBaseClusterRegionServer> regionserverClass) throws IOException, InterruptedException {
        super(conf);
        conf.set("hbase.master.port", "0");
        CompatibilityFactory.getInstance(MetricsAssertHelper.class).init();
        this.init(numMasters, numRegionServers, masterClass, regionserverClass);
        this.initialClusterStatus = this.getClusterStatus();
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    private void init(int nMasterNodes, int nRegionNodes, Class<? extends HMaster> masterClass, Class<? extends MiniHBaseClusterRegionServer> regionserverClass) throws IOException, InterruptedException {
        try {
            if (masterClass == null) {
                masterClass = HMaster.class;
            }
            if (regionserverClass == null) {
                regionserverClass = MiniHBaseClusterRegionServer.class;
            }
            this.hbaseCluster = new LocalHBaseCluster(this.conf, nMasterNodes, 0, masterClass, regionserverClass);
            for (int i = 0; i < nRegionNodes; ++i) {
                Configuration rsConf = HBaseConfiguration.create(this.conf);
                User user = HBaseTestingUtility.getDifferentUser(rsConf, ".hfs." + index++);
                this.hbaseCluster.addRegionServer(rsConf, i, user);
            }
            this.hbaseCluster.startup();
        }
        catch (IOException e) {
            this.shutdown();
            throw e;
        }
        catch (Throwable t) {
            LOG.error("Error starting cluster", t);
            this.shutdown();
            throw new IOException("Shutting down", t);
        }
    }

    @Override
    public void startRegionServer(String hostname, int port) throws IOException {
        this.startRegionServer();
    }

    @Override
    public void killRegionServer(ServerName serverName) throws IOException {
        HRegionServer server = this.getRegionServer(this.getRegionServerIndex(serverName));
        if (server instanceof MiniHBaseClusterRegionServer) {
            LOG.info("Killing " + server.toString());
            ((MiniHBaseClusterRegionServer)server).kill();
        } else {
            this.abortRegionServer(this.getRegionServerIndex(serverName));
        }
    }

    @Override
    public void stopRegionServer(ServerName serverName) throws IOException {
        this.stopRegionServer(this.getRegionServerIndex(serverName));
    }

    @Override
    public void waitForRegionServerToStop(ServerName serverName, long timeout) throws IOException {
        this.waitOnRegionServer(this.getRegionServerIndex(serverName));
    }

    @Override
    public void startMaster(String hostname, int port) throws IOException {
        this.startMaster();
    }

    @Override
    public void killMaster(ServerName serverName) throws IOException {
        this.abortMaster(this.getMasterIndex(serverName));
    }

    @Override
    public void stopMaster(ServerName serverName) throws IOException {
        this.stopMaster(this.getMasterIndex(serverName));
    }

    @Override
    public void waitForMasterToStop(ServerName serverName, long timeout) throws IOException {
        this.waitOnMaster(this.getMasterIndex(serverName));
    }

    public JVMClusterUtil.RegionServerThread startRegionServer() throws IOException {
        Configuration newConf = HBaseConfiguration.create(this.conf);
        User rsUser = HBaseTestingUtility.getDifferentUser(newConf, ".hfs." + index++);
        JVMClusterUtil.RegionServerThread t = null;
        try {
            t = this.hbaseCluster.addRegionServer(newConf, this.hbaseCluster.getRegionServers().size(), rsUser);
            t.start();
            t.waitForServerOnline();
        }
        catch (InterruptedException ie) {
            throw new IOException("Interrupted adding regionserver to cluster", ie);
        }
        return t;
    }

    public String abortRegionServer(int serverNumber) {
        HRegionServer server = this.getRegionServer(serverNumber);
        LOG.info("Aborting " + server.toString());
        server.abort("Aborting for tests", new Exception("Trace info"));
        return server.toString();
    }

    public JVMClusterUtil.RegionServerThread stopRegionServer(int serverNumber) {
        return this.stopRegionServer(serverNumber, true);
    }

    public JVMClusterUtil.RegionServerThread stopRegionServer(int serverNumber, boolean shutdownFS) {
        JVMClusterUtil.RegionServerThread server = this.hbaseCluster.getRegionServers().get(serverNumber);
        LOG.info("Stopping " + server.toString());
        server.getRegionServer().stop("Stopping rs " + serverNumber);
        return server;
    }

    public String waitOnRegionServer(int serverNumber) {
        return this.hbaseCluster.waitOnRegionServer(serverNumber);
    }

    public JVMClusterUtil.MasterThread startMaster() throws IOException {
        Configuration c = HBaseConfiguration.create(this.conf);
        User user = HBaseTestingUtility.getDifferentUser(c, ".hfs." + index++);
        JVMClusterUtil.MasterThread t = null;
        try {
            t = this.hbaseCluster.addMaster(c, this.hbaseCluster.getMasters().size(), user);
            t.start();
        }
        catch (InterruptedException ie) {
            throw new IOException("Interrupted adding master to cluster", ie);
        }
        return t;
    }

    @Override
    public MasterProtos.MasterService.BlockingInterface getMasterAdminService() {
        return this.hbaseCluster.getActiveMaster().getMasterRpcServices();
    }

    public HMaster getMaster() {
        return this.hbaseCluster.getActiveMaster();
    }

    public JVMClusterUtil.MasterThread getMasterThread() {
        for (JVMClusterUtil.MasterThread mt : this.hbaseCluster.getLiveMasters()) {
            if (!mt.getMaster().isActiveMaster()) continue;
            return mt;
        }
        return null;
    }

    public HMaster getMaster(int serverNumber) {
        return this.hbaseCluster.getMaster(serverNumber);
    }

    public String abortMaster(int serverNumber) {
        HMaster server = this.getMaster(serverNumber);
        LOG.info("Aborting " + server.toString());
        server.abort("Aborting for tests", new Exception("Trace info"));
        return server.toString();
    }

    public JVMClusterUtil.MasterThread stopMaster(int serverNumber) {
        return this.stopMaster(serverNumber, true);
    }

    public JVMClusterUtil.MasterThread stopMaster(int serverNumber, boolean shutdownFS) {
        JVMClusterUtil.MasterThread server = this.hbaseCluster.getMasters().get(serverNumber);
        LOG.info("Stopping " + server.toString());
        server.getMaster().stop("Stopping master " + serverNumber);
        return server;
    }

    public String waitOnMaster(int serverNumber) {
        return this.hbaseCluster.waitOnMaster(serverNumber);
    }

    @Override
    public boolean waitForActiveAndReadyMaster(long timeout) throws IOException {
        List<JVMClusterUtil.MasterThread> mts;
        long start = System.currentTimeMillis();
        while (!(mts = this.getMasterThreads()).isEmpty() && System.currentTimeMillis() - start < timeout) {
            for (JVMClusterUtil.MasterThread mt : mts) {
                if (!mt.getMaster().isActiveMaster() || !mt.getMaster().isInitialized()) continue;
                return true;
            }
            Threads.sleep(100L);
        }
        return false;
    }

    public List<JVMClusterUtil.MasterThread> getMasterThreads() {
        return this.hbaseCluster.getMasters();
    }

    public List<JVMClusterUtil.MasterThread> getLiveMasterThreads() {
        return this.hbaseCluster.getLiveMasters();
    }

    public void join() {
        this.hbaseCluster.join();
    }

    @Override
    public void shutdown() throws IOException {
        if (this.hbaseCluster != null) {
            this.hbaseCluster.shutdown();
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public ClusterStatus getClusterStatus() throws IOException {
        HMaster master = this.getMaster();
        return master == null ? null : master.getClusterStatus();
    }

    public void flushcache() throws IOException {
        for (JVMClusterUtil.RegionServerThread t : this.hbaseCluster.getRegionServers()) {
            for (Region r : t.getRegionServer().getOnlineRegionsLocalContext()) {
                r.flush(true);
            }
        }
    }

    public void flushcache(TableName tableName) throws IOException {
        for (JVMClusterUtil.RegionServerThread t : this.hbaseCluster.getRegionServers()) {
            for (Region r : t.getRegionServer().getOnlineRegionsLocalContext()) {
                if (!r.getTableDesc().getTableName().equals(tableName)) continue;
                r.flush(true);
            }
        }
    }

    public void compact(boolean major) throws IOException {
        for (JVMClusterUtil.RegionServerThread t : this.hbaseCluster.getRegionServers()) {
            for (Region r : t.getRegionServer().getOnlineRegionsLocalContext()) {
                r.compact(major);
            }
        }
    }

    public void compact(TableName tableName, boolean major) throws IOException {
        for (JVMClusterUtil.RegionServerThread t : this.hbaseCluster.getRegionServers()) {
            for (Region r : t.getRegionServer().getOnlineRegionsLocalContext()) {
                if (!r.getTableDesc().getTableName().equals(tableName)) continue;
                r.compact(major);
            }
        }
    }

    public List<JVMClusterUtil.RegionServerThread> getRegionServerThreads() {
        return this.hbaseCluster.getRegionServers();
    }

    public List<JVMClusterUtil.RegionServerThread> getLiveRegionServerThreads() {
        return this.hbaseCluster.getLiveRegionServers();
    }

    public HRegionServer getRegionServer(int serverNumber) {
        return this.hbaseCluster.getRegionServer(serverNumber);
    }

    public List<HRegion> getRegions(byte[] tableName) {
        return this.getRegions(TableName.valueOf(tableName));
    }

    public List<HRegion> getRegions(TableName tableName) {
        ArrayList<HRegion> ret = new ArrayList<HRegion>();
        for (JVMClusterUtil.RegionServerThread rst : this.getRegionServerThreads()) {
            HRegionServer hrs = rst.getRegionServer();
            for (Region region : hrs.getOnlineRegionsLocalContext()) {
                if (!region.getTableDesc().getTableName().equals(tableName)) continue;
                ret.add((HRegion)region);
            }
        }
        return ret;
    }

    public int getServerWithMeta() {
        return this.getServerWith(HRegionInfo.FIRST_META_REGIONINFO.getRegionName());
    }

    public int getServerWith(byte[] regionName) {
        int index = -1;
        int count = 0;
        for (JVMClusterUtil.RegionServerThread rst : this.getRegionServerThreads()) {
            HRegionServer hrs = rst.getRegionServer();
            Region metaRegion = hrs.getOnlineRegion(regionName);
            if (metaRegion != null) {
                index = count;
                break;
            }
            ++count;
        }
        return index;
    }

    @Override
    public ServerName getServerHoldingRegion(TableName tn, byte[] regionName) throws IOException {
        HMaster master = this.getMaster();
        Region region = master.getOnlineRegion(regionName);
        if (region != null) {
            return master.getServerName();
        }
        int index = this.getServerWith(regionName);
        if (index < 0) {
            return null;
        }
        return this.getRegionServer(index).getServerName();
    }

    public long countServedRegions() {
        long count = 0L;
        for (JVMClusterUtil.RegionServerThread rst : this.getLiveRegionServerThreads()) {
            count += (long)rst.getRegionServer().getNumberOfOnlineRegions();
        }
        for (JVMClusterUtil.MasterThread mt : this.getLiveMasterThreads()) {
            count += (long)mt.getMaster().getNumberOfOnlineRegions();
        }
        return count;
    }

    public void killAll() {
        for (JVMClusterUtil.RegionServerThread rst : this.getRegionServerThreads()) {
            rst.getRegionServer().abort("killAll");
        }
        for (JVMClusterUtil.MasterThread masterThread : this.getMasterThreads()) {
            masterThread.getMaster().abort("killAll", new Throwable());
        }
    }

    @Override
    public void waitUntilShutDown() {
        this.hbaseCluster.join();
    }

    public List<HRegion> findRegionsForTable(TableName tableName) {
        ArrayList<HRegion> ret = new ArrayList<HRegion>();
        for (JVMClusterUtil.RegionServerThread rst : this.getRegionServerThreads()) {
            HRegionServer hrs = rst.getRegionServer();
            for (Region region : hrs.getOnlineRegions(tableName)) {
                if (!region.getTableDesc().getTableName().equals(tableName)) continue;
                ret.add((HRegion)region);
            }
        }
        return ret;
    }

    protected int getRegionServerIndex(ServerName serverName) {
        List<JVMClusterUtil.RegionServerThread> servers = this.getRegionServerThreads();
        for (int i = 0; i < servers.size(); ++i) {
            if (!servers.get(i).getRegionServer().getServerName().equals(serverName)) continue;
            return i;
        }
        return -1;
    }

    protected int getMasterIndex(ServerName serverName) {
        List<JVMClusterUtil.MasterThread> masters = this.getMasterThreads();
        for (int i = 0; i < masters.size(); ++i) {
            if (!masters.get(i).getMaster().getServerName().equals(serverName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public AdminProtos.AdminService.BlockingInterface getAdminProtocol(ServerName serverName) throws IOException {
        return this.getRegionServer(this.getRegionServerIndex(serverName)).getRSRpcServices();
    }

    @Override
    public ClientProtos.ClientService.BlockingInterface getClientProtocol(ServerName serverName) throws IOException {
        return this.getRegionServer(this.getRegionServerIndex(serverName)).getRSRpcServices();
    }

    static class SingleFileSystemShutdownThread
    extends Thread {
        private final FileSystem fs;

        SingleFileSystemShutdownThread(FileSystem fs) {
            super("Shutdown of " + fs);
            this.fs = fs;
        }

        @Override
        public void run() {
            try {
                LOG.info("Hook closing fs=" + this.fs);
                this.fs.close();
            }
            catch (NullPointerException npe) {
                LOG.debug("Need to fix these: " + npe.toString());
            }
            catch (IOException e) {
                LOG.warn("Running hook", e);
            }
        }
    }

    public static class MiniHBaseClusterRegionServer
    extends HRegionServer {
        private Thread shutdownThread = null;
        private User user = User.getCurrent();
        public static boolean TEST_SKIP_CLOSE = false;

        public MiniHBaseClusterRegionServer(Configuration conf, CoordinatedStateManager cp) throws IOException, InterruptedException {
            super(conf, cp);
        }

        @Override
        protected void handleReportForDutyResponse(RegionServerStatusProtos.RegionServerStartupResponse c) throws IOException {
            super.handleReportForDutyResponse(c);
            this.shutdownThread = new SingleFileSystemShutdownThread(this.getFileSystem());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.user.runAs(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        MiniHBaseClusterRegionServer.this.runRegionServer();
                        return null;
                    }
                });
            }
            catch (Throwable t) {
                LOG.error("Exception in run", t);
            }
            finally {
                if (this.shutdownThread != null) {
                    this.shutdownThread.start();
                    Threads.shutdown(this.shutdownThread, 30000L);
                }
            }
        }

        private void runRegionServer() {
            super.run();
        }

        @Override
        public void kill() {
            super.kill();
        }

        @Override
        public void abort(final String reason, final Throwable cause) {
            this.user.runAs(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    MiniHBaseClusterRegionServer.this.abortRegionServer(reason, cause);
                    return null;
                }
            });
        }

        private void abortRegionServer(String reason, Throwable cause) {
            super.abort(reason, cause);
        }
    }
}

