/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.net.UnknownHostException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class AuthUtil {
    private static final Log LOG = LogFactory.getLog(AuthUtil.class);
    public static final String GROUP_PREFIX = "@";

    private AuthUtil() {
    }

    public static ScheduledChore getAuthChore(Configuration conf) throws IOException {
        boolean securityEnabled;
        UserProvider userProvider = UserProvider.instantiate(conf);
        boolean bl = securityEnabled = userProvider.isHadoopSecurityEnabled() && userProvider.isHBaseSecurityEnabled();
        if (!securityEnabled) {
            return null;
        }
        String host = null;
        try {
            host = Strings.domainNamePointerToHostName(DNS.getDefaultHost((String)conf.get("hbase.client.dns.interface", "default"), (String)conf.get("hbase.client.dns.nameserver", "default")));
            userProvider.login("hbase.client.keytab.file", "hbase.client.kerberos.principal", host);
        }
        catch (UnknownHostException e) {
            LOG.error("Error resolving host name: " + e.getMessage(), e);
            throw e;
        }
        catch (IOException e) {
            LOG.error("Error while trying to perform the initial login: " + e.getMessage(), e);
            throw e;
        }
        final UserGroupInformation ugi = userProvider.getCurrent().getUGI();
        Stoppable stoppable = new Stoppable(){
            private volatile boolean isStopped = false;

            @Override
            public void stop(String why) {
                this.isStopped = true;
            }

            @Override
            public boolean isStopped() {
                return this.isStopped;
            }
        };
        int CHECK_TGT_INTERVAL = 30000;
        ScheduledChore refreshCredentials = new ScheduledChore("RefreshCredentials", stoppable, 30000){

            @Override
            protected void chore() {
                try {
                    ugi.checkTGTAndReloginFromKeytab();
                }
                catch (IOException e) {
                    LOG.error("Got exception while trying to refresh credentials: " + e.getMessage(), e);
                }
            }
        };
        return refreshCredentials;
    }

    public static boolean isGroupPrincipal(String name) {
        return name != null && name.startsWith(GROUP_PREFIX);
    }

    public static String getGroupName(String aclKey) {
        if (!AuthUtil.isGroupPrincipal(aclKey)) {
            return aclKey;
        }
        return aclKey.substring(GROUP_PREFIX.length());
    }

    public static String toGroupEntry(String name) {
        return GROUP_PREFIX + name;
    }
}

