/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.web.security;

import com.mapr.web.security.WebSecurityConfig;
import java.io.IOException;
import java.util.Arrays;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hive.org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;

public class MapREntryPoint
implements AuthenticationEntryPoint {
    private boolean kerberosAuthEnabled;

    public MapREntryPoint() {
        String authMethods = System.getProperty(WebSecurityConfig.CONFIG.getProcessName() + ".mapr.rest.auth.methods");
        if (StringUtils.isNotBlank(authMethods)) {
            this.kerberosAuthEnabled = Arrays.asList(authMethods.split(",")).contains("kerberos");
        }
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        if (this.kerberosAuthEnabled) {
            response.setHeader("WWW-Authenticate", "Negotiate");
            response.sendError(401, "Authentication requested");
        } else {
            response.sendError(401, authException.getMessage());
        }
    }
}

