/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.hbase10.coprocessor;

import co.cask.tephra.Transaction;
import co.cask.tephra.TxConstants;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hive.com.google.common.collect.Maps;

public class TransactionVisibilityFilter
extends FilterBase {
    private final Transaction tx;
    private final Map<byte[], Long> oldestTsByFamily;
    private final boolean allowEmptyValues;
    private final boolean clearDeletes;
    private final Filter cellFilter;
    private byte[] currentFamily = new byte[0];
    private long currentOldestTs;
    private DeleteTracker deleteTracker = new DeleteTracker();

    public TransactionVisibilityFilter(Transaction tx, Map<byte[], Long> ttlByFamily, boolean allowEmptyValues, ScanType scanType) {
        this(tx, ttlByFamily, allowEmptyValues, scanType, null);
    }

    public TransactionVisibilityFilter(Transaction tx, Map<byte[], Long> ttlByFamily, boolean allowEmptyValues, ScanType scanType, @Nullable Filter cellFilter) {
        this.tx = tx;
        this.oldestTsByFamily = Maps.newTreeMap(Bytes.BYTES_COMPARATOR);
        for (Map.Entry<byte[], Long> ttlEntry : ttlByFamily.entrySet()) {
            long familyTTL = ttlEntry.getValue();
            this.oldestTsByFamily.put(ttlEntry.getKey(), familyTTL <= 0L ? 0L : tx.getVisibilityUpperBound() - familyTTL * 1000000L);
        }
        this.allowEmptyValues = allowEmptyValues;
        this.clearDeletes = scanType == ScanType.COMPACT_DROP_DELETES || scanType == ScanType.USER_SCAN;
        this.cellFilter = cellFilter;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell cell) throws IOException {
        long kvTimestamp;
        if (!CellUtil.matchingFamily(cell, this.currentFamily)) {
            this.currentFamily = CellUtil.cloneFamily(cell);
            Long familyOldestTs = this.oldestTsByFamily.get(this.currentFamily);
            this.currentOldestTs = familyOldestTs != null ? familyOldestTs : 0L;
            this.deleteTracker.reset();
        }
        if ((kvTimestamp = cell.getTimestamp()) < this.currentOldestTs) {
            return Filter.ReturnCode.NEXT_COL;
        }
        if (this.tx.isVisible(kvTimestamp)) {
            if (this.deleteTracker.isFamilyDelete(cell)) {
                this.deleteTracker.addFamilyDelete(cell);
                if (this.clearDeletes) {
                    return Filter.ReturnCode.NEXT_COL;
                }
                return Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
            }
            if (this.deleteTracker.isDeleted(cell)) {
                return Filter.ReturnCode.NEXT_COL;
            }
            if (cell.getValueLength() == 0 && !this.allowEmptyValues) {
                if (this.clearDeletes) {
                    return Filter.ReturnCode.NEXT_COL;
                }
                return Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
            }
            if (this.cellFilter != null) {
                return this.cellFilter.filterKeyValue(cell);
            }
            return Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
        }
        return Filter.ReturnCode.SKIP;
    }

    @Override
    public void reset() {
        this.deleteTracker.reset();
    }

    @Override
    public byte[] toByteArray() throws IOException {
        return super.toByteArray();
    }

    private static final class DeleteTracker {
        private long familyDeleteTs;

        private DeleteTracker() {
        }

        public boolean isFamilyDelete(Cell cell) {
            return CellUtil.matchingQualifier(cell, TxConstants.FAMILY_DELETE_QUALIFIER) && CellUtil.matchingValue(cell, HConstants.EMPTY_BYTE_ARRAY);
        }

        public void addFamilyDelete(Cell delete) {
            this.familyDeleteTs = delete.getTimestamp();
        }

        public boolean isDeleted(Cell cell) {
            return cell.getTimestamp() <= this.familyDeleteTs;
        }

        public void reset() {
            this.familyDeleteTs = 0L;
        }
    }
}

