/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.hbase10;

import co.cask.tephra.TransactionContext;
import co.cask.tephra.TransactionFailureException;
import co.cask.tephra.TransactionSystemClient;
import co.cask.tephra.distributed.TransactionServiceClient;
import co.cask.tephra.hbase10.TransactionAwareHTable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hive.com.google.common.base.Throwables;

public class SecondaryIndexTable {
    private byte[] secondaryIndex;
    private TransactionAwareHTable transactionAwareHTable;
    private TransactionAwareHTable secondaryIndexTable;
    private TransactionContext transactionContext;
    private final TableName secondaryIndexTableName;
    private static final byte[] secondaryIndexFamily = Bytes.toBytes("secondaryIndexFamily");
    private static final byte[] secondaryIndexQualifier = Bytes.toBytes(114);
    private static final byte[] DELIMITER = new byte[]{0};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecondaryIndexTable(TransactionServiceClient transactionServiceClient, HTableInterface hTable, byte[] secondaryIndex) {
        this.secondaryIndexTableName = TableName.valueOf(hTable.getName().getNameAsString() + ".idx");
        HTable secondaryIndexHTable = null;
        HBaseAdmin hBaseAdmin = null;
        try {
            hBaseAdmin = new HBaseAdmin(hTable.getConfiguration());
            if (!hBaseAdmin.tableExists(this.secondaryIndexTableName)) {
                hBaseAdmin.createTable(new HTableDescriptor(this.secondaryIndexTableName));
            }
            secondaryIndexHTable = new HTable(hTable.getConfiguration(), this.secondaryIndexTableName);
        }
        catch (Exception e) {
            Throwables.propagate(e);
        }
        finally {
            try {
                hBaseAdmin.close();
            }
            catch (Exception e) {
                Throwables.propagate(e);
            }
        }
        this.secondaryIndex = secondaryIndex;
        this.transactionAwareHTable = new TransactionAwareHTable(hTable);
        this.secondaryIndexTable = new TransactionAwareHTable(secondaryIndexHTable);
        this.transactionContext = new TransactionContext((TransactionSystemClient)transactionServiceClient, this.transactionAwareHTable, this.secondaryIndexTable);
    }

    public Result get(Get get) throws IOException {
        return this.get(Collections.singletonList(get))[0];
    }

    public Result[] get(List<Get> gets) throws IOException {
        try {
            this.transactionContext.start();
            Result[] result = this.transactionAwareHTable.get(gets);
            this.transactionContext.finish();
            return result;
        }
        catch (Exception e) {
            try {
                this.transactionContext.abort();
            }
            catch (TransactionFailureException e1) {
                throw new IOException("Could not rollback transaction", e1);
            }
            return null;
        }
    }

    public Result[] getByIndex(byte[] value) throws IOException {
        try {
            this.transactionContext.start();
            Scan scan = new Scan(value, Bytes.add(value, new byte[0]));
            scan.addColumn(secondaryIndexFamily, secondaryIndexQualifier);
            ResultScanner indexScanner = this.secondaryIndexTable.getScanner(scan);
            ArrayList<Get> gets = new ArrayList<Get>();
            for (Result result : indexScanner) {
                for (Cell cell : result.listCells()) {
                    gets.add(new Get(cell.getValue()));
                }
            }
            Result[] results = this.transactionAwareHTable.get(gets);
            this.transactionContext.finish();
            return results;
        }
        catch (Exception e) {
            try {
                this.transactionContext.abort();
            }
            catch (TransactionFailureException e1) {
                throw new IOException("Could not rollback transaction", e1);
            }
            return null;
        }
    }

    public void put(Put put) throws IOException {
        this.put(Collections.singletonList(put));
    }

    public void put(List<Put> puts) throws IOException {
        try {
            this.transactionContext.start();
            ArrayList<Put> secondaryIndexPuts = new ArrayList<Put>();
            for (Put put : puts) {
                ArrayList<Put> indexPuts = new ArrayList<Put>();
                Set familyMap = put.getFamilyMap().entrySet();
                for (Map.Entry family : familyMap) {
                    for (KeyValue value : (List)family.getValue()) {
                        if (!Bytes.equals(value.getQualifierArray(), value.getQualifierOffset(), value.getQualifierLength(), this.secondaryIndex, 0, this.secondaryIndex.length)) continue;
                        byte[] secondaryRow = Bytes.add(value.getQualifier(), DELIMITER, Bytes.add(value.getValue(), DELIMITER, value.getRow()));
                        Put indexPut = new Put(secondaryRow);
                        indexPut.add(secondaryIndexFamily, secondaryIndexQualifier, put.getRow());
                        indexPuts.add(indexPut);
                    }
                }
                secondaryIndexPuts.addAll(indexPuts);
            }
            this.transactionAwareHTable.put(puts);
            this.secondaryIndexTable.put(secondaryIndexPuts);
            this.transactionContext.finish();
        }
        catch (Exception e) {
            try {
                this.transactionContext.abort();
            }
            catch (TransactionFailureException e1) {
                throw new IOException("Could not rollback transaction", e1);
            }
        }
    }
}

