/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra;

import co.cask.tephra.AbstractTransactionExecutor;
import co.cask.tephra.RetryStrategies;
import co.cask.tephra.RetryStrategy;
import co.cask.tephra.TransactionAware;
import co.cask.tephra.TransactionContext;
import co.cask.tephra.TransactionExecutor;
import co.cask.tephra.TransactionFailureException;
import co.cask.tephra.TransactionSystemClient;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.hive.com.google.common.collect.ImmutableList;
import org.apache.hive.com.google.common.util.concurrent.MoreExecutors;

public class DefaultTransactionExecutor
extends AbstractTransactionExecutor {
    private final Collection<TransactionAware> txAwares;
    private final TransactionSystemClient txClient;
    private final RetryStrategy retryStrategy;

    public DefaultTransactionExecutor(TransactionSystemClient txClient, TransactionAware ... txAwares) {
        this(txClient, Arrays.asList(txAwares));
    }

    public DefaultTransactionExecutor(TransactionSystemClient txClient, Iterable<TransactionAware> txAwares, RetryStrategy retryStrategy) {
        super(MoreExecutors.sameThreadExecutor());
        this.txAwares = ImmutableList.copyOf(txAwares);
        this.txClient = txClient;
        this.retryStrategy = retryStrategy;
    }

    @Inject
    public DefaultTransactionExecutor(TransactionSystemClient txClient, @Assisted Iterable<TransactionAware> txAwares) {
        this(txClient, txAwares, RetryStrategies.retryOnConflict(20, 100L));
    }

    @Override
    public <I, O> O execute(TransactionExecutor.Function<I, O> function, I input) throws TransactionFailureException, InterruptedException {
        return this.executeWithRetry(function, input);
    }

    @Override
    public <I> void execute(final TransactionExecutor.Procedure<I> procedure, I input) throws TransactionFailureException, InterruptedException {
        this.execute(new TransactionExecutor.Function<I, Void>(){

            @Override
            public Void apply(I input) throws Exception {
                procedure.apply(input);
                return null;
            }
        }, input);
    }

    @Override
    public <O> O execute(final Callable<O> callable) throws TransactionFailureException, InterruptedException {
        return this.execute(new TransactionExecutor.Function<Void, O>(){

            @Override
            public O apply(Void input) throws Exception {
                return callable.call();
            }
        }, null);
    }

    @Override
    public void execute(final TransactionExecutor.Subroutine subroutine) throws TransactionFailureException, InterruptedException {
        this.execute(new TransactionExecutor.Function<Void, Void>(){

            @Override
            public Void apply(Void input) throws Exception {
                subroutine.apply();
                return null;
            }
        }, null);
    }

    private <I, O> O executeWithRetry(TransactionExecutor.Function<I, O> function, I input) throws TransactionFailureException, InterruptedException {
        int retries = 0;
        while (true) {
            try {
                return this.executeOnce(function, input);
            }
            catch (TransactionFailureException e) {
                long delay = this.retryStrategy.nextRetry(e, ++retries);
                if (delay < 0L) {
                    throw e;
                }
                if (delay <= 0L) continue;
                TimeUnit.MILLISECONDS.sleep(delay);
                continue;
            }
            break;
        }
    }

    private <I, O> O executeOnce(TransactionExecutor.Function<I, O> function, I input) throws TransactionFailureException {
        TransactionContext txContext = new TransactionContext(this.txClient, this.txAwares);
        txContext.start();
        O o = null;
        try {
            o = function.apply(input);
        }
        catch (Throwable e) {
            txContext.abort(new TransactionFailureException("Transaction function failure for transaction. ", e));
        }
        txContext.finish();
        return o;
    }
}

