/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.thrift;

import java.util.ArrayList;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.common.auth.HiveAuthUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.hive.service.server.ThreadFactoryWithGarbageCleanup;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TTransportFactory;

public class ThriftBinaryCLIService
extends ThriftCLIService {
    public ThriftBinaryCLIService(CLIService cliService) {
        super(cliService, ThriftBinaryCLIService.class.getSimpleName());
    }

    @Override
    public void run() {
        try {
            String threadPoolName = "HiveServer2-Handler-Pool";
            ThreadPoolExecutor executorService = new ThreadPoolExecutor(this.minWorkerThreads, this.maxWorkerThreads, this.workerKeepAliveTime, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactoryWithGarbageCleanup(threadPoolName));
            hiveAuthFactory = new HiveAuthFactory(this.hiveConf);
            TTransportFactory transportFactory = hiveAuthFactory.getAuthTransFactory();
            TProcessorFactory processorFactory = hiveAuthFactory.getAuthProcFactory(this);
            TServerSocket serverSocket = null;
            ArrayList<String> sslVersionBlacklist = new ArrayList<String>();
            for (String sslVersion : this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SSL_PROTOCOL_BLACKLIST).split(",")) {
                sslVersionBlacklist.add(sslVersion);
            }
            if (!this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_USE_SSL)) {
                serverSocket = HiveAuthUtils.getServerSocket(this.hiveHost, this.portNum);
            } else {
                String keyStorePath = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PATH).trim();
                if (keyStorePath.isEmpty()) {
                    throw new IllegalArgumentException(HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PATH.varname + " Not configured for SSL connection");
                }
                String keyStorePassword = ShimLoader.getHadoopShims().getPassword(this.hiveConf, HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PASSWORD.varname);
                serverSocket = HiveAuthUtils.getServerSSLSocket(this.hiveHost, this.portNum, keyStorePath, keyStorePassword, sslVersionBlacklist);
            }
            int maxMessageSize = this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_MAX_MESSAGE_SIZE);
            int requestTimeout = (int)this.hiveConf.getTimeVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_LOGIN_TIMEOUT, TimeUnit.SECONDS);
            int beBackoffSlotLength = (int)this.hiveConf.getTimeVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_LOGIN_BEBACKOFF_SLOT_LENGTH, TimeUnit.MILLISECONDS);
            TThreadPoolServer.Args sargs = ((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args(serverSocket).processorFactory(processorFactory)).transportFactory(transportFactory)).protocolFactory(new TBinaryProtocol.Factory())).inputProtocolFactory(new TBinaryProtocol.Factory(true, true, maxMessageSize, maxMessageSize))).requestTimeout(requestTimeout).requestTimeoutUnit(TimeUnit.SECONDS).beBackoffSlotLength(beBackoffSlotLength).beBackoffSlotLengthUnit(TimeUnit.MILLISECONDS).executorService(executorService);
            this.server = new TThreadPoolServer(sargs);
            this.server.setServerEventHandler(this.serverEventHandler);
            String msg = "Starting " + ThriftBinaryCLIService.class.getSimpleName() + " on port " + this.portNum + " with " + this.minWorkerThreads + "..." + this.maxWorkerThreads + " worker threads";
            LOG.info(msg);
            this.server.serve();
        }
        catch (Throwable t) {
            LOG.fatal("Error starting HiveServer2: could not start " + ThriftBinaryCLIService.class.getSimpleName(), t);
            System.exit(-1);
        }
    }
}

