/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.hive.jdbc.Utils;
import org.apache.hive.jdbc.ZooKeeperHiveClientException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

public class ZooKeeperHiveClientHelper {
    public static final Log LOG = LogFactory.getLog(ZooKeeperHiveClientHelper.class.getName());

    static String getNextServerUriFromZooKeeper(Utils.JdbcConnectionParams connParams) throws ZooKeeperHiveClientException {
        String zooKeeperEnsemble = connParams.getZooKeeperEnsemble();
        String zooKeeperNamespace = connParams.getSessionVars().get("zooKeeperNamespace");
        if (zooKeeperNamespace == null || zooKeeperNamespace.isEmpty()) {
            zooKeeperNamespace = "hiveserver2";
        }
        Random randomizer = new Random();
        try (CuratorFramework zooKeeperClient = CuratorFrameworkFactory.builder().connectString(zooKeeperEnsemble).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(1000, 3)).build();){
            zooKeeperClient.start();
            List serverHosts = (List)zooKeeperClient.getChildren().forPath("/" + zooKeeperNamespace);
            serverHosts.removeAll(connParams.getRejectedHostZnodePaths());
            if (serverHosts.isEmpty()) {
                throw new ZooKeeperHiveClientException("Tried all existing HiveServer2 uris from ZooKeeper.");
            }
            String serverNode = (String)serverHosts.get(randomizer.nextInt(serverHosts.size()));
            connParams.setCurrentHostZnodePath(serverNode);
            String serverUri = new String((byte[])zooKeeperClient.getData().forPath("/" + zooKeeperNamespace + "/" + serverNode), Charset.forName("UTF-8"));
            LOG.info("Selected HiveServer2 instance with uri: " + serverUri);
            String string = serverUri;
            return string;
        }
    }

    public static class DummyWatcher
    implements Watcher {
        public void process(WatchedEvent event) {
        }
    }
}

