/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.thrift;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.thrift.DelegationTokenIdentifier;
import org.apache.hadoop.hive.thrift.DelegationTokenStore;
import org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge;
import org.apache.hadoop.hive.thrift.TokenStoreDelegationTokenSecretManager;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.HiveDelegationTokenSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBTokenStore
implements DelegationTokenStore {
    private static final Logger LOG = LoggerFactory.getLogger(DBTokenStore.class);
    private Object rawStore;

    @Override
    public int addMasterKey(String s) throws DelegationTokenStore.TokenStoreException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("addMasterKey: s = " + s);
        }
        return (Integer)this.invokeOnRawStore("addMasterKey", new Object[]{s}, String.class);
    }

    @Override
    public void updateMasterKey(int keySeq, String s) throws DelegationTokenStore.TokenStoreException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("updateMasterKey: s = " + s + ", keySeq = " + keySeq);
        }
        this.invokeOnRawStore("updateMasterKey", new Object[]{keySeq, s}, Integer.class, String.class);
    }

    @Override
    public boolean removeMasterKey(int keySeq) {
        return (Boolean)this.invokeOnRawStore("removeMasterKey", new Object[]{keySeq}, Integer.class);
    }

    @Override
    public String[] getMasterKeys() throws DelegationTokenStore.TokenStoreException {
        return (String[])this.invokeOnRawStore("getMasterKeys", new Object[0], new Class[0]);
    }

    @Override
    public boolean addToken(DelegationTokenIdentifier tokenIdentifier, AbstractDelegationTokenSecretManager.DelegationTokenInformation token) throws DelegationTokenStore.TokenStoreException {
        try {
            String identifier = TokenStoreDelegationTokenSecretManager.encodeWritable((Writable)tokenIdentifier);
            String tokenStr = Base64.encodeBase64URLSafeString(HiveDelegationTokenSupport.encodeDelegationTokenInformation(token));
            boolean result = (Boolean)this.invokeOnRawStore("addToken", new Object[]{identifier, tokenStr}, String.class, String.class);
            if (LOG.isTraceEnabled()) {
                LOG.trace("addToken: tokenIdentifier = " + (Object)((Object)tokenIdentifier) + ", added = " + result);
            }
            return result;
        }
        catch (IOException e) {
            throw new DelegationTokenStore.TokenStoreException(e);
        }
    }

    @Override
    public AbstractDelegationTokenSecretManager.DelegationTokenInformation getToken(DelegationTokenIdentifier tokenIdentifier) throws DelegationTokenStore.TokenStoreException {
        try {
            String tokenStr = (String)this.invokeOnRawStore("getToken", new Object[]{TokenStoreDelegationTokenSecretManager.encodeWritable((Writable)tokenIdentifier)}, String.class);
            AbstractDelegationTokenSecretManager.DelegationTokenInformation result = null;
            if (tokenStr != null) {
                result = HiveDelegationTokenSupport.decodeDelegationTokenInformation(Base64.decodeBase64(tokenStr));
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("getToken: tokenIdentifier = " + (Object)((Object)tokenIdentifier) + ", result = " + result);
            }
            return result;
        }
        catch (IOException e) {
            throw new DelegationTokenStore.TokenStoreException(e);
        }
    }

    @Override
    public boolean removeToken(DelegationTokenIdentifier tokenIdentifier) throws DelegationTokenStore.TokenStoreException {
        try {
            boolean result = (Boolean)this.invokeOnRawStore("removeToken", new Object[]{TokenStoreDelegationTokenSecretManager.encodeWritable((Writable)tokenIdentifier)}, String.class);
            if (LOG.isTraceEnabled()) {
                LOG.trace("removeToken: tokenIdentifier = " + (Object)((Object)tokenIdentifier) + ", removed = " + result);
            }
            return result;
        }
        catch (IOException e) {
            throw new DelegationTokenStore.TokenStoreException(e);
        }
    }

    @Override
    public List<DelegationTokenIdentifier> getAllDelegationTokenIdentifiers() throws DelegationTokenStore.TokenStoreException {
        List tokenIdents = (List)this.invokeOnRawStore("getAllTokenIdentifiers", new Object[0], new Class[0]);
        ArrayList<DelegationTokenIdentifier> delTokenIdents = new ArrayList<DelegationTokenIdentifier>(tokenIdents.size());
        for (String tokenIdent : tokenIdents) {
            DelegationTokenIdentifier delToken = new DelegationTokenIdentifier();
            try {
                TokenStoreDelegationTokenSecretManager.decodeWritable((Writable)delToken, tokenIdent);
            }
            catch (IOException e) {
                throw new DelegationTokenStore.TokenStoreException(e);
            }
            delTokenIdents.add(delToken);
        }
        return delTokenIdents;
    }

    @Override
    public void init(Object rawStore, HadoopThriftAuthBridge.Server.ServerMode smode) throws DelegationTokenStore.TokenStoreException {
        this.rawStore = rawStore;
    }

    private Object invokeOnRawStore(String methName, Object[] params, Class<?> ... paramTypes) throws DelegationTokenStore.TokenStoreException {
        try {
            return this.rawStore.getClass().getMethod(methName, paramTypes).invoke(this.rawStore, params);
        }
        catch (IllegalArgumentException e) {
            throw new DelegationTokenStore.TokenStoreException(e);
        }
        catch (SecurityException e) {
            throw new DelegationTokenStore.TokenStoreException(e);
        }
        catch (IllegalAccessException e) {
            throw new DelegationTokenStore.TokenStoreException(e);
        }
        catch (InvocationTargetException e) {
            throw new DelegationTokenStore.TokenStoreException(e.getCause());
        }
        catch (NoSuchMethodException e) {
            throw new DelegationTokenStore.TokenStoreException(e);
        }
    }

    public void setConf(Configuration conf) {
    }

    public Configuration getConf() {
        return null;
    }

    @Override
    public void close() throws IOException {
    }
}

