/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;

public class Database
implements TBase<Database, _Fields>,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("Database");
    private static final TField NAME_FIELD_DESC = new TField("name", 11, 1);
    private static final TField DESCRIPTION_FIELD_DESC = new TField("description", 11, 2);
    private static final TField LOCATION_URI_FIELD_DESC = new TField("locationUri", 11, 3);
    private static final TField PARAMETERS_FIELD_DESC = new TField("parameters", 13, 4);
    private static final TField PRIVILEGES_FIELD_DESC = new TField("privileges", 12, 5);
    private static final TField OWNER_NAME_FIELD_DESC = new TField("ownerName", 11, 6);
    private static final TField OWNER_TYPE_FIELD_DESC = new TField("ownerType", 8, 7);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    private String name;
    private String description;
    private String locationUri;
    private Map<String, String> parameters;
    private PrincipalPrivilegeSet privileges;
    private String ownerName;
    private PrincipalType ownerType;
    private _Fields[] optionals = new _Fields[]{_Fields.PRIVILEGES, _Fields.OWNER_NAME, _Fields.OWNER_TYPE};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public Database() {
    }

    public Database(String name, String description, String locationUri, Map<String, String> parameters) {
        this();
        this.name = name;
        this.description = description;
        this.locationUri = locationUri;
        this.parameters = parameters;
    }

    public Database(Database other) {
        if (other.isSetName()) {
            this.name = other.name;
        }
        if (other.isSetDescription()) {
            this.description = other.description;
        }
        if (other.isSetLocationUri()) {
            this.locationUri = other.locationUri;
        }
        if (other.isSetParameters()) {
            HashMap<String, String> __this__parameters = new HashMap<String, String>();
            for (Map.Entry<String, String> other_element : other.parameters.entrySet()) {
                String other_element_key = other_element.getKey();
                String other_element_value = other_element.getValue();
                String __this__parameters_copy_key = other_element_key;
                String __this__parameters_copy_value = other_element_value;
                __this__parameters.put(__this__parameters_copy_key, __this__parameters_copy_value);
            }
            this.parameters = __this__parameters;
        }
        if (other.isSetPrivileges()) {
            this.privileges = new PrincipalPrivilegeSet(other.privileges);
        }
        if (other.isSetOwnerName()) {
            this.ownerName = other.ownerName;
        }
        if (other.isSetOwnerType()) {
            this.ownerType = other.ownerType;
        }
    }

    public Database deepCopy() {
        return new Database(this);
    }

    @Override
    public void clear() {
        this.name = null;
        this.description = null;
        this.locationUri = null;
        this.parameters = null;
        this.privileges = null;
        this.ownerName = null;
        this.ownerType = null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void unsetName() {
        this.name = null;
    }

    public boolean isSetName() {
        return this.name != null;
    }

    public void setNameIsSet(boolean value) {
        if (!value) {
            this.name = null;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void unsetDescription() {
        this.description = null;
    }

    public boolean isSetDescription() {
        return this.description != null;
    }

    public void setDescriptionIsSet(boolean value) {
        if (!value) {
            this.description = null;
        }
    }

    public String getLocationUri() {
        return this.locationUri;
    }

    public void setLocationUri(String locationUri) {
        this.locationUri = locationUri;
    }

    public void unsetLocationUri() {
        this.locationUri = null;
    }

    public boolean isSetLocationUri() {
        return this.locationUri != null;
    }

    public void setLocationUriIsSet(boolean value) {
        if (!value) {
            this.locationUri = null;
        }
    }

    public int getParametersSize() {
        return this.parameters == null ? 0 : this.parameters.size();
    }

    public void putToParameters(String key, String val) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        this.parameters.put(key, val);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void unsetParameters() {
        this.parameters = null;
    }

    public boolean isSetParameters() {
        return this.parameters != null;
    }

    public void setParametersIsSet(boolean value) {
        if (!value) {
            this.parameters = null;
        }
    }

    public PrincipalPrivilegeSet getPrivileges() {
        return this.privileges;
    }

    public void setPrivileges(PrincipalPrivilegeSet privileges) {
        this.privileges = privileges;
    }

    public void unsetPrivileges() {
        this.privileges = null;
    }

    public boolean isSetPrivileges() {
        return this.privileges != null;
    }

    public void setPrivilegesIsSet(boolean value) {
        if (!value) {
            this.privileges = null;
        }
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public void unsetOwnerName() {
        this.ownerName = null;
    }

    public boolean isSetOwnerName() {
        return this.ownerName != null;
    }

    public void setOwnerNameIsSet(boolean value) {
        if (!value) {
            this.ownerName = null;
        }
    }

    public PrincipalType getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(PrincipalType ownerType) {
        this.ownerType = ownerType;
    }

    public void unsetOwnerType() {
        this.ownerType = null;
    }

    public boolean isSetOwnerType() {
        return this.ownerType != null;
    }

    public void setOwnerTypeIsSet(boolean value) {
        if (!value) {
            this.ownerType = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case NAME: {
                if (value == null) {
                    this.unsetName();
                    break;
                }
                this.setName((String)value);
                break;
            }
            case DESCRIPTION: {
                if (value == null) {
                    this.unsetDescription();
                    break;
                }
                this.setDescription((String)value);
                break;
            }
            case LOCATION_URI: {
                if (value == null) {
                    this.unsetLocationUri();
                    break;
                }
                this.setLocationUri((String)value);
                break;
            }
            case PARAMETERS: {
                if (value == null) {
                    this.unsetParameters();
                    break;
                }
                this.setParameters((Map)value);
                break;
            }
            case PRIVILEGES: {
                if (value == null) {
                    this.unsetPrivileges();
                    break;
                }
                this.setPrivileges((PrincipalPrivilegeSet)value);
                break;
            }
            case OWNER_NAME: {
                if (value == null) {
                    this.unsetOwnerName();
                    break;
                }
                this.setOwnerName((String)value);
                break;
            }
            case OWNER_TYPE: {
                if (value == null) {
                    this.unsetOwnerType();
                    break;
                }
                this.setOwnerType((PrincipalType)value);
            }
        }
    }

    @Override
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case NAME: {
                return this.getName();
            }
            case DESCRIPTION: {
                return this.getDescription();
            }
            case LOCATION_URI: {
                return this.getLocationUri();
            }
            case PARAMETERS: {
                return this.getParameters();
            }
            case PRIVILEGES: {
                return this.getPrivileges();
            }
            case OWNER_NAME: {
                return this.getOwnerName();
            }
            case OWNER_TYPE: {
                return this.getOwnerType();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case NAME: {
                return this.isSetName();
            }
            case DESCRIPTION: {
                return this.isSetDescription();
            }
            case LOCATION_URI: {
                return this.isSetLocationUri();
            }
            case PARAMETERS: {
                return this.isSetParameters();
            }
            case PRIVILEGES: {
                return this.isSetPrivileges();
            }
            case OWNER_NAME: {
                return this.isSetOwnerName();
            }
            case OWNER_TYPE: {
                return this.isSetOwnerType();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof Database) {
            return this.equals((Database)that);
        }
        return false;
    }

    public boolean equals(Database that) {
        if (that == null) {
            return false;
        }
        boolean this_present_name = this.isSetName();
        boolean that_present_name = that.isSetName();
        if (this_present_name || that_present_name) {
            if (!this_present_name || !that_present_name) {
                return false;
            }
            if (!this.name.equals(that.name)) {
                return false;
            }
        }
        boolean this_present_description = this.isSetDescription();
        boolean that_present_description = that.isSetDescription();
        if (this_present_description || that_present_description) {
            if (!this_present_description || !that_present_description) {
                return false;
            }
            if (!this.description.equals(that.description)) {
                return false;
            }
        }
        boolean this_present_locationUri = this.isSetLocationUri();
        boolean that_present_locationUri = that.isSetLocationUri();
        if (this_present_locationUri || that_present_locationUri) {
            if (!this_present_locationUri || !that_present_locationUri) {
                return false;
            }
            if (!this.locationUri.equals(that.locationUri)) {
                return false;
            }
        }
        boolean this_present_parameters = this.isSetParameters();
        boolean that_present_parameters = that.isSetParameters();
        if (this_present_parameters || that_present_parameters) {
            if (!this_present_parameters || !that_present_parameters) {
                return false;
            }
            if (!this.parameters.equals(that.parameters)) {
                return false;
            }
        }
        boolean this_present_privileges = this.isSetPrivileges();
        boolean that_present_privileges = that.isSetPrivileges();
        if (this_present_privileges || that_present_privileges) {
            if (!this_present_privileges || !that_present_privileges) {
                return false;
            }
            if (!this.privileges.equals(that.privileges)) {
                return false;
            }
        }
        boolean this_present_ownerName = this.isSetOwnerName();
        boolean that_present_ownerName = that.isSetOwnerName();
        if (this_present_ownerName || that_present_ownerName) {
            if (!this_present_ownerName || !that_present_ownerName) {
                return false;
            }
            if (!this.ownerName.equals(that.ownerName)) {
                return false;
            }
        }
        boolean this_present_ownerType = this.isSetOwnerType();
        boolean that_present_ownerType = that.isSetOwnerType();
        if (this_present_ownerType || that_present_ownerType) {
            if (!this_present_ownerType || !that_present_ownerType) {
                return false;
            }
            if (!this.ownerType.equals(that.ownerType)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_name = this.isSetName();
        builder.append(present_name);
        if (present_name) {
            builder.append(this.name);
        }
        boolean present_description = this.isSetDescription();
        builder.append(present_description);
        if (present_description) {
            builder.append(this.description);
        }
        boolean present_locationUri = this.isSetLocationUri();
        builder.append(present_locationUri);
        if (present_locationUri) {
            builder.append(this.locationUri);
        }
        boolean present_parameters = this.isSetParameters();
        builder.append(present_parameters);
        if (present_parameters) {
            builder.append(this.parameters);
        }
        boolean present_privileges = this.isSetPrivileges();
        builder.append(present_privileges);
        if (present_privileges) {
            builder.append(this.privileges);
        }
        boolean present_ownerName = this.isSetOwnerName();
        builder.append(present_ownerName);
        if (present_ownerName) {
            builder.append(this.ownerName);
        }
        boolean present_ownerType = this.isSetOwnerType();
        builder.append(present_ownerType);
        if (present_ownerType) {
            builder.append(this.ownerType.getValue());
        }
        return builder.toHashCode();
    }

    @Override
    public int compareTo(Database other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        Database typedOther = other;
        lastComparison = Boolean.valueOf(this.isSetName()).compareTo(typedOther.isSetName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetName() && (lastComparison = TBaseHelper.compareTo(this.name, typedOther.name)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDescription()).compareTo(typedOther.isSetDescription());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDescription() && (lastComparison = TBaseHelper.compareTo(this.description, typedOther.description)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLocationUri()).compareTo(typedOther.isSetLocationUri());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetLocationUri() && (lastComparison = TBaseHelper.compareTo(this.locationUri, typedOther.locationUri)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetParameters()).compareTo(typedOther.isSetParameters());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetParameters() && (lastComparison = TBaseHelper.compareTo(this.parameters, typedOther.parameters)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetPrivileges()).compareTo(typedOther.isSetPrivileges());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPrivileges() && (lastComparison = TBaseHelper.compareTo(this.privileges, typedOther.privileges)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetOwnerName()).compareTo(typedOther.isSetOwnerName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOwnerName() && (lastComparison = TBaseHelper.compareTo(this.ownerName, typedOther.ownerName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetOwnerType()).compareTo(typedOther.isSetOwnerType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOwnerType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.ownerType), (Comparable)((Object)typedOther.ownerType))) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (Database)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (Database)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Database(");
        boolean first = true;
        sb.append("name:");
        if (this.name == null) {
            sb.append("null");
        } else {
            sb.append(this.name);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("description:");
        if (this.description == null) {
            sb.append("null");
        } else {
            sb.append(this.description);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("locationUri:");
        if (this.locationUri == null) {
            sb.append("null");
        } else {
            sb.append(this.locationUri);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("parameters:");
        if (this.parameters == null) {
            sb.append("null");
        } else {
            sb.append(this.parameters);
        }
        first = false;
        if (this.isSetPrivileges()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("privileges:");
            if (this.privileges == null) {
                sb.append("null");
            } else {
                sb.append(this.privileges);
            }
            first = false;
        }
        if (this.isSetOwnerName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("ownerName:");
            if (this.ownerName == null) {
                sb.append("null");
            } else {
                sb.append(this.ownerName);
            }
            first = false;
        }
        if (this.isSetOwnerType()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("ownerType:");
            if (this.ownerType == null) {
                sb.append("null");
            } else {
                sb.append(this.ownerType);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.privileges != null) {
            this.privileges.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new DatabaseStandardSchemeFactory());
        schemes.put(TupleScheme.class, new DatabaseTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.NAME, new FieldMetaData("name", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.DESCRIPTION, new FieldMetaData("description", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.LOCATION_URI, new FieldMetaData("locationUri", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PARAMETERS, new FieldMetaData("parameters", 3, new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        tmpMap.put(_Fields.PRIVILEGES, new FieldMetaData("privileges", 2, new StructMetaData(12, PrincipalPrivilegeSet.class)));
        tmpMap.put(_Fields.OWNER_NAME, new FieldMetaData("ownerName", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.OWNER_TYPE, new FieldMetaData("ownerType", 2, new EnumMetaData(16, PrincipalType.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(Database.class, metaDataMap);
    }

    private static class DatabaseTupleScheme
    extends TupleScheme<Database> {
        private DatabaseTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, Database struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetName()) {
                optionals.set(0);
            }
            if (struct.isSetDescription()) {
                optionals.set(1);
            }
            if (struct.isSetLocationUri()) {
                optionals.set(2);
            }
            if (struct.isSetParameters()) {
                optionals.set(3);
            }
            if (struct.isSetPrivileges()) {
                optionals.set(4);
            }
            if (struct.isSetOwnerName()) {
                optionals.set(5);
            }
            if (struct.isSetOwnerType()) {
                optionals.set(6);
            }
            oprot.writeBitSet(optionals, 7);
            if (struct.isSetName()) {
                oprot.writeString(struct.name);
            }
            if (struct.isSetDescription()) {
                oprot.writeString(struct.description);
            }
            if (struct.isSetLocationUri()) {
                oprot.writeString(struct.locationUri);
            }
            if (struct.isSetParameters()) {
                oprot.writeI32(struct.parameters.size());
                for (Map.Entry _iter99 : struct.parameters.entrySet()) {
                    oprot.writeString((String)_iter99.getKey());
                    oprot.writeString((String)_iter99.getValue());
                }
            }
            if (struct.isSetPrivileges()) {
                struct.privileges.write(oprot);
            }
            if (struct.isSetOwnerName()) {
                oprot.writeString(struct.ownerName);
            }
            if (struct.isSetOwnerType()) {
                oprot.writeI32(struct.ownerType.getValue());
            }
        }

        @Override
        public void read(TProtocol prot, Database struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(7);
            if (incoming.get(0)) {
                struct.name = iprot.readString();
                struct.setNameIsSet(true);
            }
            if (incoming.get(1)) {
                struct.description = iprot.readString();
                struct.setDescriptionIsSet(true);
            }
            if (incoming.get(2)) {
                struct.locationUri = iprot.readString();
                struct.setLocationUriIsSet(true);
            }
            if (incoming.get(3)) {
                TMap _map100 = new TMap(11, 11, iprot.readI32());
                struct.parameters = new HashMap(2 * _map100.size);
                for (int _i101 = 0; _i101 < _map100.size; ++_i101) {
                    String _key102 = iprot.readString();
                    String _val103 = iprot.readString();
                    struct.parameters.put(_key102, _val103);
                }
                struct.setParametersIsSet(true);
            }
            if (incoming.get(4)) {
                struct.privileges = new PrincipalPrivilegeSet();
                struct.privileges.read(iprot);
                struct.setPrivilegesIsSet(true);
            }
            if (incoming.get(5)) {
                struct.ownerName = iprot.readString();
                struct.setOwnerNameIsSet(true);
            }
            if (incoming.get(6)) {
                struct.ownerType = PrincipalType.findByValue(iprot.readI32());
                struct.setOwnerTypeIsSet(true);
            }
        }
    }

    private static class DatabaseTupleSchemeFactory
    implements SchemeFactory {
        private DatabaseTupleSchemeFactory() {
        }

        public DatabaseTupleScheme getScheme() {
            return new DatabaseTupleScheme();
        }
    }

    private static class DatabaseStandardScheme
    extends StandardScheme<Database> {
        private DatabaseStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, Database struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.name = iprot.readString();
                            struct.setNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.description = iprot.readString();
                            struct.setDescriptionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.locationUri = iprot.readString();
                            struct.setLocationUriIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 13) {
                            TMap _map94 = iprot.readMapBegin();
                            struct.parameters = new HashMap(2 * _map94.size);
                            for (int _i95 = 0; _i95 < _map94.size; ++_i95) {
                                String _key96 = iprot.readString();
                                String _val97 = iprot.readString();
                                struct.parameters.put(_key96, _val97);
                            }
                            iprot.readMapEnd();
                            struct.setParametersIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 12) {
                            struct.privileges = new PrincipalPrivilegeSet();
                            struct.privileges.read(iprot);
                            struct.setPrivilegesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 11) {
                            struct.ownerName = iprot.readString();
                            struct.setOwnerNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 8) {
                            struct.ownerType = PrincipalType.findByValue(iprot.readI32());
                            struct.setOwnerTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, Database struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.name != null) {
                oprot.writeFieldBegin(NAME_FIELD_DESC);
                oprot.writeString(struct.name);
                oprot.writeFieldEnd();
            }
            if (struct.description != null) {
                oprot.writeFieldBegin(DESCRIPTION_FIELD_DESC);
                oprot.writeString(struct.description);
                oprot.writeFieldEnd();
            }
            if (struct.locationUri != null) {
                oprot.writeFieldBegin(LOCATION_URI_FIELD_DESC);
                oprot.writeString(struct.locationUri);
                oprot.writeFieldEnd();
            }
            if (struct.parameters != null) {
                oprot.writeFieldBegin(PARAMETERS_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 11, struct.parameters.size()));
                for (Map.Entry _iter98 : struct.parameters.entrySet()) {
                    oprot.writeString((String)_iter98.getKey());
                    oprot.writeString((String)_iter98.getValue());
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.privileges != null && struct.isSetPrivileges()) {
                oprot.writeFieldBegin(PRIVILEGES_FIELD_DESC);
                struct.privileges.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.ownerName != null && struct.isSetOwnerName()) {
                oprot.writeFieldBegin(OWNER_NAME_FIELD_DESC);
                oprot.writeString(struct.ownerName);
                oprot.writeFieldEnd();
            }
            if (struct.ownerType != null && struct.isSetOwnerType()) {
                oprot.writeFieldBegin(OWNER_TYPE_FIELD_DESC);
                oprot.writeI32(struct.ownerType.getValue());
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class DatabaseStandardSchemeFactory
    implements SchemeFactory {
        private DatabaseStandardSchemeFactory() {
        }

        public DatabaseStandardScheme getScheme() {
            return new DatabaseStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        NAME(1, "name"),
        DESCRIPTION(2, "description"),
        LOCATION_URI(3, "locationUri"),
        PARAMETERS(4, "parameters"),
        PRIVILEGES(5, "privileges"),
        OWNER_NAME(6, "ownerName"),
        OWNER_TYPE(7, "ownerType");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return NAME;
                }
                case 2: {
                    return DESCRIPTION;
                }
                case 3: {
                    return LOCATION_URI;
                }
                case 4: {
                    return PARAMETERS;
                }
                case 5: {
                    return PRIVILEGES;
                }
                case 6: {
                    return OWNER_NAME;
                }
                case 7: {
                    return OWNER_TYPE;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

