/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.storage.jdbc;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hive.storage.jdbc.JdbcInputSplit;
import org.apache.hive.storage.jdbc.JdbcRecordReader;
import org.apache.hive.storage.jdbc.dao.DatabaseAccessor;
import org.apache.hive.storage.jdbc.dao.DatabaseAccessorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcInputFormat
extends HiveInputFormat<LongWritable, MapWritable> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcInputFormat.class);
    private DatabaseAccessor dbAccessor = null;

    public RecordReader<LongWritable, MapWritable> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        if (!(split instanceof JdbcInputSplit)) {
            throw new RuntimeException("Incompatible split type " + split.getClass().getName() + ".");
        }
        return new JdbcRecordReader(job, (JdbcInputSplit)split);
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        try {
            int numRecords;
            LOGGER.debug("Creating {} input splits", (Object)numSplits);
            if (this.dbAccessor == null) {
                this.dbAccessor = DatabaseAccessorFactory.getAccessor((Configuration)job);
            }
            int n = numRecords = numSplits <= 1 ? Integer.MAX_VALUE : this.dbAccessor.getTotalNumberOfRecords((Configuration)job);
            if (numRecords < numSplits) {
                numSplits = numRecords;
            }
            if (numSplits <= 0) {
                numSplits = 1;
            }
            int numRecordsPerSplit = numRecords / numSplits;
            int numSplitsWithExtraRecords = numRecords % numSplits;
            LOGGER.debug("Num records = {}", (Object)numRecords);
            InputSplit[] splits = new InputSplit[numSplits];
            Path[] tablePaths = FileInputFormat.getInputPaths((JobConf)job);
            int offset = 0;
            for (int i = 0; i < numSplits; ++i) {
                int numRecordsInThisSplit = numRecordsPerSplit;
                if (i < numSplitsWithExtraRecords) {
                    ++numRecordsInThisSplit;
                }
                splits[i] = new JdbcInputSplit(numRecordsInThisSplit, offset, tablePaths[0]);
                offset += numRecordsInThisSplit;
            }
            this.dbAccessor = null;
            return splits;
        }
        catch (Exception e) {
            LOGGER.error("Error while splitting input data.", (Throwable)e);
            throw new IOException(e);
        }
    }

    public void setDbAccessor(DatabaseAccessor dbAccessor) {
        this.dbAccessor = dbAccessor;
    }
}

