/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.storage.jdbc.dao;

import org.apache.hadoop.conf.Configuration;
import org.apache.hive.storage.jdbc.conf.DatabaseType;
import org.apache.hive.storage.jdbc.conf.JdbcStorageConfig;
import org.apache.hive.storage.jdbc.dao.DatabaseAccessor;
import org.apache.hive.storage.jdbc.dao.GenericJdbcDatabaseAccessor;
import org.apache.hive.storage.jdbc.dao.MySqlDatabaseAccessor;

public class DatabaseAccessorFactory {
    private DatabaseAccessorFactory() {
    }

    public static DatabaseAccessor getAccessor(DatabaseType dbType) {
        GenericJdbcDatabaseAccessor accessor = null;
        switch (dbType) {
            case MYSQL: {
                accessor = new MySqlDatabaseAccessor();
                break;
            }
            default: {
                accessor = new GenericJdbcDatabaseAccessor();
            }
        }
        return accessor;
    }

    public static DatabaseAccessor getAccessor(Configuration conf) {
        DatabaseType dbType = DatabaseType.valueOf(conf.get(JdbcStorageConfig.DATABASE_TYPE.getPropertyName()));
        return DatabaseAccessorFactory.getAccessor(dbType);
    }
}

