/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql.functions;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.apache.hive.hplsql.Exec;
import org.apache.hive.hplsql.HplsqlParser;
import org.apache.hive.hplsql.Query;
import org.apache.hive.hplsql.Scope;
import org.apache.hive.hplsql.Utils;
import org.apache.hive.hplsql.Var;
import org.apache.hive.hplsql.functions.FuncCommand;
import org.apache.hive.hplsql.functions.FuncSpecCommand;

public class Function {
    Exec exec;
    HashMap<String, FuncCommand> map = new HashMap();
    HashMap<String, FuncSpecCommand> specMap = new HashMap();
    HashMap<String, FuncSpecCommand> specSqlMap = new HashMap();
    HashMap<String, HplsqlParser.Create_function_stmtContext> userMap = new HashMap();
    HashMap<String, HplsqlParser.Create_procedure_stmtContext> procMap = new HashMap();
    boolean trace = false;

    public Function(Exec e) {
        this.exec = e;
        this.trace = this.exec.getTrace();
    }

    public void register(Function f) {
    }

    public void exec(String name, HplsqlParser.Expr_func_paramsContext ctx) {
        FuncCommand func;
        if (this.execUser(name, ctx)) {
            return;
        }
        if (this.isProc(name) && this.execProc(name, ctx, null)) {
            return;
        }
        if (name.indexOf(".") != -1) {
            String[] parts = name.split("\\.");
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < parts.length; ++i) {
                if (i > 0) {
                    str.append(".");
                }
                str.append(parts[i].trim());
            }
            name = str.toString();
        }
        if (this.trace && ctx != null && ctx.parent != null && ctx.parent.parent instanceof HplsqlParser.Expr_stmtContext) {
            this.trace(ctx, "FUNC " + name);
        }
        if ((func = this.map.get(name.toUpperCase())) != null) {
            func.run(ctx);
        } else {
            this.info(ctx, "Function not found: " + name);
            this.evalNull();
        }
    }

    public void execSql(String name, HplsqlParser.Expr_func_paramsContext ctx) {
        if (this.execUserSql(ctx, name)) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append(name);
        sql.append("(");
        if (ctx != null) {
            int cnt = ctx.func_param().size();
            for (int i = 0; i < cnt; ++i) {
                sql.append(this.evalPop(ctx.func_param(i).expr()));
                if (i + 1 >= cnt) continue;
                sql.append(", ");
            }
        }
        sql.append(")");
        this.exec.stackPush(sql);
    }

    public void execAggWindowSql(HplsqlParser.Expr_agg_window_funcContext ctx) {
        this.exec.stackPush(this.exec.getFormattedText(ctx));
    }

    public boolean execUser(String name, HplsqlParser.Expr_func_paramsContext ctx) {
        HplsqlParser.Create_function_stmtContext userCtx = this.userMap.get(name.toUpperCase());
        if (userCtx == null) {
            return false;
        }
        if (this.trace) {
            this.trace(ctx, "EXEC FUNCTION " + name);
        }
        ArrayList<Var> actualParams = this.getActualCallParameters(ctx);
        this.exec.enterScope(Scope.Type.ROUTINE);
        this.setCallParameters(ctx, actualParams, userCtx.create_routine_params(), null);
        this.visit(userCtx.single_block_stmt());
        this.exec.leaveScope();
        return true;
    }

    public boolean execUserSql(HplsqlParser.Expr_func_paramsContext ctx, String name) {
        int i;
        HplsqlParser.Create_function_stmtContext userCtx = this.userMap.get(name.toUpperCase());
        if (userCtx == null) {
            return false;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("hplsql('");
        sql.append(name);
        sql.append("(");
        int cnt = ctx.func_param().size();
        for (i = 0; i < cnt; ++i) {
            sql.append(":" + (i + 1));
            if (i + 1 >= cnt) continue;
            sql.append(", ");
        }
        sql.append(")'");
        if (cnt > 0) {
            sql.append(", ");
        }
        for (i = 0; i < cnt; ++i) {
            sql.append(this.evalPop(ctx.func_param(i).expr()));
            if (i + 1 >= cnt) continue;
            sql.append(", ");
        }
        sql.append(")");
        this.exec.stackPush(sql);
        this.exec.registerUdf();
        return true;
    }

    public boolean execProc(String name) {
        HplsqlParser.Create_procedure_stmtContext procCtx;
        if (this.trace) {
            this.trace("EXEC PROCEDURE " + name);
        }
        if ((procCtx = this.procMap.get(name.toUpperCase())) == null) {
            this.trace("Procedure not found");
            return false;
        }
        this.exec.enterScope(Scope.Type.ROUTINE);
        this.exec.callStackPush(name);
        if (procCtx.create_routine_params() != null) {
            this.setCallParameters(procCtx.create_routine_params());
        }
        this.visit(procCtx.proc_block());
        this.exec.callStackPop();
        this.exec.leaveScope();
        return true;
    }

    public boolean isProc(String name) {
        return this.procMap.get(name.toUpperCase()) != null;
    }

    public boolean execProc(String name, HplsqlParser.Expr_func_paramsContext ctx, ParserRuleContext callCtx) {
        HplsqlParser.Create_procedure_stmtContext procCtx;
        if (this.trace) {
            this.trace(callCtx, "EXEC PROCEDURE " + name);
        }
        if ((procCtx = this.procMap.get(name.toUpperCase())) == null) {
            this.trace(callCtx, "Procedure not found");
            return false;
        }
        ArrayList<Var> actualParams = this.getActualCallParameters(ctx);
        HashMap<String, Var> out = new HashMap<String, Var>();
        this.exec.enterScope(Scope.Type.ROUTINE);
        this.exec.callStackPush(name);
        if (procCtx.declare_block_inplace() != null) {
            this.visit(procCtx.declare_block_inplace());
        }
        if (procCtx.create_routine_params() != null) {
            this.setCallParameters(ctx, actualParams, procCtx.create_routine_params(), out);
        }
        this.visit(procCtx.proc_block());
        this.exec.callStackPop();
        this.exec.leaveScope();
        for (Map.Entry<String, Var> i : out.entrySet()) {
            this.exec.setVariable(i.getKey(), i.getValue());
        }
        return true;
    }

    public void setCallParameters(HplsqlParser.Expr_func_paramsContext actual, ArrayList<Var> actualValues, HplsqlParser.Create_routine_paramsContext formal, HashMap<String, Var> out) {
        if (actual == null || actual.func_param() == null || actualValues == null) {
            return;
        }
        int actualCnt = actualValues.size();
        int formalCnt = formal.create_routine_param_item().size();
        for (int i = 0; i < actualCnt && i < formalCnt; ++i) {
            String actualName;
            HplsqlParser.ExprContext a = actual.func_param(i).expr();
            HplsqlParser.Create_routine_param_itemContext p = this.getCallParameter(actual, formal, i);
            String name = p.ident().getText();
            String type = p.dtype().getText();
            String len = null;
            String scale = null;
            if (p.dtype_len() != null) {
                len = p.dtype_len().L_INT(0).getText();
                if (p.dtype_len().L_INT(1) != null) {
                    scale = p.dtype_len().L_INT(1).getText();
                }
            }
            Var var = this.setCallParameter(name, type, len, scale, actualValues.get(i));
            if (this.trace) {
                this.trace(actual, "SET PARAM " + name + " = " + var.toString());
            }
            if (out == null || a.expr_atom() == null || a.expr_atom().ident() == null || p.T_OUT() == null && p.T_INOUT() == null || (actualName = a.expr_atom().ident().getText()) == null) continue;
            out.put(actualName, var);
        }
    }

    void setCallParameters(HplsqlParser.Create_routine_paramsContext ctx) {
        int cnt = ctx.create_routine_param_item().size();
        for (int i = 0; i < cnt; ++i) {
            HplsqlParser.Create_routine_param_itemContext p = ctx.create_routine_param_item(i);
            String name = p.ident().getText();
            String type = p.dtype().getText();
            String len = null;
            String scale = null;
            if (p.dtype_len() != null) {
                len = p.dtype_len().L_INT(0).getText();
                if (p.dtype_len().L_INT(1) != null) {
                    scale = p.dtype_len().L_INT(1).getText();
                }
            }
            Var value = this.exec.findVariable(name);
            Var var = this.setCallParameter(name, type, len, scale, value);
            if (!this.trace) continue;
            this.trace(ctx, "SET PARAM " + name + " = " + var.toString());
        }
    }

    Var setCallParameter(String name, String type, String len, String scale, Var value) {
        Var var = new Var(name, type, len, scale, null);
        var.cast(value);
        this.exec.addVariable(var);
        return var;
    }

    HplsqlParser.Create_routine_param_itemContext getCallParameter(HplsqlParser.Expr_func_paramsContext actual, HplsqlParser.Create_routine_paramsContext formal, int pos) {
        String named = null;
        int out_pos = pos;
        if (actual.func_param(pos).ident() != null) {
            named = actual.func_param(pos).ident().getText();
            int cnt = formal.create_routine_param_item().size();
            for (int i = 0; i < cnt; ++i) {
                if (!named.equalsIgnoreCase(formal.create_routine_param_item(i).ident().getText())) continue;
                out_pos = i;
                break;
            }
        }
        return formal.create_routine_param_item(out_pos);
    }

    public ArrayList<Var> getActualCallParameters(HplsqlParser.Expr_func_paramsContext actual) {
        if (actual == null || actual.func_param() == null) {
            return null;
        }
        int cnt = actual.func_param().size();
        ArrayList<Var> values = new ArrayList<Var>(cnt);
        for (int i = 0; i < cnt; ++i) {
            values.add(this.evalPop(actual.func_param(i).expr()));
        }
        return values;
    }

    public void addUserFunction(HplsqlParser.Create_function_stmtContext ctx) {
        String name = ctx.ident().getText();
        if (this.trace) {
            this.trace(ctx, "CREATE FUNCTION " + name);
        }
        this.userMap.put(name.toUpperCase(), ctx);
    }

    public void addUserProcedure(HplsqlParser.Create_procedure_stmtContext ctx) {
        String name = ctx.ident(0).getText();
        if (this.trace) {
            this.trace(ctx, "CREATE PROCEDURE " + name);
        }
        this.procMap.put(name.toUpperCase(), ctx);
    }

    public int getParamCount(HplsqlParser.Expr_func_paramsContext ctx) {
        if (ctx == null) {
            return 0;
        }
        return ctx.func_param().size();
    }

    public void specExec(HplsqlParser.Expr_spec_funcContext ctx) {
        FuncSpecCommand func;
        String name = ctx.start.getText().toUpperCase();
        if (this.trace && ctx.parent.parent instanceof HplsqlParser.Expr_stmtContext) {
            this.trace(ctx, "FUNC " + name);
        }
        if ((func = this.specMap.get(name)) != null) {
            func.run(ctx);
        } else if (ctx.T_MAX_PART_STRING() != null) {
            this.execMaxPartString(ctx);
        } else if (ctx.T_MIN_PART_STRING() != null) {
            this.execMinPartString(ctx);
        } else if (ctx.T_MAX_PART_INT() != null) {
            this.execMaxPartInt(ctx);
        } else if (ctx.T_MIN_PART_INT() != null) {
            this.execMinPartInt(ctx);
        } else if (ctx.T_MAX_PART_DATE() != null) {
            this.execMaxPartDate(ctx);
        } else if (ctx.T_MIN_PART_DATE() != null) {
            this.execMinPartDate(ctx);
        } else if (ctx.T_PART_LOC() != null) {
            this.execPartLoc(ctx);
        } else {
            this.evalNull();
        }
    }

    public void specExecSql(HplsqlParser.Expr_spec_funcContext ctx) {
        FuncSpecCommand func;
        String name = ctx.start.getText().toUpperCase();
        if (this.trace && ctx.parent.parent instanceof HplsqlParser.Expr_stmtContext) {
            this.trace(ctx, "FUNC " + name);
        }
        if ((func = this.specSqlMap.get(name)) != null) {
            func.run(ctx);
        } else {
            this.exec.stackPush(this.exec.getFormattedText(ctx));
        }
    }

    public void execCurrentDate(HplsqlParser.Expr_spec_funcContext ctx) {
        if (this.trace) {
            this.trace(ctx, "CURRENT_DATE");
        }
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        String s = f.format(Calendar.getInstance().getTime());
        this.exec.stackPush(new Var(Var.Type.DATE, Utils.toDate(s)));
    }

    public void execMaxPartString(HplsqlParser.Expr_spec_funcContext ctx) {
        if (this.trace) {
            this.trace(ctx, "MAX_PART_STRING");
        }
        this.execMinMaxPart(ctx, Var.Type.STRING, true);
    }

    public void execMinPartString(HplsqlParser.Expr_spec_funcContext ctx) {
        if (this.trace) {
            this.trace(ctx, "MIN_PART_STRING");
        }
        this.execMinMaxPart(ctx, Var.Type.STRING, false);
    }

    public void execMaxPartInt(HplsqlParser.Expr_spec_funcContext ctx) {
        if (this.trace) {
            this.trace(ctx, "MAX_PART_INT");
        }
        this.execMinMaxPart(ctx, Var.Type.BIGINT, true);
    }

    public void execMinPartInt(HplsqlParser.Expr_spec_funcContext ctx) {
        if (this.trace) {
            this.trace(ctx, "MIN_PART_INT");
        }
        this.execMinMaxPart(ctx, Var.Type.BIGINT, false);
    }

    public void execMaxPartDate(HplsqlParser.Expr_spec_funcContext ctx) {
        if (this.trace) {
            this.trace(ctx, "MAX_PART_DATE");
        }
        this.execMinMaxPart(ctx, Var.Type.DATE, true);
    }

    public void execMinPartDate(HplsqlParser.Expr_spec_funcContext ctx) {
        if (this.trace) {
            this.trace(ctx, "MIN_PART_DATE");
        }
        this.execMinMaxPart(ctx, Var.Type.DATE, false);
    }

    public void execMinMaxPart(HplsqlParser.Expr_spec_funcContext ctx, Var.Type type, boolean max) {
        String tabname = this.evalPop(ctx.expr(0)).toString();
        String sql = "SHOW PARTITIONS " + tabname;
        String colname = null;
        int colnum = -1;
        int exprnum = ctx.expr().size();
        if (ctx.expr(1) != null) {
            colname = this.evalPop(ctx.expr(1)).toString();
        } else {
            colnum = 0;
        }
        if (exprnum >= 4) {
            sql = sql + " PARTITION (";
            int i = 2;
            while (i + 1 < exprnum) {
                String fcol = this.evalPop(ctx.expr(i)).toString();
                String fval = this.evalPop(ctx.expr(i + 1)).toSqlString();
                if (i > 2) {
                    sql = sql + ", ";
                }
                sql = sql + fcol + "=" + fval;
                i += 2;
            }
            sql = sql + ")";
        }
        if (this.trace) {
            this.trace(ctx, "Query: " + sql);
        }
        if (this.exec.getOffline()) {
            this.evalNull();
            return;
        }
        Query query = this.exec.executeQuery((ParserRuleContext)ctx, sql, this.exec.conf.defaultConnection);
        if (query.error()) {
            this.evalNullClose(query, this.exec.conf.defaultConnection);
            return;
        }
        ResultSet rs = query.getResultSet();
        try {
            String resultString = null;
            Long resultInt = null;
            Date resultDate = null;
            while (rs.next()) {
                String[] parts = rs.getString(1).split("/");
                if (colnum == -1) {
                    for (int i = 0; i < parts.length; ++i) {
                        String[] name = parts[i].split("=");
                        if (!name[0].equalsIgnoreCase(colname)) continue;
                        colnum = i;
                        break;
                    }
                    if (colnum == -1) {
                        this.evalNullClose(query, this.exec.conf.defaultConnection);
                        return;
                    }
                }
                String[] pair = parts[colnum].split("=");
                if (type == Var.Type.STRING) {
                    resultString = Utils.minMaxString(resultString, pair[1], max);
                    continue;
                }
                if (type == Var.Type.BIGINT) {
                    resultInt = Utils.minMaxInt(resultInt, pair[1], max);
                    continue;
                }
                if (type != Var.Type.DATE) continue;
                resultDate = Utils.minMaxDate(resultDate, pair[1], max);
            }
            if (resultString != null) {
                this.evalString(resultString);
            } else if (resultInt != null) {
                this.evalInt(resultInt);
            } else if (resultDate != null) {
                this.evalDate(resultDate);
            } else {
                this.evalNull();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.exec.closeQuery(query, this.exec.conf.defaultConnection);
    }

    public void execPartLoc(HplsqlParser.Expr_spec_funcContext ctx) {
        String tabname = this.evalPop(ctx.expr(0)).toString();
        String sql = "DESCRIBE EXTENDED " + tabname;
        int exprnum = ctx.expr().size();
        boolean hostname = false;
        if (exprnum > 1) {
            sql = sql + " PARTITION (";
            int i = 1;
            while (i + 1 < exprnum) {
                String col = this.evalPop(ctx.expr(i)).toString();
                String val = this.evalPop(ctx.expr(i + 1)).toSqlString();
                if (i > 2) {
                    sql = sql + ", ";
                }
                sql = sql + col + "=" + val;
                i += 2;
            }
            sql = sql + ")";
        }
        if (exprnum % 2 == 0 && this.evalPop(ctx.expr(exprnum - 1)).intValue() == 1) {
            hostname = true;
        }
        if (this.trace) {
            this.trace(ctx, "Query: " + sql);
        }
        if (this.exec.getOffline()) {
            this.evalNull();
            return;
        }
        Query query = this.exec.executeQuery((ParserRuleContext)ctx, sql, this.exec.conf.defaultConnection);
        if (query.error()) {
            this.evalNullClose(query, this.exec.conf.defaultConnection);
            return;
        }
        String result = null;
        ResultSet rs = query.getResultSet();
        try {
            while (rs.next()) {
                Matcher m;
                if (!rs.getString(1).startsWith("Detailed Partition Information") || !(m = Pattern.compile(".*, location:(.*?),.*").matcher(rs.getString(2))).find()) continue;
                result = m.group(1);
            }
        }
        catch (SQLException m) {
            // empty catch block
        }
        if (result != null) {
            if (!hostname && (m = Pattern.compile(".*://.*?(/.*)").matcher(result)).find()) {
                result = m.group(1);
            }
            this.evalString(result);
        } else {
            this.evalNull();
        }
        this.exec.closeQuery(query, this.exec.conf.defaultConnection);
    }

    void eval(ParserRuleContext ctx) {
        this.exec.visit((ParseTree)ctx);
    }

    void evalVar(Var var) {
        this.exec.stackPush(var);
    }

    void evalNull() {
        this.exec.stackPush(Var.Null);
    }

    void evalString(String string) {
        this.exec.stackPush(new Var(string));
    }

    void evalString(StringBuilder string) {
        this.evalString(string.toString());
    }

    void evalInt(Long i) {
        this.exec.stackPush(new Var(i));
    }

    void evalInt(int i) {
        this.evalInt(new Long(i));
    }

    void evalDate(Date date) {
        this.exec.stackPush(new Var(Var.Type.DATE, date));
    }

    void evalNullClose(Query query, String conn) {
        this.exec.stackPush(Var.Null);
        this.exec.closeQuery(query, conn);
        if (this.trace) {
            query.printStackTrace();
        }
    }

    Var evalPop(ParserRuleContext ctx) {
        this.exec.visit((ParseTree)ctx);
        return this.exec.stackPop();
    }

    Var evalPop(ParserRuleContext ctx, int value) {
        if (ctx != null) {
            return this.evalPop(ctx);
        }
        return new Var(new Long(value));
    }

    Integer visit(ParserRuleContext ctx) {
        return (Integer)this.exec.visit((ParseTree)ctx);
    }

    Integer visitChildren(ParserRuleContext ctx) {
        return (Integer)this.exec.visitChildren((RuleNode)ctx);
    }

    public void trace(ParserRuleContext ctx, String message) {
        if (this.trace) {
            this.exec.trace(ctx, message);
        }
    }

    public void trace(String message) {
        this.trace(null, message);
    }

    public void info(ParserRuleContext ctx, String message) {
        this.exec.info(ctx, message);
    }
}

