/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.antlr.v4.runtime.ParserRuleContext;

public class Query {
    String sql;
    ParserRuleContext sqlExpr;
    ParserRuleContext sqlSelect;
    Connection conn;
    Statement stmt;
    PreparedStatement pstmt;
    ResultSet rs;
    Exception exception;
    State state = State.CLOSE;
    boolean withReturn = false;

    Query() {
    }

    Query(String sql) {
        this.sql = sql;
    }

    public void set(Connection conn, Statement stmt, ResultSet rs) {
        this.conn = conn;
        this.stmt = stmt;
        this.rs = rs;
        if (rs != null) {
            this.state = State.OPEN;
        }
    }

    public void set(Connection conn, PreparedStatement pstmt) {
        this.conn = conn;
        this.pstmt = pstmt;
    }

    public void setFetch(boolean ok) {
        this.state = ok ? State.FETCHED_OK : State.FETCHED_NODATA;
    }

    public int getRowCount() {
        if (!this.error() && this.stmt != null) {
            try {
                return this.stmt.getUpdateCount();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return -1;
    }

    public boolean isOpen() {
        return this.rs != null;
    }

    public Boolean isFound() {
        if (this.state == State.OPEN || this.state == State.CLOSE) {
            return null;
        }
        if (this.state == State.FETCHED_OK) {
            return true;
        }
        return false;
    }

    public Boolean isNotFound() {
        if (this.state == State.OPEN || this.state == State.CLOSE) {
            return null;
        }
        if (this.state == State.FETCHED_NODATA) {
            return true;
        }
        return false;
    }

    public void closeStatement() {
        try {
            if (this.rs != null) {
                this.rs.close();
                this.rs = null;
            }
            if (this.stmt != null) {
                this.stmt.close();
                this.stmt = null;
            }
            if (this.pstmt != null) {
                this.pstmt.close();
                this.pstmt = null;
            }
            this.state = State.CLOSE;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setExprCtx(ParserRuleContext sqlExpr) {
        this.sqlExpr = sqlExpr;
    }

    public void setSelectCtx(ParserRuleContext sqlSelect) {
        this.sqlSelect = sqlSelect;
    }

    public void setWithReturn(boolean withReturn) {
        this.withReturn = withReturn;
    }

    public void setError(Exception e) {
        this.exception = e;
    }

    public void printStackTrace() {
        if (this.exception != null) {
            this.exception.printStackTrace();
        }
    }

    public ResultSet getResultSet() {
        return this.rs;
    }

    public PreparedStatement getPreparedStatement() {
        return this.pstmt;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public boolean getWithReturn() {
        return this.withReturn;
    }

    public boolean error() {
        return this.exception != null;
    }

    public String errorText() {
        if (this.exception != null) {
            if (this.exception instanceof ClassNotFoundException) {
                return "ClassNotFoundException: " + this.exception.getMessage();
            }
            return this.exception.getMessage();
        }
        return "";
    }

    public Exception getException() {
        return this.exception;
    }

    public static enum State {
        OPEN,
        FETCHED_OK,
        FETCHED_NODATA,
        CLOSE;

    }
}

