/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql.functions;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.hive.hplsql.Conn;
import org.apache.hive.hplsql.Exec;
import org.apache.hive.hplsql.HplsqlParser;
import org.apache.hive.hplsql.Utils;
import org.apache.hive.hplsql.Var;
import org.apache.hive.hplsql.functions.FuncCommand;
import org.apache.hive.hplsql.functions.FuncSpecCommand;
import org.apache.hive.hplsql.functions.Function;

public class FunctionDatetime
extends Function {
    public FunctionDatetime(Exec e) {
        super(e);
    }

    @Override
    public void register(Function f) {
        f.map.put("DATE", new FuncCommand(){

            @Override
            public void run(HplsqlParser.Expr_func_paramsContext ctx) {
                FunctionDatetime.this.date(ctx);
            }
        });
        f.map.put("FROM_UNIXTIME", new FuncCommand(){

            @Override
            public void run(HplsqlParser.Expr_func_paramsContext ctx) {
                FunctionDatetime.this.fromUnixtime(ctx);
            }
        });
        f.map.put("NOW", new FuncCommand(){

            @Override
            public void run(HplsqlParser.Expr_func_paramsContext ctx) {
                FunctionDatetime.this.now(ctx);
            }
        });
        f.map.put("TIMESTAMP_ISO", new FuncCommand(){

            @Override
            public void run(HplsqlParser.Expr_func_paramsContext ctx) {
                FunctionDatetime.this.timestampIso(ctx);
            }
        });
        f.map.put("TO_TIMESTAMP", new FuncCommand(){

            @Override
            public void run(HplsqlParser.Expr_func_paramsContext ctx) {
                FunctionDatetime.this.toTimestamp(ctx);
            }
        });
        f.map.put("UNIX_TIMESTAMP", new FuncCommand(){

            @Override
            public void run(HplsqlParser.Expr_func_paramsContext ctx) {
                FunctionDatetime.this.unixTimestamp(ctx);
            }
        });
        f.specMap.put("CURRENT_DATE", new FuncSpecCommand(){

            @Override
            public void run(HplsqlParser.Expr_spec_funcContext ctx) {
                FunctionDatetime.this.currentDate(ctx);
            }
        });
        f.specMap.put("CURRENT_TIMESTAMP", new FuncSpecCommand(){

            @Override
            public void run(HplsqlParser.Expr_spec_funcContext ctx) {
                FunctionDatetime.this.currentTimestamp(ctx);
            }
        });
        f.specMap.put("SYSDATE", new FuncSpecCommand(){

            @Override
            public void run(HplsqlParser.Expr_spec_funcContext ctx) {
                FunctionDatetime.this.currentTimestamp(ctx);
            }
        });
        f.specSqlMap.put("CURRENT_DATE", new FuncSpecCommand(){

            @Override
            public void run(HplsqlParser.Expr_spec_funcContext ctx) {
                FunctionDatetime.this.currentDateSql(ctx);
            }
        });
        f.specSqlMap.put("CURRENT_TIMESTAMP", new FuncSpecCommand(){

            @Override
            public void run(HplsqlParser.Expr_spec_funcContext ctx) {
                FunctionDatetime.this.currentTimestampSql(ctx);
            }
        });
    }

    public void currentDate(HplsqlParser.Expr_spec_funcContext ctx) {
        this.evalVar(FunctionDatetime.currentDate());
    }

    public static Var currentDate() {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        String s = f.format(Calendar.getInstance().getTime());
        return new Var(Var.Type.DATE, Utils.toDate(s));
    }

    public void currentDateSql(HplsqlParser.Expr_spec_funcContext ctx) {
        if (this.exec.getConnectionType() == Conn.Type.HIVE) {
            this.evalString("TO_DATE(FROM_UNIXTIME(UNIX_TIMESTAMP()))");
        } else {
            this.evalString(this.exec.getFormattedText(ctx));
        }
    }

    public void currentTimestamp(HplsqlParser.Expr_spec_funcContext ctx) {
        int precision = this.evalPop(ctx.expr(0), 3).intValue();
        this.evalVar(FunctionDatetime.currentTimestamp(precision));
    }

    public static Var currentTimestamp(int precision) {
        String format = "yyyy-MM-dd HH:mm:ss";
        if (precision > 0 && precision <= 3) {
            format = format + "." + StringUtils.repeat((String)"S", (int)precision);
        }
        SimpleDateFormat f = new SimpleDateFormat(format);
        String s = f.format(Calendar.getInstance(TimeZone.getDefault()).getTime());
        return new Var(Utils.toTimestamp(s), precision);
    }

    public void currentTimestampSql(HplsqlParser.Expr_spec_funcContext ctx) {
        if (this.exec.getConnectionType() == Conn.Type.HIVE) {
            this.evalString("FROM_UNIXTIME(UNIX_TIMESTAMP())");
        } else {
            this.evalString(this.exec.getFormattedText(ctx));
        }
    }

    void date(HplsqlParser.Expr_func_paramsContext ctx) {
        if (ctx.func_param().size() != 1) {
            this.evalNull();
            return;
        }
        Var var = new Var(Var.Type.DATE);
        var.cast(this.evalPop(ctx.func_param(0).expr()));
        this.evalVar(var);
    }

    void now(HplsqlParser.Expr_func_paramsContext ctx) {
        if (ctx != null) {
            this.evalNull();
            return;
        }
        this.evalVar(FunctionDatetime.currentTimestamp(3));
    }

    void timestampIso(HplsqlParser.Expr_func_paramsContext ctx) {
        if (ctx.func_param().size() != 1) {
            this.evalNull();
            return;
        }
        Var var = new Var(Var.Type.TIMESTAMP);
        var.cast(this.evalPop(ctx.func_param(0).expr()));
        this.evalVar(var);
    }

    void toTimestamp(HplsqlParser.Expr_func_paramsContext ctx) {
        if (ctx.func_param().size() != 2) {
            this.evalNull();
            return;
        }
        String value = this.evalPop(ctx.func_param(0).expr()).toString();
        String sqlFormat = this.evalPop(ctx.func_param(1).expr()).toString();
        String format = Utils.convertSqlDatetimeFormat(sqlFormat);
        try {
            long timeInMs = new SimpleDateFormat(format).parse(value).getTime();
            this.evalVar(new Var(Var.Type.TIMESTAMP, new Timestamp(timeInMs)));
        }
        catch (Exception e) {
            this.exec.signal(e);
            this.evalNull();
        }
    }

    void fromUnixtime(HplsqlParser.Expr_func_paramsContext ctx) {
        int cnt = this.getParamCount(ctx);
        if (cnt == 0) {
            this.evalNull();
            return;
        }
        long epoch = this.evalPop(ctx.func_param(0).expr()).longValue();
        String format = "yyyy-MM-dd HH:mm:ss";
        if (cnt > 1) {
            format = this.evalPop(ctx.func_param(1).expr()).toString();
        }
        this.evalString(new SimpleDateFormat(format).format(new Date(epoch * 1000L)));
    }

    void unixTimestamp(HplsqlParser.Expr_func_paramsContext ctx) {
        this.evalVar(new Var(System.currentTimeMillis() / 1000L));
    }
}

