/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hive.hplsql.Exec;
import org.apache.hive.hplsql.File;
import org.apache.hive.hplsql.HplsqlParser;
import org.apache.hive.hplsql.Query;
import org.apache.hive.hplsql.Timer;
import org.apache.hive.hplsql.Utils;
import org.apache.hive.hplsql.Var;

public class Copy {
    Exec exec;
    Timer timer = new Timer();
    boolean trace = false;
    boolean info = false;
    long srcSizeInBytes = 0L;
    String delimiter = "\t";
    boolean sqlInsert = false;
    String sqlInsertName;
    String targetConn;
    int batchSize = 1000;
    boolean overwrite = false;
    boolean delete = false;
    boolean ignore = false;

    Copy(Exec e) {
        this.exec = e;
        this.trace = this.exec.getTrace();
        this.info = this.exec.getInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Integer run(HplsqlParser.Copy_stmtContext ctx) {
        this.trace(ctx, "COPY");
        this.initOptions(ctx);
        StringBuilder sql = new StringBuilder();
        String conn = null;
        if (ctx.table_name() != null) {
            String table = this.evalPop(ctx.table_name()).toString();
            conn = this.exec.getObjectConnection(ctx.table_name().getText());
            sql.append("SELECT * FROM ");
            sql.append(table);
        } else {
            sql.append(this.evalPop(ctx.select_stmt()).toString());
            conn = this.exec.getStatementConnection();
            if (this.trace) {
                this.trace(ctx, "Statement:\n" + sql);
            }
        }
        Query query = this.exec.executeQuery((ParserRuleContext)ctx, sql.toString(), conn);
        if (query.error()) {
            this.exec.signal(query);
            return 1;
        }
        this.exec.setSqlSuccess();
        try {
            if (this.targetConn != null) {
                this.copyToTable(ctx, query);
            } else {
                this.copyToFile(ctx, query);
            }
        }
        catch (Exception e) {
            this.exec.signal(e);
            Integer n = 1;
            return n;
        }
        finally {
            this.exec.closeQuery(query, conn);
        }
        return 0;
    }

    void copyToTable(HplsqlParser.Copy_stmtContext ctx, Query query) throws Exception {
        long start;
        ResultSet rs = query.getResultSet();
        if (rs == null) {
            return;
        }
        ResultSetMetaData rm = rs.getMetaData();
        int cols = rm.getColumnCount();
        int rows = 0;
        if (this.trace) {
            this.trace(ctx, "SELECT executed: " + cols + " columns");
        }
        Connection conn = this.exec.getConnection(this.targetConn);
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO " + this.sqlInsertName + " VALUES (");
        for (int i = 0; i < cols; ++i) {
            sql.append("?");
            if (i + 1 >= cols) continue;
            sql.append(",");
        }
        sql.append(")");
        PreparedStatement ps = conn.prepareStatement(sql.toString());
        long prev = start = this.timer.start();
        boolean batchOpen = false;
        while (rs.next()) {
            long cur;
            for (int i = 1; i <= cols; ++i) {
                ps.setObject(i, rs.getObject(i));
            }
            ++rows;
            if (this.batchSize > 1) {
                ps.addBatch();
                batchOpen = true;
                if (rows % this.batchSize == 0) {
                    ps.executeBatch();
                    batchOpen = false;
                }
            } else {
                ps.executeUpdate();
            }
            if (!this.trace || rows % 100 != 0 || (cur = this.timer.current()) - prev <= 10000L) continue;
            this.trace(ctx, "Copying rows: " + rows + " (" + (long)rows / ((cur - start) / 1000L) + " rows/sec)");
            prev = cur;
        }
        if (batchOpen) {
            ps.executeBatch();
        }
        ps.close();
        this.exec.returnConnection(this.targetConn, conn);
        this.exec.setRowCount(rows);
        long elapsed = this.timer.stop();
        if (this.info) {
            this.info(ctx, "COPY completed: " + rows + " row(s), " + this.timer.format() + ", " + (long)rows / (elapsed / 1000L) + " rows/sec");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyToFile(HplsqlParser.Copy_stmtContext ctx, Query query) throws Exception {
        ResultSet rs = query.getResultSet();
        if (rs == null) {
            return;
        }
        ResultSetMetaData rm = rs.getMetaData();
        String filename = null;
        filename = ctx.copy_target().expr() != null ? this.evalPop(ctx.copy_target().expr()).toString() : ctx.copy_target().getText();
        byte[] del = this.delimiter.getBytes();
        byte[] rowdel = "\n".getBytes();
        byte[] nullstr = "NULL".getBytes();
        int cols = rm.getColumnCount();
        int rows = 0;
        long bytes = 0L;
        if (this.trace || this.info) {
            String mes = "Query executed: " + cols + " columns, output file: " + filename;
            if (this.trace) {
                this.trace(ctx, mes);
            } else {
                this.info(ctx, mes);
            }
        }
        java.io.File file = null;
        File hdfsFile = null;
        if (ctx.T_HDFS() == null) {
            file = new java.io.File(filename);
        } else {
            hdfsFile = new File();
        }
        OutputStream out = null;
        this.timer.start();
        try {
            if (file != null) {
                if (!file.exists()) {
                    file.createNewFile();
                }
                out = new FileOutputStream(file, false);
            } else {
                out = hdfsFile.create(filename, true);
            }
            String sql = "";
            if (this.sqlInsert) {
                sql = "INSERT INTO " + this.sqlInsertName + " VALUES (";
                rowdel = ");\n".getBytes();
            }
            while (rs.next()) {
                if (this.sqlInsert) {
                    out.write(sql.getBytes());
                }
                for (int i = 1; i <= cols; ++i) {
                    String col;
                    if (i > 1) {
                        out.write(del);
                        bytes += (long)del.length;
                    }
                    if ((col = rs.getString(i)) != null) {
                        if (this.sqlInsert) {
                            col = Utils.quoteString(col);
                        }
                        byte[] b = col.getBytes();
                        out.write(b);
                        bytes += (long)b.length;
                        continue;
                    }
                    if (!this.sqlInsert) continue;
                    out.write(nullstr);
                }
                out.write(rowdel);
                bytes += (long)rowdel.length;
                ++rows;
            }
            this.exec.setRowCount(rows);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        long elapsed = this.timer.stop();
        if (this.info) {
            this.info(ctx, "COPY completed: " + rows + " row(s), " + Utils.formatSizeInBytes(bytes) + ", " + this.timer.format() + ", " + (long)rows / elapsed / 1000L + " rows/sec");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Integer runFromLocal(HplsqlParser.Copy_from_local_stmtContext ctx) {
        this.trace(ctx, "COPY FROM LOCAL");
        this.initFileOptions(ctx.copy_file_option());
        HashMap<String, Pair<String, Long>> srcFiles = new HashMap<String, Pair<String, Long>>();
        String src = this.evalPop(ctx.copy_source(0)).toString();
        String dest = this.evalPop(ctx.copy_target()).toString();
        int srcItems = ctx.copy_source().size();
        for (int i = 0; i < srcItems; ++i) {
            this.createLocalFileList(srcFiles, this.evalPop(ctx.copy_source(i)).toString(), null);
        }
        if (this.info) {
            this.info(ctx, "Files to copy: " + srcFiles.size() + " (" + Utils.formatSizeInBytes(this.srcSizeInBytes) + ")");
        }
        if (srcFiles.size() == 0) {
            this.exec.setHostCode(2);
            return 2;
        }
        this.timer.start();
        File file = new File();
        FileSystem fs = null;
        int succeed = 0;
        int failed = 0;
        long copiedSize = 0L;
        try {
            fs = file.createFs();
            boolean multi = false;
            if (srcFiles.size() > 1) {
                multi = true;
            }
            for (Map.Entry<String, Pair<String, Long>> i : srcFiles.entrySet()) {
                try {
                    String relativePath;
                    Path s = new Path(i.getKey());
                    Path d = null;
                    d = multi ? ((relativePath = (String)i.getValue().getLeft()) == null ? new Path(dest, s.getName()) : new Path(dest, relativePath + "/" + s.getName())) : (srcItems == 1 && i.getKey().endsWith(src) ? new Path(dest) : new Path(dest + "/" + s.getName()));
                    fs.copyFromLocalFile(this.delete, this.overwrite, s, d);
                    ++succeed;
                    long size = (Long)i.getValue().getRight();
                    copiedSize += size;
                    if (!this.info) continue;
                    this.info(ctx, "Copied: " + file.resolvePath(d) + " (" + Utils.formatSizeInBytes(size) + ")");
                }
                catch (IOException e) {
                    ++failed;
                    if (this.ignore) continue;
                    throw e;
                    return 0;
                }
            }
        }
        catch (IOException e) {
            this.exec.signal(e);
            this.exec.setHostCode(1);
            Integer n = 1;
            return n;
        }
        finally {
            long elapsed = this.timer.stop();
            if (this.info) {
                this.info(ctx, "COPY completed: " + succeed + " succeed, " + failed + " failed, " + this.timer.format() + ", " + Utils.formatSizeInBytes(copiedSize) + ", " + Utils.formatBytesPerSec(copiedSize, elapsed));
            }
            if (failed == 0) {
                this.exec.setHostCode(0);
            } else {
                this.exec.setHostCode(1);
            }
            file.close();
        }
    }

    void createLocalFileList(HashMap<String, Pair<String, Long>> list, String path, String relativePath) {
        java.io.File file = new java.io.File(path);
        if (file.exists()) {
            if (file.isDirectory()) {
                for (java.io.File i : file.listFiles()) {
                    if (i.isDirectory()) {
                        String rel = null;
                        rel = relativePath == null ? i.getName() : relativePath + java.io.File.separator + i.getName();
                        this.createLocalFileList(list, i.getAbsolutePath(), rel);
                        continue;
                    }
                    long size = i.length();
                    list.put(i.getAbsolutePath(), (Pair<String, Long>)Pair.of((Object)relativePath, (Object)size));
                    this.srcSizeInBytes += size;
                }
            } else {
                long size = file.length();
                list.put(file.getAbsolutePath(), (Pair<String, Long>)Pair.of((Object)relativePath, (Object)size));
                this.srcSizeInBytes += size;
            }
        }
    }

    void initOptions(HplsqlParser.Copy_stmtContext ctx) {
        int cnt = ctx.copy_option().size();
        for (int i = 0; i < cnt; ++i) {
            HplsqlParser.Copy_optionContext option = ctx.copy_option(i);
            if (option.T_DELIMITER() != null) {
                this.delimiter = StringEscapeUtils.unescapeJava((String)this.evalPop(option.expr()).toString());
                continue;
            }
            if (option.T_SQLINSERT() != null) {
                this.sqlInsert = true;
                this.delimiter = ", ";
                if (option.ident() == null) continue;
                this.sqlInsertName = option.ident().getText();
                continue;
            }
            if (option.T_AT() != null) {
                this.targetConn = option.ident().getText();
                if (ctx.copy_target().expr() != null) {
                    this.sqlInsertName = this.evalPop(ctx.copy_target().expr()).toString();
                    continue;
                }
                this.sqlInsertName = ctx.copy_target().getText();
                continue;
            }
            if (option.T_BATCHSIZE() == null) continue;
            this.batchSize = this.evalPop(option.expr()).intValue();
        }
    }

    void initFileOptions(List<HplsqlParser.Copy_file_optionContext> options) {
        this.srcSizeInBytes = 0L;
        for (HplsqlParser.Copy_file_optionContext i : options) {
            if (i.T_OVERWRITE() != null) {
                this.overwrite = true;
                continue;
            }
            if (i.T_DELETE() != null) {
                this.delete = true;
                continue;
            }
            if (i.T_IGNORE() == null) continue;
            this.ignore = true;
        }
    }

    Var evalPop(ParserRuleContext ctx) {
        this.exec.visit((ParseTree)ctx);
        if (!this.exec.stack.isEmpty()) {
            return this.exec.stackPop();
        }
        return Var.Empty;
    }

    public void trace(ParserRuleContext ctx, String message) {
        this.exec.trace(ctx, message);
    }

    public void info(ParserRuleContext ctx, String message) {
        this.exec.info(ctx, message);
    }
}

