/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.session;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.common.util.HiveTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TestSessionState {
    private final boolean prewarm;
    private static final String clazzDistFileName = "RefreshedJarClass.jar.V1";
    private static final String clazzV2FileName = "RefreshedJarClass.jar.V2";
    private static final String reloadClazzFileName = "RefreshedJarClass.jar";
    private static final String versionMethodName = "version";
    private static final String RELOADED_CLAZZ_PREFIX_NAME = "RefreshedJarClass";
    private static final String V1 = "V1";
    private static final String V2 = "V2";
    private static String hiveReloadPath;
    private File reloadFolder;
    public static final Logger LOG;

    public TestSessionState(Boolean mode) {
        this.prewarm = mode;
    }

    @Parameterized.Parameters
    public static Collection<Boolean[]> data() {
        return Arrays.asList({false}, {true});
    }

    @Before
    public void setUp() {
        HiveConf conf = new HiveConf();
        conf.set("fs.defaultFS", "file:///");
        String tmp = System.getProperty("java.io.tmpdir");
        File tmpDir = new File(tmp);
        if (!tmpDir.exists()) {
            tmpDir.mkdir();
        }
        hiveReloadPath = Files.createTempDir().getAbsolutePath();
        this.reloadFolder = new File(hiveReloadPath);
        if (!this.reloadFolder.exists()) {
            this.reloadFolder.mkdir();
        }
        try {
            this.generateRefreshJarFiles(V2);
            this.generateRefreshJarFiles(V1);
        }
        catch (Throwable e) {
            Assert.fail((String)("fail to generate refresh jar file due to the error " + e));
        }
        if (this.prewarm) {
            HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_PREWARM_ENABLED, (boolean)true);
            HiveConf.setIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_PREWARM_NUM_CONTAINERS, (int)1);
        }
        SessionState.start((HiveConf)conf);
    }

    @After
    public void tearDown() {
        FileUtils.deleteQuietly((File)this.reloadFolder);
    }

    @Test
    public void testgetDbName() throws Exception {
        Assert.assertEquals((Object)"default", (Object)SessionState.get().getCurrentDatabase());
        String newdb = "DB_2";
        SessionState.get().setCurrentDatabase("DB_2");
        Assert.assertEquals((Object)"DB_2", (Object)SessionState.get().getCurrentDatabase());
        HiveConf hiveConf = new HiveConf();
        hiveConf.set("fs.defaultFS", "file:///");
        SessionState.start((HiveConf)hiveConf);
        Assert.assertEquals((Object)"default", (Object)SessionState.get().getCurrentDatabase());
    }

    @Test
    public void testClose() throws Exception {
        SessionState ss = SessionState.get();
        Assert.assertNull((Object)ss.getTezSession());
        ss.close();
        Assert.assertNull((Object)ss.getTezSession());
    }

    @Test
    public void testClassLoaderEquality() throws Exception {
        HiveConf conf = new HiveConf();
        conf.set("fs.defaultFS", "file:///");
        SessionState ss1 = new SessionState(conf);
        RegisterJarRunnable otherThread = new RegisterJarRunnable("./build/contrib/test/test-udfs.jar", ss1);
        Thread th1 = new Thread(otherThread);
        th1.start();
        th1.join();
        SessionState.start((SessionState)ss1);
        SessionState ss2 = SessionState.get();
        ClassLoader loader2 = ss2.getConf().getClassLoader();
        System.out.println("Loader1:(Set in other thread) " + otherThread.loader);
        System.out.println("Loader2:(Set in SessionState.conf) " + loader2);
        System.out.println("Loader3:(CurrentThread.getContextClassLoader()) " + Thread.currentThread().getContextClassLoader());
        Assert.assertEquals((String)"Other thread loader and session state loader", (Object)otherThread.loader, (Object)loader2);
        Assert.assertEquals((String)"Other thread loader and current thread loader", (Object)otherThread.loader, (Object)Thread.currentThread().getContextClassLoader());
    }

    private String getReloadedClazzVersion(ClassLoader cl) throws Exception {
        Class<?> addedClazz = Class.forName(RELOADED_CLAZZ_PREFIX_NAME, true, cl);
        Method versionMethod = addedClazz.getMethod(versionMethodName, new Class[0]);
        return (String)versionMethod.invoke(addedClazz.newInstance(), new Object[0]);
    }

    private void generateRefreshJarFiles(String version) throws IOException, InterruptedException {
        String u = HiveTestUtils.getFileFromClasspath((String)(RELOADED_CLAZZ_PREFIX_NAME + version + ".txt"));
        File jarFile = HiveTestUtils.genLocalJarForTest((String)u, (String)RELOADED_CLAZZ_PREFIX_NAME);
        Files.move((File)jarFile, (File)new File(jarFile.getAbsolutePath() + "." + version));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Test
    public void testReloadAuxJars2() {
        block10: {
            HiveConf conf = new HiveConf();
            conf.set("fs.defaultFS", "file:///");
            HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVERELOADABLEJARS, (String)hiveReloadPath);
            SessionState ss = new SessionState(conf);
            SessionState.start((SessionState)ss);
            ss = SessionState.get();
            File dist = null;
            dist = new File(this.reloadFolder.getAbsolutePath() + File.separator + reloadClazzFileName);
            Files.copy((File)new File(HiveTestUtils.getFileFromClasspath((String)clazzDistFileName)), (File)dist);
            ss.loadReloadableAuxJars();
            Assert.assertEquals((Object)"version1", (Object)this.getReloadedClazzVersion(ss.getConf().getClassLoader()));
            FileUtils.deleteQuietly((File)dist);
            try {
                ss.close();
            }
            catch (IOException ioException) {
                Assert.fail((String)ioException.getMessage());
                LOG.error("Fail to close the created session: ", (Throwable)ioException);
            }
            break block10;
            catch (Exception e) {
                try {
                    LOG.error("Reload auxiliary jar test fail with message: ", (Throwable)e);
                    Assert.fail((String)e.getMessage());
                }
                catch (Throwable throwable) {
                    FileUtils.deleteQuietly(dist);
                    try {
                        ss.close();
                    }
                    catch (IOException ioException) {
                        Assert.fail((String)ioException.getMessage());
                        LOG.error("Fail to close the created session: ", (Throwable)ioException);
                    }
                    throw throwable;
                }
                FileUtils.deleteQuietly((File)dist);
                try {
                    ss.close();
                }
                catch (IOException ioException) {
                    Assert.fail((String)ioException.getMessage());
                    LOG.error("Fail to close the created session: ", (Throwable)ioException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testReloadExistingAuxJars2() {
        HiveConf conf = new HiveConf();
        conf.set("fs.defaultFS", "file:///");
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVERELOADABLEJARS, (String)hiveReloadPath);
        SessionState ss = new SessionState(conf);
        SessionState.start((SessionState)ss);
        File dist = null;
        try {
            ss = SessionState.get();
            LOG.info("copy jar file 1");
            dist = new File(this.reloadFolder.getAbsolutePath() + File.separator + reloadClazzFileName);
            Files.copy((File)new File(HiveTestUtils.getFileFromClasspath((String)clazzDistFileName)), (File)dist);
            ss.loadReloadableAuxJars();
            Assert.assertEquals((Object)"version1", (Object)this.getReloadedClazzVersion(ss.getConf().getClassLoader()));
            LOG.info("copy jar file 2");
            FileUtils.deleteQuietly((File)dist);
            Files.copy((File)new File(HiveTestUtils.getFileFromClasspath((String)clazzV2FileName)), (File)dist);
            ss.loadReloadableAuxJars();
            Assert.assertEquals((Object)"version2", (Object)this.getReloadedClazzVersion(ss.getConf().getClassLoader()));
            FileUtils.deleteQuietly((File)dist);
            ss.loadReloadableAuxJars();
            FileUtils.deleteQuietly((File)dist);
        }
        catch (Exception e) {
            LOG.error("refresh existing jar file case failed with message: ", (Throwable)e);
            Assert.fail((String)e.getMessage());
            return;
        }
        try {
            ss.close();
            return;
        }
        catch (IOException ioException) {
            Assert.fail((String)ioException.getMessage());
            LOG.error("Fail to close the created session: ", (Throwable)ioException);
            return;
        }
        finally {
            FileUtils.deleteQuietly(dist);
            try {
                ss.close();
            }
            catch (IOException ioException) {
                Assert.fail((String)ioException.getMessage());
                LOG.error("Fail to close the created session: ", (Throwable)ioException);
            }
        }
    }

    @Test
    @Ignore
    public void testCreatePath() throws Exception {
        HiveConf conf = new HiveConf();
        conf.set("fs.defaultFS", "file:///");
        LocalFileSystem localFileSystem = FileSystem.getLocal((Configuration)conf);
        Path repeatedCreate = new Path("repeatedCreate");
        SessionState.createPath((HiveConf)conf, (Path)repeatedCreate, (String)"700", (boolean)true, (boolean)true);
        Assert.assertTrue((boolean)localFileSystem.exists(repeatedCreate));
        SessionState.createPath((HiveConf)conf, (Path)repeatedCreate, (String)"700", (boolean)true, (boolean)true);
        Path fileNotDirectory = new Path("fileNotDirectory");
        localFileSystem.create(fileNotDirectory);
        localFileSystem.deleteOnExit(fileNotDirectory);
        try {
            SessionState.createPath((HiveConf)conf, (Path)new Path(fileNotDirectory, "child"), (String)"700", (boolean)true, (boolean)true);
            Assert.fail((String)"did not get expected exception creating a child of a file");
        }
        catch (ParentNotDirectoryException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Parent path is not a directory"));
        }
        try {
            SessionState.createPath((HiveConf)conf, (Path)new Path((String)null, "child"), (String)"700", (boolean)true, (boolean)true);
            Assert.fail((String)"did not get expected exception creating a Path from a null string");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Can not create a Path from a null string"));
        }
        Path noPermissions = new Path("noPermissions");
        SessionState.createPath((HiveConf)conf, (Path)noPermissions, (String)"000", (boolean)true, (boolean)true);
        try {
            SessionState.createPath((HiveConf)conf, (Path)new Path(noPermissions, "child"), (String)"700", (boolean)true, (boolean)true);
            Assert.fail((String)"did not get expected exception creating a child of a directory with no permissions");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Failed to create directory noPermissions/child"));
        }
    }

    @Test
    public void testGetUserName() throws IOException {
        String userName = "test_user";
        HiveConf hiveConf = new HiveConf();
        hiveConf.set("fs.defaultFS", "file:///");
        HiveConf conf = (HiveConf)Mockito.spy((Object)hiveConf);
        conf.set("fs.defaultFS", "file:///");
        Mockito.when((Object)conf.getUser()).thenReturn((Object)userName);
        SessionState ss = new SessionState(conf);
        SessionState.start((SessionState)ss);
        ss = SessionState.get();
        Assert.assertEquals((Object)userName, (Object)ss.getUserName());
    }

    static {
        LOG = LoggerFactory.getLogger(TestSessionState.class);
    }

    class RegisterJarRunnable
    implements Runnable {
        String jar;
        ClassLoader loader;
        SessionState ss;

        public RegisterJarRunnable(String jar, SessionState ss) {
            this.jar = jar;
            this.ss = ss;
        }

        @Override
        public void run() {
            SessionState.start((SessionState)this.ss);
            SessionState.registerJars(Arrays.asList(this.jar));
            this.loader = Thread.currentThread().getContextClassLoader();
        }
    }
}

