/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class TestHiveCopyFiles {
    private static boolean LOCAL_SOURCE = true;
    private static boolean NO_ACID = false;
    private static HiveConf hiveConf;
    private boolean isSourceLocal;
    @Rule
    public TemporaryFolder sourceFolder = new TemporaryFolder();
    @Rule
    public TemporaryFolder targetFolder = new TemporaryFolder();

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> getParameters() throws Exception {
        return Arrays.asList({0, LOCAL_SOURCE}, {15, LOCAL_SOURCE}, {0, !LOCAL_SOURCE}, {15, !LOCAL_SOURCE});
    }

    @BeforeClass
    public static void setUp() {
        hiveConf = new HiveConf(TestHiveCopyFiles.class);
        hiveConf.set("fs.defaultFS", "file:///");
        SessionState.start((HiveConf)hiveConf);
    }

    public TestHiveCopyFiles(int threadCount, boolean isSourceLocal) {
        hiveConf.setIntVar(HiveConf.ConfVars.HIVE_MOVE_FILES_THREAD_COUNT, threadCount);
        this.isSourceLocal = isSourceLocal;
    }

    @Test
    public void testRenameNewFilesOnSameFileSystem() throws IOException {
        Path sourcePath = new Path(this.sourceFolder.getRoot().getAbsolutePath());
        this.sourceFolder.newFile("000000_0");
        this.sourceFolder.newFile("000001_0");
        this.sourceFolder.newFile("000000_0.gz");
        this.sourceFolder.newFile("000001_0.gz");
        Path targetPath = new Path(this.targetFolder.getRoot().getAbsolutePath());
        FileSystem targetFs = targetPath.getFileSystem((Configuration)hiveConf);
        try {
            Hive.copyFiles((HiveConf)hiveConf, (Path)sourcePath, (Path)targetPath, (FileSystem)targetFs, (boolean)this.isSourceLocal, (boolean)NO_ACID, (boolean)false, null, (boolean)false, (boolean)false, (boolean)false);
        }
        catch (HiveException e) {
            e.printStackTrace();
            Assert.assertTrue((String)"Hive.copyFiles() threw an unexpected exception.", (boolean)false);
        }
        Assert.assertTrue((boolean)targetFs.exists(new Path(targetPath, "000000_0")));
        Assert.assertTrue((boolean)targetFs.exists(new Path(targetPath, "000001_0")));
        Assert.assertTrue((boolean)targetFs.exists(new Path(targetPath, "000000_0.gz")));
        Assert.assertTrue((boolean)targetFs.exists(new Path(targetPath, "000001_0.gz")));
    }

    @Test
    public void testRenameExistingFilesOnSameFileSystem() throws IOException {
        Path sourcePath = new Path(this.sourceFolder.getRoot().getAbsolutePath());
        this.sourceFolder.newFile("000000_0");
        this.sourceFolder.newFile("000001_0");
        this.sourceFolder.newFile("000000_0.gz");
        this.sourceFolder.newFile("000001_0.gz");
        Path targetPath = new Path(this.targetFolder.getRoot().getAbsolutePath());
        FileSystem targetFs = targetPath.getFileSystem((Configuration)hiveConf);
        try {
            Hive.copyFiles((HiveConf)hiveConf, (Path)sourcePath, (Path)targetPath, (FileSystem)targetFs, (boolean)this.isSourceLocal, (boolean)NO_ACID, (boolean)false, null, (boolean)false, (boolean)false, (boolean)false);
        }
        catch (HiveException e) {
            e.printStackTrace();
            Assert.assertTrue((String)"Hive.copyFiles() threw an unexpected exception.", (boolean)false);
        }
        if (this.isSourceLocal) {
            this.sourceFolder.delete();
            this.sourceFolder.create();
            sourcePath = new Path(this.sourceFolder.getRoot().getAbsolutePath());
        }
        this.sourceFolder.newFile("000000_0");
        this.sourceFolder.newFile("000001_0");
        this.sourceFolder.newFile("000000_0.gz");
        this.sourceFolder.newFile("000001_0.gz");
        try {
            Hive.copyFiles((HiveConf)hiveConf, (Path)sourcePath, (Path)targetPath, (FileSystem)targetFs, (boolean)this.isSourceLocal, (boolean)NO_ACID, (boolean)false, null, (boolean)false, (boolean)false, (boolean)false);
        }
        catch (HiveException e) {
            e.printStackTrace();
            Assert.assertTrue((String)"Hive.copyFiles() threw an unexpected exception.", (boolean)false);
        }
        Assert.assertTrue((boolean)targetFs.exists(new Path(targetPath, "000000_0")));
        Assert.assertTrue((boolean)targetFs.exists(new Path(targetPath, "000001_0")));
        Assert.assertTrue((boolean)targetFs.exists(new Path(targetPath, "000000_0.gz")));
        Assert.assertTrue((boolean)targetFs.exists(new Path(targetPath, "000001_0.gz")));
        Assert.assertTrue((boolean)targetFs.exists(new Path(targetPath, "000000_0_copy_1")));
        Assert.assertTrue((boolean)targetFs.exists(new Path(targetPath, "000001_0_copy_1")));
        Assert.assertTrue((boolean)targetFs.exists(new Path(targetPath, "000000_0_copy_1.gz")));
        Assert.assertTrue((boolean)targetFs.exists(new Path(targetPath, "000001_0_copy_1.gz")));
    }

    @Test
    public void testCopyNewFilesOnDifferentFileSystem() throws IOException {
        Path sourcePath = new Path(this.sourceFolder.getRoot().getAbsolutePath());
        this.sourceFolder.newFile("000000_0");
        this.sourceFolder.newFile("000001_0");
        this.sourceFolder.newFile("000000_0.gz");
        this.sourceFolder.newFile("000001_0.gz");
        Path targetPath = new Path(this.targetFolder.getRoot().getAbsolutePath());
        FileSystem spyTargetFs = (FileSystem)Mockito.spy((Object)targetPath.getFileSystem((Configuration)hiveConf));
        Mockito.when((Object)spyTargetFs.getUri()).thenReturn((Object)URI.create("hdfs://" + targetPath.toUri().getPath()));
        try {
            Hive.copyFiles((HiveConf)hiveConf, (Path)sourcePath, (Path)targetPath, (FileSystem)spyTargetFs, (boolean)this.isSourceLocal, (boolean)NO_ACID, (boolean)false, null, (boolean)false, (boolean)false, (boolean)false);
        }
        catch (HiveException e) {
            e.printStackTrace();
            Assert.assertTrue((String)"Hive.copyFiles() threw an unexpected exception.", (boolean)false);
        }
        Assert.assertTrue((boolean)spyTargetFs.exists(new Path(targetPath, "000000_0")));
        Assert.assertTrue((boolean)spyTargetFs.exists(new Path(targetPath, "000001_0")));
        Assert.assertTrue((boolean)spyTargetFs.exists(new Path(targetPath, "000000_0.gz")));
        Assert.assertTrue((boolean)spyTargetFs.exists(new Path(targetPath, "000001_0.gz")));
    }

    @Test
    public void testCopyExistingFilesOnDifferentFileSystem() throws IOException {
        Path sourcePath = new Path(this.sourceFolder.getRoot().getAbsolutePath());
        this.sourceFolder.newFile("000000_0");
        this.sourceFolder.newFile("000001_0");
        this.sourceFolder.newFile("000000_0.gz");
        this.sourceFolder.newFile("000001_0.gz");
        Path targetPath = new Path(this.targetFolder.getRoot().getAbsolutePath());
        FileSystem spyTargetFs = (FileSystem)Mockito.spy((Object)targetPath.getFileSystem((Configuration)hiveConf));
        Mockito.when((Object)spyTargetFs.getUri()).thenReturn((Object)URI.create("hdfs://" + targetPath.toUri().getPath()));
        try {
            Hive.copyFiles((HiveConf)hiveConf, (Path)sourcePath, (Path)targetPath, (FileSystem)spyTargetFs, (boolean)this.isSourceLocal, (boolean)NO_ACID, (boolean)false, null, (boolean)false, (boolean)false, (boolean)false);
        }
        catch (HiveException e) {
            e.printStackTrace();
            Assert.assertTrue((String)"Hive.copyFiles() threw an unexpected exception.", (boolean)false);
        }
        if (this.isSourceLocal) {
            this.sourceFolder.delete();
            this.sourceFolder.create();
            sourcePath = new Path(this.sourceFolder.getRoot().getAbsolutePath());
        }
        this.sourceFolder.newFile("000000_0");
        this.sourceFolder.newFile("000001_0");
        this.sourceFolder.newFile("000000_0.gz");
        this.sourceFolder.newFile("000001_0.gz");
        try {
            Hive.copyFiles((HiveConf)hiveConf, (Path)sourcePath, (Path)targetPath, (FileSystem)spyTargetFs, (boolean)this.isSourceLocal, (boolean)NO_ACID, (boolean)false, null, (boolean)false, (boolean)false, (boolean)false);
        }
        catch (HiveException e) {
            e.printStackTrace();
            Assert.assertTrue((String)"Hive.copyFiles() threw an unexpected exception.", (boolean)false);
        }
        Assert.assertTrue((boolean)spyTargetFs.exists(new Path(targetPath, "000000_0")));
        Assert.assertTrue((boolean)spyTargetFs.exists(new Path(targetPath, "000001_0")));
        Assert.assertTrue((boolean)spyTargetFs.exists(new Path(targetPath, "000000_0.gz")));
        Assert.assertTrue((boolean)spyTargetFs.exists(new Path(targetPath, "000001_0.gz")));
        Assert.assertTrue((boolean)spyTargetFs.exists(new Path(targetPath, "000000_0_copy_1")));
        Assert.assertTrue((boolean)spyTargetFs.exists(new Path(targetPath, "000001_0_copy_1")));
        Assert.assertTrue((boolean)spyTargetFs.exists(new Path(targetPath, "000000_0_copy_1.gz")));
        Assert.assertTrue((boolean)spyTargetFs.exists(new Path(targetPath, "000001_0_copy_1.gz")));
    }
}

