/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lockmgr;

import junit.framework.Assert;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObject;
import org.junit.Test;

public class TestHiveLockObject {
    private HiveConf conf = new HiveConf();

    @Test
    public void testEqualsAndHashCode() {
        HiveLockObject.HiveLockObjectData data1 = new HiveLockObject.HiveLockObjectData("ID1", "SHARED", "1997-07-01", "select * from mytable", this.conf);
        HiveLockObject.HiveLockObjectData data2 = new HiveLockObject.HiveLockObjectData("ID1", "SHARED", "1997-07-01", "select * from mytable", this.conf);
        Assert.assertEquals((Object)data1, (Object)data2);
        Assert.assertEquals((int)data1.hashCode(), (int)data2.hashCode());
        HiveLockObject obj1 = new HiveLockObject("mytable", data1);
        HiveLockObject obj2 = new HiveLockObject("mytable", data2);
        Assert.assertEquals((Object)obj1, (Object)obj2);
        Assert.assertEquals((int)obj1.hashCode(), (int)obj2.hashCode());
    }

    @Test
    public void testTruncate() {
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_LOCK_QUERY_STRING_MAX_LENGTH, 1000000);
        HiveLockObject.HiveLockObjectData data0 = new HiveLockObject.HiveLockObjectData("ID1", "SHARED", "1997-07-01", "01234567890", this.conf);
        Assert.assertEquals((String)"With default settings query string should not be truncated", (int)data0.getQueryStr().length(), (int)11);
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_LOCK_QUERY_STRING_MAX_LENGTH, 10);
        HiveLockObject.HiveLockObjectData data1 = new HiveLockObject.HiveLockObjectData("ID1", "SHARED", "1997-07-01", "01234567890", this.conf);
        HiveLockObject.HiveLockObjectData data2 = new HiveLockObject.HiveLockObjectData("ID1", "SHARED", "1997-07-01", "0123456789", this.conf);
        HiveLockObject.HiveLockObjectData data3 = new HiveLockObject.HiveLockObjectData("ID1", "SHARED", "1997-07-01", "012345678", this.conf);
        HiveLockObject.HiveLockObjectData data4 = new HiveLockObject.HiveLockObjectData("ID1", "SHARED", "1997-07-01", null, this.conf);
        Assert.assertEquals((String)"Long string truncation failed", (int)data1.getQueryStr().length(), (int)10);
        Assert.assertEquals((String)"String truncation failed", (int)data2.getQueryStr().length(), (int)10);
        Assert.assertEquals((String)"Short string should not be truncated", (int)data3.getQueryStr().length(), (int)9);
        Assert.assertNull((String)"Null query string handling failed", (Object)data4.getQueryStr());
    }
}

