/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColUnaryMinus;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColUnaryMinusChecked;
import org.apache.hadoop.hive.ql.exec.vector.util.VectorizedRowGroupGenUtil;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestUnaryMinus {
    @Test
    public void testUnaryMinus() throws HiveException {
        VectorizedRowBatch vrg = VectorizedRowGroupGenUtil.getVectorizedRowBatch(1024, 2, 23);
        LongColUnaryMinus expr = new LongColUnaryMinus(0, 1);
        expr.evaluate(vrg);
        long[] inVector = ((LongColumnVector)vrg.cols[0]).vector;
        long[] outVector = ((LongColumnVector)vrg.cols[1]).vector;
        for (int i = 0; i < outVector.length; ++i) {
            Assert.assertEquals((long)0L, (long)(inVector[i] + outVector[i]));
        }
    }

    @Test
    public void testUnaryMinusCheckedOverflow() throws HiveException {
        VectorizedRowBatch vrg = VectorizedRowGroupGenUtil.getVectorizedRowBatch(1, 2, 0);
        ((LongColumnVector)vrg.cols[0]).vector[0] = Integer.MIN_VALUE;
        LongColUnaryMinusChecked expr = new LongColUnaryMinusChecked(0, 1);
        expr.setOutputTypeInfo((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        expr.evaluate(vrg);
        long[] inVector = ((LongColumnVector)vrg.cols[0]).vector;
        long[] outVector = ((LongColumnVector)vrg.cols[1]).vector;
        for (int i = 0; i < outVector.length; ++i) {
            Assert.assertEquals((long)Integer.MIN_VALUE, (long)outVector[i]);
        }
    }

    @Test
    public void testUnaryMinusChecked() throws HiveException {
        VectorizedRowBatch vrg = VectorizedRowGroupGenUtil.getVectorizedRowBatch(1024, 2, 23);
        LongColUnaryMinusChecked expr = new LongColUnaryMinusChecked(0, 1);
        expr.setOutputTypeInfo((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"bigint"));
        expr.evaluate(vrg);
        long[] inVector = ((LongColumnVector)vrg.cols[0]).vector;
        long[] outVector = ((LongColumnVector)vrg.cols[1]).vector;
        for (int i = 0; i < outVector.length; ++i) {
            Assert.assertEquals((long)0L, (long)(inVector[i] + outVector[i]));
        }
    }
}

