/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.txn.TxnDbUtil;
import org.apache.hadoop.hive.ql.TestTxnCommands;
import org.apache.hadoop.hive.ql.TestTxnCommands2;
import org.apache.hadoop.hive.ql.TxnCommandsBaseForTests;
import org.apache.hadoop.hive.ql.txn.compactor.Initiator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
public class TestTxnCommandsForMmTable
extends TxnCommandsBaseForTests {
    private static final Logger LOG = LoggerFactory.getLogger(TestTxnCommandsForMmTable.class);
    protected static final String TEST_DATA_DIR = new File(System.getProperty("java.io.tmpdir") + File.separator + TestTxnCommands.class.getCanonicalName() + "-" + System.currentTimeMillis()).getPath().replaceAll("\\\\", "/");
    protected static final String TEST_WAREHOUSE_DIR = TEST_DATA_DIR + "/warehouse";

    @Override
    String getTestDataDir() {
        return TEST_DATA_DIR;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUpInternal();
        this.setUpInternalExtended(false);
    }

    void setUpInternalExtended(boolean isOrcFormat) throws Exception {
        this.hiveConf.setBoolVar(HiveConf.ConfVars.DYNAMICPARTITIONING, true);
        this.hiveConf.setVar(HiveConf.ConfVars.DYNAMICPARTITIONINGMODE, "nonstrict");
        this.hiveConf.setVar(HiveConf.ConfVars.HIVEMAPREDMODE, "nonstrict");
        this.hiveConf.setVar(HiveConf.ConfVars.HIVEFETCHTASKCONVERSION, "none");
        this.hiveConf.set(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY.varname, "true");
        this.hiveConf.setVar(HiveConf.ConfVars.HIVE_TXN_MANAGER, "org.apache.hadoop.hive.ql.lockmgr.DbTxnManager");
        this.runStatementOnDriver("create table " + TableExtended.NONACIDPART + "(a int, b int) partitioned by (p string) stored as orc TBLPROPERTIES ('transactional'='false')");
        if (!isOrcFormat) {
            this.runStatementOnDriver("create table " + TableExtended.MMTBL + "(a int, b int) TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')");
            this.runStatementOnDriver("create table " + TableExtended.MMTBL2 + "(a int, b int) TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')");
            this.runStatementOnDriver("create table " + TableExtended.MMTBLPART + "(a int, b int) partitioned by (p string) TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')");
        } else {
            this.runStatementOnDriver("create table " + TableExtended.MMTBL + "(a int, b int) stored as orc TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')");
            this.runStatementOnDriver("create table " + TableExtended.MMTBL2 + "(a int, b int) stored as orc TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')");
            this.runStatementOnDriver("create table " + TableExtended.MMTBLPART + "(a int, b int) partitioned by (p string) stored as orc TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')");
        }
    }

    @Override
    protected void dropTables() throws Exception {
        super.dropTables();
        for (TableExtended t : TableExtended.values()) {
            this.runStatementOnDriver("drop table if exists " + t);
        }
    }

    @Test
    public void testMmTableCompaction() throws Exception {
        this.runStatementOnDriver("insert into " + TableExtended.MMTBL + "(a,b) values(1,2)");
        this.runStatementOnDriver("insert into " + TableExtended.MMTBL + "(a,b) values(3,4)");
        this.verifyDirAndResult(2);
        this.runStatementOnDriver("alter table " + TableExtended.MMTBL + " compact 'MINOR'");
        this.runWorker(this.hiveConf);
        this.verifyDirAndResult(2);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVETESTMODEROLLBACKTXN, true);
        this.runStatementOnDriver("insert into " + TableExtended.MMTBL + "(a,b) values(5,6)");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVETESTMODEROLLBACKTXN, false);
        this.verifyDirAndResult(3);
        this.runStatementOnDriver("alter table " + TableExtended.MMTBL + " compact 'MINOR'");
        this.runWorker(this.hiveConf);
        this.verifyDirAndResult(2);
        this.runCleaner(this.hiveConf);
        this.verifyDirAndResult(2);
    }

    @Test
    public void testInsertOverwriteForMmTable() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        this.runStatementOnDriver("insert into " + TableExtended.MMTBL + "(a,b) values(1,2)");
        this.runStatementOnDriver("insert into " + TableExtended.MMTBL + "(a,b) values(3,4)");
        FileStatus[] status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + TableExtended.MMTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)2L, (long)status.length);
        for (int i = 0; i < status.length; ++i) {
            Assert.assertTrue((boolean)status[i].getPath().getName().matches("delta_.*"));
        }
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + "(a,b) values(5,6),(7,8)");
        this.runStatementOnDriver("insert overwrite table " + TableExtended.MMTBL + " select a,b from " + TxnCommandsBaseForTests.Table.NONACIDORCTBL);
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + TableExtended.MMTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)3L, (long)status.length);
        int baseCount = 0;
        int deltaCount = 0;
        for (int i = 0; i < status.length; ++i) {
            String dirName = status[i].getPath().getName();
            if (dirName.matches("delta_.*")) {
                ++deltaCount;
                continue;
            }
            ++baseCount;
        }
        Assert.assertEquals((long)2L, (long)deltaCount);
        Assert.assertEquals((long)1L, (long)baseCount);
        int[][] resultData = new int[][]{{5, 6}, {7, 8}};
        List<String> rs = this.runStatementOnDriver("select a,b from " + TableExtended.MMTBL + " order by a,b");
        Assert.assertEquals(this.stringifyValues(resultData), rs);
    }

    @Test
    @Ignore(value="Error in Apache Hive")
    public void testInsertOverwriteForPartitionedMmTable() throws Exception {
        FileStatus[] status;
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        int[][] valuesOdd = new int[][]{{5, 6}, {7, 8}};
        int[][] valuesEven = new int[][]{{2, 1}, {4, 3}};
        this.runStatementOnDriver("insert into " + TableExtended.MMTBLPART + " PARTITION(p='odd') " + this.makeValuesClause(valuesOdd));
        this.runStatementOnDriver("insert into " + TableExtended.MMTBLPART + " PARTITION(p='even') " + this.makeValuesClause(valuesEven));
        String[] pStrings = new String[]{"/p=odd", "/p=even"};
        for (int i = 0; i < pStrings.length; ++i) {
            status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + TableExtended.MMTBLPART.toString().toLowerCase() + pStrings[i]), FileUtils.STAGING_DIR_PATH_FILTER);
            Assert.assertEquals((long)1L, (long)status.length);
            Assert.assertTrue((boolean)status[0].getPath().getName().matches("delta_.*"));
        }
        int[][] newValsOdd = new int[][]{{5, 5}, {11, 11}};
        int[][] newValsEven = new int[][]{{2, 2}};
        this.runStatementOnDriver("insert into " + TableExtended.NONACIDPART + " PARTITION(p='odd') " + this.makeValuesClause(newValsOdd));
        this.runStatementOnDriver("insert into " + TableExtended.NONACIDPART + " PARTITION(p='even') " + this.makeValuesClause(newValsEven));
        List<String> rs = null;
        String s = "insert overwrite table " + TableExtended.MMTBLPART + " PARTITION(p='odd')  select a,b from " + TableExtended.NONACIDPART + " where " + TableExtended.NONACIDPART + ".p='odd'";
        rs = this.runStatementOnDriver("explain formatted " + s);
        LOG.info("Explain formatted: " + rs.toString());
        this.runStatementOnDriver(s);
        s = "insert overwrite table " + TableExtended.MMTBLPART + " PARTITION(p='even')  select a,b from " + TableExtended.NONACIDPART + " where " + TableExtended.NONACIDPART + ".p='even'";
        this.runStatementOnDriver(s);
        boolean sawBase = false;
        String[] baseDirs = new String[]{"", ""};
        int deltaCount = 0;
        for (int h = 0; h < pStrings.length; ++h) {
            status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + TableExtended.MMTBLPART.toString().toLowerCase() + pStrings[h]), FileUtils.STAGING_DIR_PATH_FILTER);
            Assert.assertEquals((long)2L, (long)status.length);
            for (int i = 0; i < status.length; ++i) {
                String dirName = status[i].getPath().getName();
                if (dirName.matches("delta_.*")) {
                    ++deltaCount;
                    continue;
                }
                sawBase = true;
                baseDirs[h] = dirName;
                Assert.assertTrue((boolean)baseDirs[i].matches("base_.*"));
            }
            Assert.assertEquals((long)1L, (long)deltaCount);
            Assert.assertTrue((boolean)sawBase);
            deltaCount = 0;
            sawBase = false;
        }
        rs = this.runStatementOnDriver("select a,b from " + TableExtended.MMTBLPART + " where p='even' order by a,b");
        int[][] rExpectedEven = new int[][]{{2, 2}};
        Assert.assertEquals(this.stringifyValues(rExpectedEven), rs);
        rs = this.runStatementOnDriver("select a,b from " + TableExtended.MMTBLPART + " where p='odd' order by a,b");
        int[][] rExpectedOdd = new int[][]{{5, 5}, {11, 11}};
        Assert.assertEquals(this.stringifyValues(rExpectedOdd), rs);
        this.runStatementOnDriver("alter table " + TableExtended.MMTBLPART + " PARTITION(p='odd')  compact 'MAJOR'");
        this.runWorker(this.hiveConf);
        this.runStatementOnDriver("alter table " + TableExtended.MMTBLPART + " PARTITION(p='even')  compact 'MAJOR'");
        this.runWorker(this.hiveConf);
        for (int h = 0; h < pStrings.length; ++h) {
            status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + TableExtended.MMTBLPART.toString().toLowerCase() + pStrings[h]), FileUtils.STAGING_DIR_PATH_FILTER);
            Assert.assertEquals((long)2L, (long)status.length);
            sawBase = false;
            deltaCount = 0;
            for (int i = 0; i < status.length; ++i) {
                String dirName = status[i].getPath().getName();
                if (dirName.matches("delta_.*")) {
                    ++deltaCount;
                    continue;
                }
                sawBase = true;
                Assert.assertTrue((String)("BASE ERROR: " + dirName), (boolean)dirName.matches("base_.*"));
                Assert.assertEquals((Object)baseDirs[h], (Object)dirName);
            }
            Assert.assertEquals((long)1L, (long)deltaCount);
            Assert.assertTrue((boolean)sawBase);
            deltaCount = 0;
            sawBase = false;
        }
        rs = this.runStatementOnDriver("select a,b from " + TableExtended.MMTBLPART + " order by a,b");
        int[][] rExpected = new int[][]{{2, 2}, {5, 5}, {11, 11}};
        Assert.assertEquals(this.stringifyValues(rExpected), rs);
        this.runCleaner(this.hiveConf);
        for (int h = 0; h < pStrings.length; ++h) {
            status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + TableExtended.MMTBLPART.toString().toLowerCase() + pStrings[h]), FileUtils.STAGING_DIR_PATH_FILTER);
            Assert.assertEquals((long)1L, (long)status.length);
            Assert.assertTrue((boolean)status[0].getPath().getName().matches("base_.*"));
            Assert.assertEquals((Object)baseDirs[h], (Object)status[0].getPath().getName());
        }
        rs = this.runStatementOnDriver("select a,b from " + TableExtended.MMTBLPART + " order by a,b");
        Assert.assertEquals(this.stringifyValues(rExpected), rs);
    }

    @Test
    public void testInsertOverwriteWithDynamicPartition() throws Exception {
        FileStatus[] status;
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        int[][] valuesOdd = new int[][]{{5, 6}, {7, 8}};
        int[][] valuesEven = new int[][]{{2, 1}, {4, 3}};
        this.runStatementOnDriver("insert into " + TableExtended.MMTBLPART + " PARTITION(p='odd') " + this.makeValuesClause(valuesOdd));
        this.runStatementOnDriver("insert into " + TableExtended.MMTBLPART + " PARTITION(p='even') " + this.makeValuesClause(valuesEven));
        String[] pStrings = new String[]{"/p=odd", "/p=even"};
        for (int i = 0; i < pStrings.length; ++i) {
            status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + TableExtended.MMTBLPART.toString().toLowerCase() + pStrings[i]), FileUtils.STAGING_DIR_PATH_FILTER);
            Assert.assertEquals((long)1L, (long)status.length);
            Assert.assertTrue((boolean)status[0].getPath().getName().matches("delta_.*"));
        }
        int[][] newValsOdd = new int[][]{{5, 5}, {11, 11}};
        int[][] newValsEven = new int[][]{{2, 2}};
        this.runStatementOnDriver("insert into " + TableExtended.NONACIDPART + " PARTITION(p='odd') " + this.makeValuesClause(newValsOdd));
        this.runStatementOnDriver("insert into " + TableExtended.NONACIDPART + " PARTITION(p='even') " + this.makeValuesClause(newValsEven));
        this.runStatementOnDriver("insert overwrite table " + TableExtended.MMTBLPART + " partition(p) select a,b,p from " + TableExtended.NONACIDPART);
        boolean sawBase = false;
        String[] baseDirs = new String[]{"", ""};
        int deltaCount = 0;
        for (int h = 0; h < pStrings.length; ++h) {
            status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + TableExtended.MMTBLPART.toString().toLowerCase() + pStrings[h]), FileUtils.STAGING_DIR_PATH_FILTER);
            Assert.assertEquals((long)2L, (long)status.length);
            for (int i = 0; i < status.length; ++i) {
                String dirName = status[i].getPath().getName();
                if (dirName.matches("delta_.*")) {
                    ++deltaCount;
                    continue;
                }
                sawBase = true;
                baseDirs[h] = dirName;
                Assert.assertTrue((boolean)baseDirs[h].matches("base_.*"));
            }
            Assert.assertEquals((long)1L, (long)deltaCount);
            Assert.assertTrue((boolean)sawBase);
            deltaCount = 0;
            sawBase = false;
        }
        List<String> rs = null;
        rs = this.runStatementOnDriver("select a,b from " + TableExtended.MMTBLPART + " where p='even' order by a,b");
        int[][] rExpectedEven = new int[][]{{2, 2}};
        Assert.assertEquals(this.stringifyValues(rExpectedEven), rs);
        rs = this.runStatementOnDriver("select a,b from " + TableExtended.MMTBLPART + " where p='odd' order by a,b");
        int[][] rExpectedOdd = new int[][]{{5, 5}, {11, 11}};
        Assert.assertEquals(this.stringifyValues(rExpectedOdd), rs);
        rs = this.runStatementOnDriver("select a,b from " + TableExtended.MMTBLPART + " order by a,b");
        int[][] rExpected = new int[][]{{2, 2}, {5, 5}, {11, 11}};
        Assert.assertEquals(this.stringifyValues(rExpected), rs);
    }

    @Test
    public void testInsertOverwriteWithUnionAll() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        this.runStatementOnDriver("insert into " + TableExtended.MMTBL + "(a,b) values(1,2)");
        this.runStatementOnDriver("insert into " + TableExtended.MMTBL + "(a,b) values(3,4)");
        FileStatus[] status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + TableExtended.MMTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)2L, (long)status.length);
        for (int i = 0; i < status.length; ++i) {
            Assert.assertTrue((boolean)status[i].getPath().getName().matches("delta_.*"));
        }
        int[][] values = new int[][]{{1, 2}, {2, 4}, {5, 6}, {6, 8}, {9, 10}};
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + TestTxnCommands2.makeValuesClause(values));
        this.runStatementOnDriver("insert overwrite table " + TableExtended.MMTBL + " select a,b from " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + " where a between 1 and 3 union all select a,b from " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + " where a between 5 and 7");
        boolean sawBase = false;
        String baseDir = "";
        int deltaCount = 0;
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + TableExtended.MMTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)3L, (long)status.length);
        for (int i = 0; i < status.length; ++i) {
            String dirName = status[i].getPath().getName();
            if (dirName.matches("delta_.*")) {
                ++deltaCount;
                continue;
            }
            sawBase = true;
            baseDir = dirName;
            Assert.assertTrue((boolean)baseDir.matches("base_.*"));
        }
        Assert.assertEquals((long)2L, (long)deltaCount);
        Assert.assertTrue((boolean)sawBase);
        List<String> rs = this.runStatementOnDriver("select a,b from " + TableExtended.MMTBL + " order by a,b");
        int[][] rExpected = new int[][]{{1, 2}, {2, 4}, {5, 6}, {6, 8}};
        Assert.assertEquals(this.stringifyValues(rExpected), rs);
        this.runStatementOnDriver("alter table " + TableExtended.MMTBL + " compact 'MAJOR'");
        this.runWorker(this.hiveConf);
        this.runCleaner(this.hiveConf);
        rs = this.runStatementOnDriver("select a,b from " + TableExtended.MMTBL + " order by a,b");
        Assert.assertEquals(this.stringifyValues(rExpected), rs);
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + TableExtended.MMTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)1L, (long)status.length);
        sawBase = false;
        deltaCount = 0;
        for (int i = 0; i < status.length; ++i) {
            String dirName = status[i].getPath().getName();
            if (dirName.matches("delta_.*")) {
                ++deltaCount;
                continue;
            }
            sawBase = true;
            baseDir = dirName;
            Assert.assertTrue((boolean)baseDir.matches("base_.*"));
        }
        Assert.assertEquals((long)0L, (long)deltaCount);
        Assert.assertTrue((boolean)sawBase);
        rs = this.runStatementOnDriver("select a,b from " + TableExtended.MMTBL + " order by a,b");
        Assert.assertEquals(this.stringifyValues(rExpected), rs);
    }

    @Test
    public void testOperationsOnCompletedTxnComponentsForMmTable() throws Exception {
        this.runStatementOnDriver("insert into " + TableExtended.MMTBL + "(a,b) values(1,2)");
        this.runStatementOnDriver("insert into " + TableExtended.MMTBL + "(a,b) values(3,4)");
        this.verifyDirAndResult(2);
        Assert.assertEquals((String)TxnDbUtil.queryToString((Configuration)this.hiveConf, (String)"select * from COMPLETED_TXN_COMPONENTS"), (long)2L, (long)TxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from COMPLETED_TXN_COMPONENTS"));
        Assert.assertEquals((String)TxnDbUtil.queryToString((Configuration)this.hiveConf, (String)"select * from TXNS"), (long)0L, (long)TxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from TXNS"));
        this.runStatementOnDriver("alter table " + TableExtended.MMTBL + " compact 'MAJOR'");
        this.runWorker(this.hiveConf);
        this.runCleaner(this.hiveConf);
        Assert.assertEquals((String)TxnDbUtil.queryToString((Configuration)this.hiveConf, (String)"select * from COMPLETED_TXN_COMPONENTS"), (long)0L, (long)TxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from COMPLETED_TXN_COMPONENTS"));
        Assert.assertEquals((String)TxnDbUtil.queryToString((Configuration)this.hiveConf, (String)"select * from TXNS"), (long)0L, (long)TxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from TXNS"));
    }

    @Test
    public void testSnapshotIsolationWithAbortedTxnOnMmTable() throws Exception {
        this.runStatementOnDriver("insert into " + TableExtended.MMTBL + "(a,b) values(1,2)");
        this.runStatementOnDriver("insert into " + TableExtended.MMTBL + "(a,b) values(3,4)");
        this.verifyDirAndResult(2);
        this.runStatementOnDriver("alter table " + TableExtended.MMTBL + " compact 'MINOR'");
        this.runWorker(this.hiveConf);
        this.verifyDirAndResult(2);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVETESTMODEROLLBACKTXN, true);
        this.runStatementOnDriver("insert into " + TableExtended.MMTBL + " values (5, 6)");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVETESTMODEROLLBACKTXN, false);
        this.verifyDirAndResult(3);
        int[][] expected = new int[][]{{1, 2}, {3, 4}};
        List<String> rs = this.runStatementOnDriver("select a,b from " + TableExtended.MMTBL + " order by a,b");
        Assert.assertEquals(this.stringifyValues(expected), rs);
        this.runCleaner(this.hiveConf);
        this.verifyDirAndResult(3);
        rs = this.runStatementOnDriver("select a,b from " + TableExtended.MMTBL + " order by a,b");
        Assert.assertEquals(this.stringifyValues(expected), rs);
        Assert.assertEquals((String)TxnDbUtil.queryToString((Configuration)this.hiveConf, (String)"select * from TXNS"), (long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from TXNS"));
        Initiator i = new Initiator();
        i.setThreadId((int)i.getId());
        i.setConf((Configuration)this.hiveConf);
        AtomicBoolean stop = new AtomicBoolean(true);
        i.init(stop, new AtomicBoolean());
        i.run();
        this.verifyDirAndResult(3);
        Assert.assertEquals((String)TxnDbUtil.queryToString((Configuration)this.hiveConf, (String)"select * from TXNS"), (long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from TXNS"));
        rs = this.runStatementOnDriver("select a,b from " + TableExtended.MMTBL + " order by a,b");
        Assert.assertEquals(this.stringifyValues(expected), rs);
        this.runStatementOnDriver("alter table " + TableExtended.MMTBL + " compact 'MINOR'");
        this.runWorker(this.hiveConf);
        Assert.assertEquals((String)TxnDbUtil.queryToString((Configuration)this.hiveConf, (String)"select * from TXNS"), (long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from TXNS"));
        Assert.assertEquals((String)TxnDbUtil.queryToString((Configuration)this.hiveConf, (String)"select * from TXN_COMPONENTS"), (long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from TXN_COMPONENTS"));
        this.verifyDirAndResult(2);
        this.runCleaner(this.hiveConf);
        i.run();
        Assert.assertEquals((String)TxnDbUtil.queryToString((Configuration)this.hiveConf, (String)"select * from TXNS"), (long)0L, (long)TxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from TXNS"));
        Assert.assertEquals((String)TxnDbUtil.queryToString((Configuration)this.hiveConf, (String)"select * from TXN_COMPONENTS"), (long)0L, (long)TxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from TXN_COMPONENTS"));
    }

    private void verifyDirAndResult(int expectedDeltas) throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        FileStatus[] status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + TableExtended.MMTBL.toString().toLowerCase()), FileUtils.HIDDEN_FILES_PATH_FILTER);
        int sawDeltaTimes = 0;
        for (int i = 0; i < status.length; ++i) {
            Assert.assertTrue((boolean)status[i].getPath().getName().matches("delta_.*"));
            ++sawDeltaTimes;
            FileStatus[] files = fs.listStatus(status[i].getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER);
            Assert.assertEquals((long)1L, (long)files.length);
            Assert.assertTrue((boolean)files[0].getPath().getName().equals("000000_0"));
        }
        Assert.assertEquals((long)expectedDeltas, (long)sawDeltaTimes);
        int[][] resultData = new int[][]{{1, 2}, {3, 4}};
        List<String> rs = this.runStatementOnDriver("select a,b from " + TableExtended.MMTBL + " order by a,b");
        Assert.assertEquals(this.stringifyValues(resultData), rs);
    }

    static enum TableExtended {
        NONACIDPART("nonAcidPart", "p"),
        MMTBL("mmTbl"),
        MMTBL2("mmTbl2"),
        MMTBLPART("mmTblPart", "p");

        final String name;
        final String partitionColumns;

        public String toString() {
            return this.name;
        }

        String getPartitionColumns() {
            return this.partitionColumns;
        }

        private TableExtended(String name) {
            this(name, null);
        }

        private TableExtended(String name, String partitionColumns) {
            this.name = name;
            this.partitionColumns = partitionColumns;
        }
    }
}

