/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriterFactory;
import org.apache.hadoop.hive.ql.exec.vector.util.VectorizedRowGroupGenUtil;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.junit.Test;

public class TestVectorExpressionWriters {
    private final int vectorSize = 5;

    private VectorExpressionWriter getWriter(TypeInfo colTypeInfo) throws HiveException {
        ExprNodeColumnDesc columnDesc = new ExprNodeColumnDesc();
        columnDesc.setTypeInfo(colTypeInfo);
        VectorExpressionWriter vew = VectorExpressionWriterFactory.genVectorExpressionWritable((ExprNodeDesc)columnDesc);
        return vew;
    }

    private Writable getWritableValue(TypeInfo ti, double value) {
        if (ti.equals((Object)TypeInfoFactory.floatTypeInfo)) {
            return new FloatWritable((float)value);
        }
        if (ti.equals((Object)TypeInfoFactory.doubleTypeInfo)) {
            return new DoubleWritable(value);
        }
        return null;
    }

    private Writable getWritableValue(TypeInfo ti, Timestamp value) {
        return new TimestampWritableV2(org.apache.hadoop.hive.common.type.Timestamp.ofEpochMilli((long)value.getTime(), (int)value.getNanos()));
    }

    private Writable getWritableValue(TypeInfo ti, HiveDecimal value) {
        return new HiveDecimalWritable(value);
    }

    private Writable getWritableValue(TypeInfo ti, byte[] value) {
        if (ti.equals((Object)TypeInfoFactory.stringTypeInfo)) {
            return new Text(value);
        }
        if (ti.equals((Object)TypeInfoFactory.varcharTypeInfo)) {
            return new HiveVarcharWritable(new HiveVarchar(new Text(value).toString(), -1));
        }
        if (ti.equals((Object)TypeInfoFactory.binaryTypeInfo)) {
            return new BytesWritable(value);
        }
        return null;
    }

    private Writable getWritableValue(TypeInfo ti, long value) {
        if (ti.equals((Object)TypeInfoFactory.byteTypeInfo)) {
            return new ByteWritable((byte)value);
        }
        if (ti.equals((Object)TypeInfoFactory.shortTypeInfo)) {
            return new ShortWritable((short)value);
        }
        if (ti.equals((Object)TypeInfoFactory.intTypeInfo)) {
            return new IntWritable((int)value);
        }
        if (ti.equals((Object)TypeInfoFactory.longTypeInfo)) {
            return new LongWritable(value);
        }
        if (ti.equals((Object)TypeInfoFactory.booleanTypeInfo)) {
            return new BooleanWritable(value != 0L);
        }
        if (ti.equals((Object)TypeInfoFactory.timestampTypeInfo)) {
            Timestamp ts = new Timestamp(value);
            TimestampWritableV2 tw = new TimestampWritableV2(org.apache.hadoop.hive.common.type.Timestamp.ofEpochMilli((long)ts.getTime(), (int)ts.getNanos()));
            return tw;
        }
        return null;
    }

    private void testWriterDouble(TypeInfo type) throws HiveException {
        DoubleColumnVector dcv = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, this.vectorSize, new Random(10L));
        dcv.isNull[2] = true;
        VectorExpressionWriter vew = this.getWriter(type);
        for (int i = 0; i < 5; ++i) {
            Writable w = (Writable)vew.writeValue((ColumnVector)dcv, i);
            if (w != null) {
                Writable expected = this.getWritableValue(type, dcv.vector[i]);
                Assert.assertEquals((Object)expected, (Object)w);
                continue;
            }
            Assert.assertTrue((boolean)dcv.isNull[i]);
        }
    }

    private void testSetterDouble(TypeInfo type) throws HiveException {
        DoubleColumnVector dcv = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, this.vectorSize, new Random(10L));
        dcv.isNull[2] = true;
        Object[] values = new Object[this.vectorSize];
        VectorExpressionWriter vew = this.getWriter(type);
        for (int i = 0; i < 5; ++i) {
            values[i] = null;
            values[i] = vew.setValue(values[i], (ColumnVector)dcv, i);
            if (values[i] != null) {
                Writable expected = this.getWritableValue(type, dcv.vector[i]);
                Assert.assertEquals((Object)expected, (Object)values[i]);
                continue;
            }
            Assert.assertTrue((boolean)dcv.isNull[i]);
        }
    }

    private void testWriterDecimal(DecimalTypeInfo type) throws HiveException {
        DecimalColumnVector dcv = VectorizedRowGroupGenUtil.generateDecimalColumnVector(type, true, false, this.vectorSize, new Random(10L));
        dcv.isNull[2] = true;
        VectorExpressionWriter vew = this.getWriter((TypeInfo)type);
        for (int i = 0; i < 5; ++i) {
            Writable w = (Writable)vew.writeValue((ColumnVector)dcv, i);
            if (w != null) {
                Writable expected = this.getWritableValue((TypeInfo)type, dcv.vector[i].getHiveDecimal());
                Assert.assertEquals((Object)expected, (Object)w);
                continue;
            }
            Assert.assertTrue((boolean)dcv.isNull[i]);
        }
    }

    private void testSetterDecimal(DecimalTypeInfo type) throws HiveException {
        DecimalColumnVector dcv = VectorizedRowGroupGenUtil.generateDecimalColumnVector(type, true, false, this.vectorSize, new Random(10L));
        dcv.isNull[2] = true;
        Object[] values = new Object[this.vectorSize];
        VectorExpressionWriter vew = this.getWriter((TypeInfo)type);
        for (int i = 0; i < 5; ++i) {
            values[i] = null;
            values[i] = vew.setValue(values[i], (ColumnVector)dcv, i);
            if (values[i] != null) {
                Writable expected = this.getWritableValue((TypeInfo)type, dcv.vector[i].getHiveDecimal());
                Assert.assertEquals((Object)expected, (Object)values[i]);
                continue;
            }
            Assert.assertTrue((boolean)dcv.isNull[i]);
        }
    }

    private void testWriterLong(TypeInfo type) throws HiveException {
        LongColumnVector lcv = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 5, new Random(10L));
        lcv.isNull[3] = true;
        VectorExpressionWriter vew = this.getWriter(type);
        for (int i = 0; i < 5; ++i) {
            Writable w = (Writable)vew.writeValue((ColumnVector)lcv, i);
            if (w != null) {
                Writable expected = this.getWritableValue(type, lcv.vector[i]);
                Assert.assertEquals((Object)expected, (Object)w);
                continue;
            }
            Assert.assertTrue((boolean)lcv.isNull[i]);
        }
    }

    private void testSetterLong(TypeInfo type) throws HiveException {
        LongColumnVector lcv = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 5, new Random(10L));
        lcv.isNull[3] = true;
        Object[] values = new Object[this.vectorSize];
        VectorExpressionWriter vew = this.getWriter(type);
        for (int i = 0; i < 5; ++i) {
            values[i] = null;
            values[i] = vew.setValue(values[i], (ColumnVector)lcv, i);
            if (values[i] != null) {
                Writable expected = this.getWritableValue(type, lcv.vector[i]);
                Assert.assertEquals((Object)expected, (Object)values[i]);
                continue;
            }
            Assert.assertTrue((boolean)lcv.isNull[i]);
        }
    }

    private void testWriterTimestamp(TypeInfo type) throws HiveException {
        Timestamp[] timestampValues = new Timestamp[5];
        TimestampColumnVector tcv = VectorizedRowGroupGenUtil.generateTimestampColumnVector(true, false, 5, new Random(10L), timestampValues);
        tcv.isNull[3] = true;
        VectorExpressionWriter vew = this.getWriter(type);
        for (int i = 0; i < 5; ++i) {
            Writable w = (Writable)vew.writeValue((ColumnVector)tcv, i);
            if (w != null) {
                Writable expected = this.getWritableValue(type, timestampValues[i]);
                TimestampWritableV2 t1 = (TimestampWritableV2)expected;
                TimestampWritableV2 t2 = (TimestampWritableV2)w;
                Assert.assertTrue((boolean)t1.equals((Object)t2));
                continue;
            }
            Assert.assertTrue((boolean)tcv.isNull[i]);
        }
    }

    private void testSetterTimestamp(TypeInfo type) throws HiveException {
        Timestamp[] timestampValues = new Timestamp[5];
        TimestampColumnVector tcv = VectorizedRowGroupGenUtil.generateTimestampColumnVector(true, false, 5, new Random(10L), timestampValues);
        tcv.isNull[3] = true;
        Object[] values = new Object[this.vectorSize];
        VectorExpressionWriter vew = this.getWriter(type);
        for (int i = 0; i < 5; ++i) {
            values[i] = null;
            values[i] = vew.setValue(values[i], (ColumnVector)tcv, i);
            if (values[i] != null) {
                Writable expected = this.getWritableValue(type, timestampValues[i]);
                TimestampWritableV2 t1 = (TimestampWritableV2)expected;
                TimestampWritableV2 t2 = (TimestampWritableV2)values[i];
                Assert.assertTrue((boolean)t1.equals((Object)t2));
                continue;
            }
            Assert.assertTrue((boolean)tcv.isNull[i]);
        }
    }

    private StructObjectInspector genStructOI() {
        ArrayList<String> fieldNames1 = new ArrayList<String>();
        fieldNames1.add("theInt");
        fieldNames1.add("theBool");
        ArrayList<Object> fieldObjectInspectors1 = new ArrayList<Object>();
        fieldObjectInspectors1.add(PrimitiveObjectInspectorFactory.writableIntObjectInspector);
        fieldObjectInspectors1.add(PrimitiveObjectInspectorFactory.writableBooleanObjectInspector);
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames1, fieldObjectInspectors1);
    }

    private void testStructLong(TypeInfo type) throws HiveException {
        LongColumnVector icv = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 5, new Random(10L));
        icv.isNull[3] = true;
        LongColumnVector bcv = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 5, new Random(10L));
        bcv.isNull[2] = true;
        ArrayList[] values = new ArrayList[this.vectorSize];
        StructObjectInspector soi = this.genStructOI();
        VectorExpressionWriter[] vew = VectorExpressionWriterFactory.getExpressionWriters((StructObjectInspector)soi);
        for (int i = 0; i < 5; ++i) {
            values[i] = new ArrayList(2);
            values[i].add(null);
            values[i].add(null);
            vew[0].setValue((Object)values[i], (ColumnVector)icv, i);
            vew[1].setValue((Object)values[i], (ColumnVector)bcv, i);
            Object theInt = values[i].get(0);
            if (theInt == null) {
                Assert.assertTrue((boolean)icv.isNull[i]);
            } else {
                IntWritable w = (IntWritable)theInt;
                Assert.assertEquals((int)((int)icv.vector[i]), (int)w.get());
            }
            Object theBool = values[i].get(1);
            if (theBool == null) {
                Assert.assertTrue((boolean)bcv.isNull[i]);
                continue;
            }
            BooleanWritable w = (BooleanWritable)theBool;
            Assert.assertEquals((bcv.vector[i] != 0L ? 1 : 0) != 0, (boolean)w.get());
        }
    }

    private void testWriterText(TypeInfo type) throws HiveException {
        Text t1 = new Text("alpha");
        Text t2 = new Text("beta");
        BytesColumnVector bcv = new BytesColumnVector(5);
        bcv.noNulls = false;
        bcv.initBuffer();
        bcv.setVal(0, t1.getBytes(), 0, t1.getLength());
        bcv.isNull[1] = true;
        bcv.setVal(2, t2.getBytes(), 0, t2.getLength());
        bcv.isNull[3] = true;
        bcv.setVal(4, t1.getBytes(), 0, t1.getLength());
        VectorExpressionWriter vew = this.getWriter(type);
        for (int i = 0; i < 5; ++i) {
            Writable w = (Writable)vew.writeValue((ColumnVector)bcv, i);
            if (w != null) {
                byte[] val = new byte[bcv.length[i]];
                System.arraycopy(bcv.vector[i], bcv.start[i], val, 0, bcv.length[i]);
                Writable expected = this.getWritableValue(type, val);
                Assert.assertEquals((Object)expected, (Object)w);
                continue;
            }
            Assert.assertTrue((boolean)bcv.isNull[i]);
        }
    }

    private void testSetterText(TypeInfo type) throws HiveException {
        Text t1 = new Text("alpha");
        Text t2 = new Text("beta");
        BytesColumnVector bcv = new BytesColumnVector(5);
        bcv.noNulls = false;
        bcv.initBuffer();
        bcv.setVal(0, t1.getBytes(), 0, t1.getLength());
        bcv.isNull[1] = true;
        bcv.setVal(2, t2.getBytes(), 0, t2.getLength());
        bcv.isNull[3] = true;
        bcv.setVal(4, t1.getBytes(), 0, t1.getLength());
        Object[] values = new Object[this.vectorSize];
        VectorExpressionWriter vew = this.getWriter(type);
        for (int i = 0; i < 5; ++i) {
            values[i] = null;
            Writable w = (Writable)vew.setValue(values[i], (ColumnVector)bcv, i);
            if (w != null) {
                byte[] val = new byte[bcv.length[i]];
                System.arraycopy(bcv.vector[i], bcv.start[i], val, 0, bcv.length[i]);
                Writable expected = this.getWritableValue(type, val);
                Assert.assertEquals((Object)expected, (Object)w);
                continue;
            }
            Assert.assertTrue((boolean)bcv.isNull[i]);
        }
    }

    private void testListLong() throws HiveException {
        IntWritable w;
        int i;
        LongColumnVector icv = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 5, new Random(10L));
        ListColumnVector cv = new ListColumnVector(3, (ColumnVector)icv);
        cv.init();
        cv.offsets[0] = 0L;
        cv.lengths[0] = 2L;
        cv.offsets[1] = 2L;
        cv.lengths[1] = 3L;
        for (int i2 = 0; i2 < 5; ++i2) {
            icv.vector[i2] = i2;
            icv.isNull[i2] = false;
        }
        icv.noNulls = true;
        cv.isNull[0] = false;
        cv.isNull[1] = false;
        cv.isNull[2] = true;
        cv.noNulls = false;
        StandardListObjectInspector listOI = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector);
        VectorExpressionWriter vew = VectorExpressionWriterFactory.genVectorExpressionWritable((ObjectInspector)listOI);
        List values1 = (List)listOI.create(2);
        vew.setValue((Object)values1, (ColumnVector)cv, 0);
        List values2 = (List)listOI.create(3);
        vew.setValue((Object)values2, (ColumnVector)cv, 1);
        TestCase.assertEquals((int)values1.size(), (int)2);
        TestCase.assertEquals((int)values2.size(), (int)3);
        for (i = 0; i < values1.size(); ++i) {
            w = (IntWritable)values1.get(i);
            TestCase.assertEquals((int)i, (int)w.get());
        }
        for (i = 0; i < values2.size(); ++i) {
            w = (IntWritable)values2.get(i);
            TestCase.assertEquals((int)(2 + i), (int)w.get());
        }
        List values3 = (List)vew.writeValue((ColumnVector)cv, 0);
        TestCase.assertEquals((int)2, (int)values3.size());
        for (int i3 = 0; i3 < values1.size(); ++i3) {
            IntWritable w2 = (IntWritable)values3.get(i3);
            TestCase.assertEquals((int)i3, (int)w2.get());
        }
        List values4 = (List)vew.writeValue((ColumnVector)cv, 1);
        TestCase.assertEquals((int)3, (int)values4.size());
        for (int i4 = 0; i4 < values2.size(); ++i4) {
            IntWritable w3 = (IntWritable)values4.get(i4);
            TestCase.assertEquals((int)(2 + i4), (int)w3.get());
        }
        List values5 = (List)vew.writeValue((ColumnVector)cv, 2);
        TestCase.assertNull((Object)values5);
    }

    private void testMapLong() throws HiveException {
        IntWritable w;
        IntWritable key;
        int i;
        int i2;
        LongColumnVector kcv = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 5, new Random(10L));
        LongColumnVector vcv = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 5, new Random(10L));
        MapColumnVector cv = new MapColumnVector(3, (ColumnVector)kcv, (ColumnVector)vcv);
        cv.init();
        cv.offsets[0] = 0L;
        cv.lengths[0] = 2L;
        cv.offsets[1] = 2L;
        cv.lengths[1] = 3L;
        for (i2 = 0; i2 < 5; ++i2) {
            kcv.vector[i2] = i2;
            kcv.isNull[i2] = false;
        }
        kcv.noNulls = true;
        for (i2 = 0; i2 < 5; ++i2) {
            vcv.vector[i2] = 5 + i2;
            vcv.isNull[i2] = false;
        }
        vcv.noNulls = true;
        cv.isNull[0] = false;
        cv.isNull[1] = false;
        cv.isNull[2] = true;
        cv.noNulls = false;
        StandardMapObjectInspector mapOI = ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector);
        VectorExpressionWriter vew = VectorExpressionWriterFactory.genVectorExpressionWritable((ObjectInspector)mapOI);
        Map values1 = (Map)mapOI.create();
        vew.setValue((Object)values1, (ColumnVector)cv, 0);
        Map values2 = (Map)mapOI.create();
        vew.setValue((Object)values2, (ColumnVector)cv, 1);
        TestCase.assertEquals((int)2, (int)values1.size());
        TestCase.assertEquals((int)3, (int)values2.size());
        for (i = 0; i < values1.size(); ++i) {
            key = new IntWritable(i);
            w = (IntWritable)values1.get(key);
            TestCase.assertEquals((int)(5 + i), (int)w.get());
        }
        for (i = 0; i < values2.size(); ++i) {
            key = new IntWritable(2 + i);
            w = (IntWritable)values2.get(key);
            TestCase.assertEquals((int)(7 + i), (int)w.get());
        }
        Map values3 = (Map)vew.writeValue((ColumnVector)cv, 0);
        TestCase.assertEquals((int)2, (int)values3.size());
        for (int i3 = 0; i3 < values1.size(); ++i3) {
            IntWritable key2 = new IntWritable(i3);
            IntWritable w2 = (IntWritable)values1.get(key2);
            TestCase.assertEquals((int)(5 + i3), (int)w2.get());
        }
        Map values4 = (Map)vew.writeValue((ColumnVector)cv, 1);
        TestCase.assertEquals((int)3, (int)values4.size());
        for (int i4 = 0; i4 < values2.size(); ++i4) {
            IntWritable key3 = new IntWritable(2 + i4);
            IntWritable w3 = (IntWritable)values2.get(key3);
            TestCase.assertEquals((int)(7 + i4), (int)w3.get());
        }
        Map values5 = (Map)vew.writeValue((ColumnVector)cv, 2);
        TestCase.assertNull((Object)values5);
    }

    @Test
    public void testVectorExpressionWriterDouble() throws HiveException {
        this.testWriterDouble((TypeInfo)TypeInfoFactory.doubleTypeInfo);
    }

    @Test
    public void testVectorExpressionSetterDouble() throws HiveException {
        this.testSetterDouble((TypeInfo)TypeInfoFactory.doubleTypeInfo);
    }

    @Test
    public void testVectorExpressionWriterFloat() throws HiveException {
        this.testWriterDouble((TypeInfo)TypeInfoFactory.floatTypeInfo);
    }

    @Test
    public void testVectorExpressionSetterFloat() throws HiveException {
        this.testSetterDouble((TypeInfo)TypeInfoFactory.floatTypeInfo);
    }

    @Test
    public void testVectorExpressionWriterLong() throws HiveException {
        this.testWriterLong((TypeInfo)TypeInfoFactory.longTypeInfo);
    }

    @Test
    public void testVectorExpressionWriterDecimal() throws HiveException {
        DecimalTypeInfo typeInfo = TypeInfoFactory.getDecimalTypeInfo((int)38, (int)18);
        this.testWriterDecimal(typeInfo);
    }

    @Test
    public void testVectorExpressionSetterDecimal() throws HiveException {
        DecimalTypeInfo typeInfo = TypeInfoFactory.getDecimalTypeInfo((int)38, (int)18);
        this.testSetterDecimal(typeInfo);
    }

    @Test
    public void testVectorExpressionSetterLong() throws HiveException {
        this.testSetterLong((TypeInfo)TypeInfoFactory.longTypeInfo);
    }

    @Test
    public void testVectorExpressionStructLong() throws HiveException {
        this.testStructLong((TypeInfo)TypeInfoFactory.longTypeInfo);
    }

    @Test
    public void testVectorExpressionWriterInt() throws HiveException {
        this.testWriterLong((TypeInfo)TypeInfoFactory.intTypeInfo);
    }

    @Test
    public void testVectorExpressionSetterInt() throws HiveException {
        this.testSetterLong((TypeInfo)TypeInfoFactory.intTypeInfo);
    }

    @Test
    public void testVectorExpressionWriterShort() throws HiveException {
        this.testWriterLong((TypeInfo)TypeInfoFactory.shortTypeInfo);
    }

    @Test
    public void testVectorExpressionSetterShort() throws HiveException {
        this.testSetterLong((TypeInfo)TypeInfoFactory.shortTypeInfo);
    }

    @Test
    public void testVectorExpressionWriterBoolean() throws HiveException {
        this.testWriterLong((TypeInfo)TypeInfoFactory.booleanTypeInfo);
    }

    @Test
    public void testVectorExpressionSetterBoolean() throws HiveException {
        this.testSetterLong((TypeInfo)TypeInfoFactory.booleanTypeInfo);
    }

    @Test
    public void testVectorExpressionWriterTimestamp() throws HiveException {
        this.testWriterTimestamp((TypeInfo)TypeInfoFactory.timestampTypeInfo);
    }

    @Test
    public void testVectorExpressionSetterTimestamp() throws HiveException {
        this.testSetterTimestamp((TypeInfo)TypeInfoFactory.timestampTypeInfo);
    }

    @Test
    public void testVectorExpressionWriterByte() throws HiveException {
        this.testWriterLong((TypeInfo)TypeInfoFactory.byteTypeInfo);
    }

    @Test
    public void testVectorExpressionSetterByte() throws HiveException {
        this.testSetterLong((TypeInfo)TypeInfoFactory.byteTypeInfo);
    }

    @Test
    public void testVectorExpressionWriterString() throws HiveException {
        this.testWriterText((TypeInfo)TypeInfoFactory.stringTypeInfo);
    }

    @Test
    public void testVectorExpressionSetterString() throws HiveException {
        this.testSetterText((TypeInfo)TypeInfoFactory.stringTypeInfo);
    }

    @Test
    public void testVectorExpressionWriterVarchar() throws HiveException {
        this.testWriterText((TypeInfo)TypeInfoFactory.varcharTypeInfo);
    }

    @Test
    public void testVectorExpressionSetterVarchar() throws HiveException {
        this.testSetterText((TypeInfo)TypeInfoFactory.varcharTypeInfo);
    }

    @Test
    public void testVectorExpressionWriterBinary() throws HiveException {
        this.testWriterText((TypeInfo)TypeInfoFactory.binaryTypeInfo);
    }

    @Test
    public void testVectorExpressionSetterBinary() throws HiveException {
        this.testSetterText((TypeInfo)TypeInfoFactory.binaryTypeInfo);
    }

    @Test
    public void testVectorExpressionListLong() throws HiveException {
        this.testListLong();
    }

    @Test
    public void testVectorExpressionMapLong() throws HiveException {
        this.testMapLong();
    }
}

