/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDecimalToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastStringToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastTimestampToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.CastDoubleToLong;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.lazy.LazyLong;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;

@VectorizedExpressions(value={CastTimestampToLong.class, CastDoubleToLong.class, CastDecimalToLong.class, CastStringToLong.class})
public class UDFToLong
extends UDF {
    private final LongWritable longWritable = new LongWritable();

    public LongWritable evaluate(NullWritable i) {
        return null;
    }

    public LongWritable evaluate(BooleanWritable i) {
        if (i == null) {
            return null;
        }
        this.longWritable.set(i.get() ? 1L : 0L);
        return this.longWritable;
    }

    public LongWritable evaluate(ByteWritable i) {
        if (i == null) {
            return null;
        }
        this.longWritable.set((long)i.get());
        return this.longWritable;
    }

    public LongWritable evaluate(ShortWritable i) {
        if (i == null) {
            return null;
        }
        this.longWritable.set((long)i.get());
        return this.longWritable;
    }

    public LongWritable evaluate(IntWritable i) {
        if (i == null) {
            return null;
        }
        this.longWritable.set((long)i.get());
        return this.longWritable;
    }

    public LongWritable evaluate(LongWritable i) {
        return i;
    }

    public LongWritable evaluate(FloatWritable i) {
        if (i == null) {
            return null;
        }
        this.longWritable.set((long)i.get());
        return this.longWritable;
    }

    public LongWritable evaluate(DoubleWritable i) {
        if (i == null) {
            return null;
        }
        this.longWritable.set((long)i.get());
        return this.longWritable;
    }

    public LongWritable evaluate(Text i) {
        if (i == null) {
            return null;
        }
        if (!LazyUtils.isNumberMaybe(i.getBytes(), 0, i.getLength())) {
            return null;
        }
        try {
            this.longWritable.set(LazyLong.parseLong(i.getBytes(), 0, i.getLength(), 10, true));
            return this.longWritable;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public LongWritable evaluate(TimestampWritableV2 i) {
        if (i == null) {
            return null;
        }
        this.longWritable.set(i.getSeconds());
        return this.longWritable;
    }

    public LongWritable evaluate(HiveDecimalWritable i) {
        if (i == null || !i.isSet() || !i.isLong()) {
            return null;
        }
        this.longWritable.set(i.longValue());
        return this.longWritable;
    }
}

