/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin;

import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Apache Argus (incubating)"})
@InterfaceStability.Evolving
public class HivePrincipal
implements Comparable<HivePrincipal> {
    private final String name;
    private final HivePrincipalType type;

    @Override
    public int compareTo(HivePrincipal o) {
        int compare = this.name.compareTo(o.name);
        if (compare == 0) {
            compare = this.type.compareTo(o.type);
        }
        return compare;
    }

    public String toString() {
        return "Principal [name=" + this.name + ", type=" + this.type + "]";
    }

    public HivePrincipal(String name, HivePrincipalType type) {
        this.type = type;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public HivePrincipalType getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HivePrincipal other = (HivePrincipal)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.type == other.type;
    }

    public static enum HivePrincipalType {
        USER,
        GROUP,
        ROLE,
        UNKNOWN;

    }
}

