/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.wm;

import org.apache.hadoop.hive.ql.wm.Expression;
import org.apache.hadoop.hive.ql.wm.ExpressionFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestExpressionFactory {
    @Test
    public void testSize() {
        Expression expr = null;
        expr = ExpressionFactory.fromString((String)"BYTES_READ > 5");
        Assert.assertNotNull((Object)expr);
        Assert.assertEquals((Object)Expression.Predicate.GREATER_THAN, (Object)expr.getPredicate());
        Assert.assertEquals((Object)"BYTES_READ", (Object)expr.getCounterLimit().getName());
        Assert.assertEquals((long)5L, (long)expr.getCounterLimit().getLimit());
        expr = ExpressionFactory.fromString((String)"BYTES_READ > '5kb'");
        Assert.assertNotNull((Object)expr);
        Assert.assertEquals((Object)Expression.Predicate.GREATER_THAN, (Object)expr.getPredicate());
        Assert.assertEquals((Object)"BYTES_READ", (Object)expr.getCounterLimit().getName());
        Assert.assertEquals((long)5120L, (long)expr.getCounterLimit().getLimit());
        expr = ExpressionFactory.fromString((String)"BYTES_READ > '2mb'");
        Assert.assertNotNull((Object)expr);
        Assert.assertEquals((Object)Expression.Predicate.GREATER_THAN, (Object)expr.getPredicate());
        Assert.assertEquals((Object)"BYTES_READ", (Object)expr.getCounterLimit().getName());
        Assert.assertEquals((long)0x200000L, (long)expr.getCounterLimit().getLimit());
        expr = ExpressionFactory.fromString((String)"BYTES_READ > '3gb'");
        Assert.assertNotNull((Object)expr);
        Assert.assertEquals((Object)Expression.Predicate.GREATER_THAN, (Object)expr.getPredicate());
        Assert.assertEquals((Object)"BYTES_READ", (Object)expr.getCounterLimit().getName());
        Assert.assertEquals((long)0xC0000000L, (long)expr.getCounterLimit().getLimit());
        expr = ExpressionFactory.fromString((String)"SHUFFLE_BYTES > '7tb'");
        Assert.assertNotNull((Object)expr);
        Assert.assertEquals((Object)Expression.Predicate.GREATER_THAN, (Object)expr.getPredicate());
        Assert.assertEquals((Object)"SHUFFLE_BYTES", (Object)expr.getCounterLimit().getName());
        Assert.assertEquals((long)0x70000000000L, (long)expr.getCounterLimit().getLimit());
        expr = ExpressionFactory.fromString((String)"SHUFFLE_BYTES > '6pb'");
        Assert.assertNotNull((Object)expr);
        Assert.assertEquals((Object)Expression.Predicate.GREATER_THAN, (Object)expr.getPredicate());
        Assert.assertEquals((Object)"SHUFFLE_BYTES", (Object)expr.getCounterLimit().getName());
        Assert.assertEquals((long)0x18000000000000L, (long)expr.getCounterLimit().getLimit());
        expr = ExpressionFactory.fromString((String)"BYTES_WRITTEN > 27");
        Assert.assertNotNull((Object)expr);
        Assert.assertEquals((Object)Expression.Predicate.GREATER_THAN, (Object)expr.getPredicate());
        Assert.assertEquals((Object)"BYTES_WRITTEN", (Object)expr.getCounterLimit().getName());
        Assert.assertEquals((long)27L, (long)expr.getCounterLimit().getLimit());
    }

    @Test
    public void testTime() {
        Expression expr = null;
        expr = ExpressionFactory.fromString((String)"ELAPSED_TIME > 1");
        Assert.assertNotNull((Object)expr);
        Assert.assertEquals((Object)Expression.Predicate.GREATER_THAN, (Object)expr.getPredicate());
        Assert.assertEquals((Object)"ELAPSED_TIME", (Object)expr.getCounterLimit().getName());
        Assert.assertEquals((long)1L, (long)expr.getCounterLimit().getLimit());
        expr = ExpressionFactory.fromString((String)"ELAPSED_TIME > '1ms'");
        Assert.assertNotNull((Object)expr);
        Assert.assertEquals((Object)Expression.Predicate.GREATER_THAN, (Object)expr.getPredicate());
        Assert.assertEquals((Object)"ELAPSED_TIME", (Object)expr.getCounterLimit().getName());
        Assert.assertEquals((long)1L, (long)expr.getCounterLimit().getLimit());
        expr = ExpressionFactory.fromString((String)"ELAPSED_TIME > '1sec'");
        Assert.assertNotNull((Object)expr);
        Assert.assertEquals((Object)Expression.Predicate.GREATER_THAN, (Object)expr.getPredicate());
        Assert.assertEquals((Object)"ELAPSED_TIME", (Object)expr.getCounterLimit().getName());
        Assert.assertEquals((long)1000L, (long)expr.getCounterLimit().getLimit());
        expr = ExpressionFactory.fromString((String)"ELAPSED_TIME > '1min'");
        Assert.assertNotNull((Object)expr);
        Assert.assertEquals((Object)Expression.Predicate.GREATER_THAN, (Object)expr.getPredicate());
        Assert.assertEquals((Object)"ELAPSED_TIME", (Object)expr.getCounterLimit().getName());
        Assert.assertEquals((long)60000L, (long)expr.getCounterLimit().getLimit());
        expr = ExpressionFactory.fromString((String)"ELAPSED_TIME > '1hour'");
        Assert.assertNotNull((Object)expr);
        Assert.assertEquals((Object)Expression.Predicate.GREATER_THAN, (Object)expr.getPredicate());
        Assert.assertEquals((Object)"ELAPSED_TIME", (Object)expr.getCounterLimit().getName());
        Assert.assertEquals((long)3600000L, (long)expr.getCounterLimit().getLimit());
        expr = ExpressionFactory.fromString((String)"ELAPSED_TIME > '1day'");
        Assert.assertNotNull((Object)expr);
        Assert.assertEquals((Object)Expression.Predicate.GREATER_THAN, (Object)expr.getPredicate());
        Assert.assertEquals((Object)"ELAPSED_TIME", (Object)expr.getCounterLimit().getName());
        Assert.assertEquals((long)86400000L, (long)expr.getCounterLimit().getLimit());
    }
}

