/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import com.google.common.base.Preconditions;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import junit.framework.TestCase;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.CheckFastHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastLongHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastMultiKeyHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastStringHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VerifyFastRow;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMapResult;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.hive.serde2.WriteBuffers;
import org.apache.hadoop.hive.serde2.fast.DeserializeRead;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.lazy.VerifyLazy;
import org.apache.hadoop.hive.serde2.lazybinary.fast.LazyBinaryDeserializeRead;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObject;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;

public class CheckFastRowHashMap
extends CheckFastHashTable {
    static final int STACK_LENGTH_LIMIT = 20;

    public static void verifyHashMapRows(List<Object[]> rows, int[] actualToValueMap, VectorMapJoinHashMapResult hashMapResult, TypeInfo[] typeInfos) throws IOException {
        int count = rows.size();
        int columnCount = typeInfos.length;
        WriteBuffers.ByteSegmentRef ref = hashMapResult.first();
        for (int a = 0; a < count; ++a) {
            int valueIndex = actualToValueMap[a];
            Object[] row = rows.get(valueIndex);
            byte[] bytes = ref.getBytes();
            int offset = (int)ref.getOffset();
            int length = ref.getLength();
            LazyBinaryDeserializeRead lazyBinaryDeserializeRead = new LazyBinaryDeserializeRead(typeInfos, false);
            lazyBinaryDeserializeRead.set(bytes, offset, length);
            for (int index = 0; index < columnCount; ++index) {
                CheckFastRowHashMap.verifyRead(lazyBinaryDeserializeRead, typeInfos[index], row[index]);
            }
            TestCase.assertTrue((boolean)lazyBinaryDeserializeRead.isEndOfInputReached());
            ref = hashMapResult.next();
            if (a == count - 1) {
                TestCase.assertTrue((ref == null ? 1 : 0) != 0);
                continue;
            }
            TestCase.assertTrue((ref != null ? 1 : 0) != 0);
        }
    }

    public static void verifyHashMapRowsMore(List<Object[]> rows, int[] actualToValueMap, VectorMapJoinHashMapResult hashMapResult, TypeInfo[] typeInfos, int clipIndex, boolean useExactBytes) throws IOException {
        String debugExceptionMessage = null;
        StackTraceElement[] debugStackTrace = null;
        int count = rows.size();
        int columnCount = typeInfos.length;
        WriteBuffers.ByteSegmentRef ref = hashMapResult.first();
        for (int a = 0; a < count; ++a) {
            int valueIndex = actualToValueMap[a];
            Object[] row = rows.get(valueIndex);
            byte[] bytes = ref.getBytes();
            int offset = (int)ref.getOffset();
            int length = ref.getLength();
            if (a == clipIndex) {
                --length;
            }
            if (useExactBytes) {
                bytes = Arrays.copyOfRange(bytes, offset, offset + length);
                offset = 0;
            }
            LazyBinaryDeserializeRead lazyBinaryDeserializeRead = new LazyBinaryDeserializeRead(typeInfos, false);
            lazyBinaryDeserializeRead.set(bytes, offset, length);
            boolean thrown = false;
            Exception saveException = null;
            int index = 0;
            try {
                for (index = 0; index < columnCount; ++index) {
                    CheckFastRowHashMap.verifyRead(lazyBinaryDeserializeRead, typeInfos[index], row[index]);
                }
            }
            catch (Exception e) {
                thrown = true;
                saveException = e;
                lazyBinaryDeserializeRead.getDetailedReadPositionString();
                hashMapResult.getDetailedHashMapResultPositionString();
                debugExceptionMessage = saveException.getMessage();
                debugStackTrace = saveException.getStackTrace();
            }
            if (a == clipIndex) {
                if (!thrown) {
                    TestCase.fail((String)"Expecting an exception to be thrown for the clipped case...");
                } else {
                    TestCase.assertTrue((saveException != null ? 1 : 0) != 0);
                    if (!(saveException instanceof EOFException) && !(saveException instanceof ArrayIndexOutOfBoundsException)) {
                        TestCase.fail((String)"Expecting an EOFException to be thrown for the clipped case...");
                    }
                }
            } else {
                if (thrown) {
                    TestCase.fail((String)("Not expecting an exception to be thrown for the non-clipped case...  exception message " + debugExceptionMessage + " stack trace " + CheckFastRowHashMap.getStackTraceAsSingleLine(debugStackTrace)));
                }
                TestCase.assertTrue((boolean)lazyBinaryDeserializeRead.isEndOfInputReached());
            }
            ref = hashMapResult.next();
            if (a == count - 1) {
                TestCase.assertTrue((ref == null ? 1 : 0) != 0);
                continue;
            }
            TestCase.assertTrue((ref != null ? 1 : 0) != 0);
        }
    }

    private static void verifyRead(LazyBinaryDeserializeRead lazyBinaryDeserializeRead, TypeInfo typeInfo, Object expectedObject) throws IOException {
        if (typeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE) {
            VerifyFastRow.verifyDeserializeRead((DeserializeRead)lazyBinaryDeserializeRead, typeInfo, expectedObject);
        } else {
            Object complexFieldObj = VerifyFastRow.deserializeReadComplexType((DeserializeRead)lazyBinaryDeserializeRead, typeInfo);
            if (expectedObject == null) {
                if (complexFieldObj != null) {
                    TestCase.fail((String)("Field reports not null but object is null (class " + complexFieldObj.getClass().getName() + ", " + complexFieldObj.toString() + ")"));
                }
            } else if (complexFieldObj == null) {
                UnionObject expectedUnion;
                if (expectedObject instanceof UnionObject && (expectedUnion = (UnionObject)expectedObject).getObject() == null) {
                    return;
                }
                TestCase.fail((String)("Field reports null but object is not null (class " + expectedObject.getClass().getName() + ", " + expectedObject.toString() + ")"));
            }
            if (!VerifyLazy.lazyCompare((TypeInfo)typeInfo, (Object)complexFieldObj, (Object)expectedObject)) {
                TestCase.fail((String)("Comparision failed typeInfo " + typeInfo.toString()));
            }
        }
    }

    public static String getStackTraceAsSingleLine(StackTraceElement[] stackTrace) {
        StringBuilder sb = new StringBuilder();
        sb.append("Stack trace: ");
        int length = stackTrace.length;
        boolean isTruncated = false;
        if (length > 20) {
            length = 20;
            isTruncated = true;
        }
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(stackTrace[i]);
        }
        if (isTruncated) {
            sb.append(", ...");
        }
        return sb.toString();
    }

    public static class VerifyFastRowHashMap {
        private int count = 0;
        private FastRowHashMapElement[] array = new FastRowHashMapElement[50];
        private TreeMap<BytesWritable, Integer> keyValueMap = new TreeMap();

        public int getCount() {
            return this.count;
        }

        public boolean contains(byte[] key) {
            BytesWritable keyBytesWritable = new BytesWritable(key, key.length);
            return this.keyValueMap.containsKey(keyBytesWritable);
        }

        public void add(byte[] key, Object[] keyRow, byte[] value, Object[] valueRow) {
            BytesWritable keyBytesWritable = new BytesWritable(key, key.length);
            if (this.keyValueMap.containsKey(keyBytesWritable)) {
                int index = this.keyValueMap.get(keyBytesWritable);
                this.array[index].add(value, valueRow);
            } else {
                if (this.count >= this.array.length) {
                    FastRowHashMapElement[] newArray = new FastRowHashMapElement[this.array.length * 2];
                    System.arraycopy(this.array, 0, newArray, 0, this.count);
                    this.array = newArray;
                }
                this.array[this.count] = new FastRowHashMapElement(key, keyRow, value, valueRow);
                this.keyValueMap.put(keyBytesWritable, this.count);
                ++this.count;
            }
        }

        public byte[] addRandomExisting(byte[] value, Object[] valueRow, Random r) {
            Preconditions.checkState((this.count > 0 ? 1 : 0) != 0);
            int index = r.nextInt(this.count);
            this.array[index].add(value, valueRow);
            return this.array[index].getKey();
        }

        public byte[] getKey(int index) {
            return this.array[index].getKey();
        }

        public List<byte[]> getValues(int index) {
            return this.array[index].getValues();
        }

        public void verify(VectorMapJoinFastHashTable map, VectorMapJoinDesc.HashTableKeyType hashTableKeyType, TypeInfo[] valueTypeInfos, boolean doClipping, boolean useExactBytes, Random random) throws IOException {
            int mapSize = map.size();
            if (mapSize != this.count) {
                TestCase.fail((String)"map.size() does not match expected count");
            }
            for (int index = 0; index < this.count; ++index) {
                FastRowHashMapElement element = this.array[index];
                List<byte[]> values = element.getValues();
                VectorMapJoinHashMapResult hashMapResult = null;
                JoinUtil.JoinResult joinResult = JoinUtil.JoinResult.NOMATCH;
                switch (hashTableKeyType) {
                    case BOOLEAN: 
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case LONG: {
                        long longKey;
                        Object[] keyRow = element.getKeyRow();
                        Object keyObject = keyRow[0];
                        VectorMapJoinFastLongHashMap longHashMap = (VectorMapJoinFastLongHashMap)map;
                        hashMapResult = longHashMap.createHashMapResult();
                        switch (hashTableKeyType) {
                            case BOOLEAN: {
                                longKey = ((BooleanWritable)keyObject).get() ? 1L : 0L;
                                break;
                            }
                            case BYTE: {
                                longKey = ((ByteWritable)keyObject).get();
                                break;
                            }
                            case SHORT: {
                                longKey = ((ShortWritable)keyObject).get();
                                break;
                            }
                            case INT: {
                                longKey = ((IntWritable)keyObject).get();
                                break;
                            }
                            case LONG: {
                                longKey = ((LongWritable)keyObject).get();
                                break;
                            }
                            default: {
                                throw new RuntimeException("Unexpected hash table key type " + hashTableKeyType.name());
                            }
                        }
                        joinResult = longHashMap.lookup(longKey, hashMapResult);
                        if (joinResult == JoinUtil.JoinResult.MATCH) break;
                        Assert.assertTrue((boolean)false);
                        break;
                    }
                    case STRING: {
                        Object[] keyRow = element.getKeyRow();
                        Object keyObject = keyRow[0];
                        VectorMapJoinFastStringHashMap stringHashMap = (VectorMapJoinFastStringHashMap)map;
                        hashMapResult = stringHashMap.createHashMapResult();
                        Text text = (Text)keyObject;
                        byte[] bytes = text.getBytes();
                        int length = text.getLength();
                        joinResult = stringHashMap.lookup(bytes, 0, length, hashMapResult);
                        if (joinResult == JoinUtil.JoinResult.MATCH) break;
                        Assert.assertTrue((boolean)false);
                        break;
                    }
                    case MULTI_KEY: {
                        byte[] keyBytes = element.getKey();
                        VectorMapJoinFastMultiKeyHashMap stringHashMap = (VectorMapJoinFastMultiKeyHashMap)map;
                        hashMapResult = stringHashMap.createHashMapResult();
                        joinResult = stringHashMap.lookup(keyBytes, 0, keyBytes.length, hashMapResult);
                        if (joinResult == JoinUtil.JoinResult.MATCH) break;
                        Assert.assertTrue((boolean)false);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unexpected hash table key type " + hashTableKeyType.name());
                    }
                }
                int[] actualToValueMap = CheckFastHashTable.verifyHashMapValues(hashMapResult, values);
                List<Object[]> rows = element.getValueRows();
                if (!doClipping && !useExactBytes) {
                    CheckFastRowHashMap.verifyHashMapRows(rows, actualToValueMap, hashMapResult, valueTypeInfos);
                    continue;
                }
                int clipIndex = random.nextInt(rows.size());
                CheckFastRowHashMap.verifyHashMapRowsMore(rows, actualToValueMap, hashMapResult, valueTypeInfos, clipIndex, useExactBytes);
            }
        }
    }

    public static class FastRowHashMapElement {
        private byte[] key;
        private Object[] keyRow;
        private List<byte[]> values;
        private List<Object[]> valueRows;

        public FastRowHashMapElement(byte[] key, Object[] keyRow, byte[] firstValue, Object[] valueRow) {
            this.key = key;
            this.keyRow = keyRow;
            this.values = new ArrayList<byte[]>();
            this.values.add(firstValue);
            this.valueRows = new ArrayList<Object[]>();
            this.valueRows.add(valueRow);
        }

        public byte[] getKey() {
            return this.key;
        }

        public Object[] getKeyRow() {
            return this.keyRow;
        }

        public int getCount() {
            return this.values.size();
        }

        public List<byte[]> getValues() {
            return this.values;
        }

        public List<Object[]> getValueRows() {
            return this.valueRows;
        }

        public void add(byte[] value, Object[] valueRow) {
            this.values.add(value);
            this.valueRows.add(valueRow);
        }
    }
}

