/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.util.rowobjects.RowTestObjects;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomRowSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.MapJoinTestDescription;
import org.apache.hadoop.hive.ql.exec.vector.util.batchgen.VectorBatchGenerateStream;
import org.apache.hadoop.hive.ql.exec.vector.util.batchgen.VectorBatchGenerator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class MapJoinTestData {
    final long bigTableRandomSeed;
    final long smallTableRandomSeed;
    final VectorBatchGenerator.GenerateType[] generateTypes;
    final VectorBatchGenerator generator;
    public final VectorizedRowBatch bigTableBatch;
    public final VectorBatchGenerateStream bigTableBatchStream;
    final MapJoinTestDescription.SmallTableGenerationParameters smallTableGenerationParameters;
    HashMap<RowTestObjects, Integer> smallTableKeyHashMap;
    ArrayList<Integer> smallTableValueCounts;
    ArrayList<ArrayList<RowTestObjects>> smallTableValues;

    public MapJoinTestData(int rowCount, MapJoinTestDescription testDesc, long bigTableRandomSeed, long smallTableRandomSeed) throws HiveException {
        this.bigTableRandomSeed = bigTableRandomSeed;
        this.smallTableRandomSeed = smallTableRandomSeed;
        this.generateTypes = MapJoinTestData.generateTypesFromTypeInfos(testDesc.bigTableTypeInfos);
        this.generator = new VectorBatchGenerator(this.generateTypes);
        this.bigTableBatch = this.generator.createBatch();
        ColumnVector[] newCols = new ColumnVector[this.bigTableBatch.cols.length + testDesc.smallTableValueTypeInfos.length];
        System.arraycopy(this.bigTableBatch.cols, 0, newCols, 0, this.bigTableBatch.cols.length);
        for (int s = 0; s < testDesc.smallTableValueTypeInfos.length; ++s) {
            newCols[this.bigTableBatch.cols.length + s] = VectorizedBatchUtil.createColumnVector((TypeInfo)testDesc.smallTableValueTypeInfos[s]);
        }
        this.bigTableBatch.cols = newCols;
        this.bigTableBatch.numCols = newCols.length;
        this.bigTableBatchStream = new VectorBatchGenerateStream(bigTableRandomSeed, this.generator, rowCount);
        VectorExtractRow vectorExtractRow = new VectorExtractRow();
        vectorExtractRow.init(testDesc.bigTableKeyTypeInfos);
        this.smallTableGenerationParameters = testDesc.getSmallTableGenerationParameters();
        this.smallTableKeyHashMap = new HashMap();
        Random smallTableRandom = new Random(smallTableRandomSeed);
        MapJoinTestDescription.SmallTableGenerationParameters.ValueOption valueOption = this.smallTableGenerationParameters.getValueOption();
        int keyOutOfAThousand = this.smallTableGenerationParameters.getKeyOutOfAThousand();
        this.bigTableBatchStream.reset();
        while (this.bigTableBatchStream.isNext()) {
            this.bigTableBatch.reset();
            this.bigTableBatchStream.fillNext(this.bigTableBatch);
            int size = this.bigTableBatch.size;
            for (int i = 0; i < size; ++i) {
                if (smallTableRandom.nextInt(1000) > keyOutOfAThousand) continue;
                RowTestObjects testKey = this.getTestKey(this.bigTableBatch, i, vectorExtractRow, testDesc.bigTableKeyTypeInfos.length, testDesc.bigTableObjectInspectors);
                if (valueOption == MapJoinTestDescription.SmallTableGenerationParameters.ValueOption.ONLY_ONE && this.smallTableKeyHashMap.containsKey(testKey)) continue;
                this.smallTableKeyHashMap.put((RowTestObjects)testKey.clone(), -1);
            }
        }
        int addCount = 0;
        for (Map.Entry<RowTestObjects, Integer> testRowEntry : this.smallTableKeyHashMap.entrySet()) {
            testRowEntry.setValue(addCount++);
        }
        MapJoinTestData.generateVariationData(this, testDesc, smallTableRandom);
    }

    public VectorBatchGenerateStream getBigTableBatchStream() {
        return this.bigTableBatchStream;
    }

    public VectorizedRowBatch getBigTableBatch() {
        return this.bigTableBatch;
    }

    private RowTestObjects getTestKey(VectorizedRowBatch bigTableBatch, int batchIndex, VectorExtractRow vectorExtractRow, int columnCount, ObjectInspector[] objectInspectors) {
        Object[] rowObjects = new Object[columnCount];
        vectorExtractRow.extractRow(bigTableBatch, batchIndex, rowObjects);
        for (int c = 0; c < rowObjects.length; ++c) {
            rowObjects[c] = ((PrimitiveObjectInspector)objectInspectors[c]).copyObject(rowObjects[c]);
        }
        return new RowTestObjects(rowObjects);
    }

    public static void driveBigTableData(MapJoinTestDescription testDesc, MapJoinTestData testData, MapJoinOperator operator) throws HiveException {
        VectorExtractRow vectorExtractRow = new VectorExtractRow();
        vectorExtractRow.init(testDesc.bigTableKeyTypeInfos);
        int columnCount = testDesc.bigTableKeyTypeInfos.length;
        Object[] row = new Object[columnCount];
        testData.bigTableBatchStream.reset();
        while (testData.bigTableBatchStream.isNext()) {
            testData.bigTableBatch.reset();
            testData.bigTableBatchStream.fillNext(testData.bigTableBatch);
            int size = testData.bigTableBatch.size;
            for (int r = 0; r < size; ++r) {
                vectorExtractRow.extractRow(testData.bigTableBatch, r, row);
                operator.process((Object)row, 0);
            }
        }
        operator.closeOp(false);
    }

    public static void driveVectorBigTableData(MapJoinTestDescription testDesc, MapJoinTestData testData, MapJoinOperator operator) throws HiveException {
        testData.bigTableBatchStream.reset();
        while (testData.bigTableBatchStream.isNext()) {
            testData.bigTableBatch.reset();
            testData.bigTableBatchStream.fillNext(testData.bigTableBatch);
            operator.process((Object)testData.bigTableBatch, 0);
        }
        operator.closeOp(false);
    }

    public static void generateVariationData(MapJoinTestData testData, MapJoinTestDescription testDesc, Random random) {
        switch (testDesc.vectorMapJoinVariation) {
            case INNER_BIG_ONLY: 
            case LEFT_SEMI: {
                testData.generateRandomSmallTableCounts(testDesc, random);
                break;
            }
            case INNER: 
            case OUTER: {
                testData.generateRandomSmallTableCounts(testDesc, random);
                testData.generateRandomSmallTableValues(testDesc, random);
                break;
            }
            default: {
                throw new RuntimeException("Unknown operator variation " + testDesc.vectorMapJoinVariation);
            }
        }
    }

    private static RowTestObjects generateRandomSmallTableValueRow(MapJoinTestDescription testDesc, Random random) {
        int columnCount = testDesc.smallTableValueTypeInfos.length;
        Object[] smallTableValueRow = VectorRandomRowSource.randomWritablePrimitiveRow(columnCount, random, testDesc.smallTableValuePrimitiveTypeInfos);
        for (int c = 0; c < smallTableValueRow.length; ++c) {
            smallTableValueRow[c] = ((PrimitiveObjectInspector)testDesc.smallTableObjectInspectors[c]).copyObject(smallTableValueRow[c]);
        }
        return new RowTestObjects(smallTableValueRow);
    }

    private void generateRandomSmallTableCounts(MapJoinTestDescription testDesc, Random random) {
        this.smallTableValueCounts = new ArrayList();
        for (Map.Entry<RowTestObjects, Integer> testKeyEntry : this.smallTableKeyHashMap.entrySet()) {
            int valueCount = 1 + random.nextInt(19);
            this.smallTableValueCounts.add(valueCount);
        }
    }

    private void generateRandomSmallTableValues(MapJoinTestDescription testDesc, Random random) {
        this.smallTableValues = new ArrayList();
        for (Map.Entry<RowTestObjects, Integer> testKeyEntry : this.smallTableKeyHashMap.entrySet()) {
            ArrayList<RowTestObjects> valueList = new ArrayList<RowTestObjects>();
            this.smallTableValues.add(valueList);
            int valueCount = this.smallTableValueCounts.get(testKeyEntry.getValue());
            for (int v = 0; v < valueCount; ++v) {
                valueList.add(MapJoinTestData.generateRandomSmallTableValueRow(testDesc, random));
            }
        }
    }

    private static VectorBatchGenerator.GenerateType[] generateTypesFromTypeInfos(TypeInfo[] typeInfos) {
        int size = typeInfos.length;
        VectorBatchGenerator.GenerateType[] generateTypes = new VectorBatchGenerator.GenerateType[size];
        for (int i = 0; i < size; ++i) {
            PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)typeInfos[i];
            VectorBatchGenerator.GenerateType.GenerateCategory category = VectorBatchGenerator.GenerateType.GenerateCategory.generateCategoryFromPrimitiveCategory(primitiveTypeInfo.getPrimitiveCategory());
            generateTypes[i] = new VectorBatchGenerator.GenerateType(category);
        }
        return generateTypes;
    }
}

