/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;

@Description(name="hbasedecimal", value="_FUNC_(bin) - Convert the BigDecimal encoded by HBase from binary to a string")
public class UDFStringFromHBaseBytes
extends UDF {
    private final transient Text result = new Text();

    public Text evaluate(BytesWritable b) {
        if (b == null) {
            return null;
        }
        byte[] bytes = new byte[b.getLength()];
        System.arraycopy(b.getBytes(), 0, bytes, 0, b.getLength());
        this.result.set(Bytes.toBigDecimal((byte[])bytes).toString());
        return this.result;
    }
}

