/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.bootstrap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.repl.ReplStateLogWork;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.AddDependencyToLeaves;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.ReplLoadWork;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.BootstrapEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.ConstraintEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.DatabaseEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.FunctionEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.PartitionEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.TableEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem.BootstrapEventsIterator;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem.ConstraintEventsIterator;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.LoadConstraint;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.LoadDatabase;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.LoadFunction;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.TaskTracker;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.table.LoadPartitions;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.table.LoadTable;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.table.TableContext;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.util.Context;
import org.apache.hadoop.hive.ql.exec.util.DAGTraversal;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.ReplLogger;
import org.apache.hadoop.hive.ql.plan.api.StageType;

public class ReplLoadTask
extends Task<ReplLoadWork>
implements Serializable {
    private static final int ZERO_TASKS = 0;

    @Override
    public String getName() {
        return "REPL_BOOTSTRAP_LOAD";
    }

    @Override
    protected int execute(DriverContext driverContext) {
        try {
            int maxTasks = this.conf.getIntVar(HiveConf.ConfVars.REPL_APPROX_MAX_LOAD_TASKS);
            Context context = new Context(((ReplLoadWork)this.work).dumpDirectory, this.conf, this.getHive(), ((ReplLoadWork)this.work).sessionStateLineageState, driverContext.getCtx());
            TaskTracker loadTaskTracker = new TaskTracker(maxTasks);
            BootstrapEventsIterator iterator = ((ReplLoadWork)this.work).iterator();
            ConstraintEventsIterator constraintIterator = ((ReplLoadWork)this.work).constraintIterator();
            TaskTracker dbTracker = new TaskTracker(0);
            TaskTracker tableTracker = new TaskTracker(0);
            Scope scope = new Scope();
            boolean loadingConstraint = false;
            if (!iterator.hasNext() && constraintIterator.hasNext()) {
                loadingConstraint = true;
            }
            while ((iterator.hasNext() || loadingConstraint && constraintIterator.hasNext()) && loadTaskTracker.canAddMoreTasks()) {
                BootstrapEvent next = !loadingConstraint ? iterator.next() : constraintIterator.next();
                switch (next.eventType()) {
                    case Database: {
                        DatabaseEvent dbEvent = (DatabaseEvent)next;
                        dbTracker = new LoadDatabase(context, dbEvent, ((ReplLoadWork)this.work).dbNameToLoadIn, loadTaskTracker).tasks();
                        loadTaskTracker.update(dbTracker);
                        if (((ReplLoadWork)this.work).hasDbState()) {
                            loadTaskTracker.update(this.updateDatabaseLastReplID(maxTasks, context, scope));
                        }
                        ((ReplLoadWork)this.work).updateDbEventState(dbEvent.toState());
                        if (dbTracker.hasTasks()) {
                            scope.rootTasks.addAll(dbTracker.tasks());
                            scope.database = true;
                        }
                        dbTracker.debugLog("database");
                        break;
                    }
                    case Table: {
                        TableContext tableContext = new TableContext(dbTracker, ((ReplLoadWork)this.work).dbNameToLoadIn, ((ReplLoadWork)this.work).tableNameToLoadIn);
                        TableEvent tableEvent = (TableEvent)next;
                        LoadTable loadTable = new LoadTable(tableEvent, context, iterator.replLogger(), tableContext, loadTaskTracker);
                        tableTracker = loadTable.tasks();
                        this.setUpDependencies(dbTracker, tableTracker);
                        if (!scope.database && tableTracker.hasTasks()) {
                            scope.rootTasks.addAll(tableTracker.tasks());
                            scope.table = true;
                        }
                        LoadPartitions loadPartitions = new LoadPartitions(context, iterator.replLogger(), loadTaskTracker, tableEvent, ((ReplLoadWork)this.work).dbNameToLoadIn, tableContext);
                        TaskTracker partitionsTracker = loadPartitions.tasks();
                        this.partitionsPostProcessing(iterator, scope, loadTaskTracker, tableTracker, partitionsTracker);
                        tableTracker.debugLog("table");
                        partitionsTracker.debugLog("partitions for table");
                        break;
                    }
                    case Partition: {
                        PartitionEvent event = (PartitionEvent)next;
                        TableContext tableContext = new TableContext(dbTracker, ((ReplLoadWork)this.work).dbNameToLoadIn, ((ReplLoadWork)this.work).tableNameToLoadIn);
                        LoadPartitions loadPartitions = new LoadPartitions(context, iterator.replLogger(), tableContext, loadTaskTracker, event.asTableEvent(), ((ReplLoadWork)this.work).dbNameToLoadIn, event.lastPartitionReplicated());
                        TaskTracker partitionsTracker = loadPartitions.tasks();
                        this.partitionsPostProcessing(iterator, scope, loadTaskTracker, tableTracker, partitionsTracker);
                        partitionsTracker.debugLog("partitions");
                        break;
                    }
                    case Function: {
                        LoadFunction loadFunction = new LoadFunction(context, iterator.replLogger(), (FunctionEvent)next, ((ReplLoadWork)this.work).dbNameToLoadIn, dbTracker);
                        TaskTracker functionsTracker = loadFunction.tasks();
                        if (!scope.database) {
                            scope.rootTasks.addAll(functionsTracker.tasks());
                        } else {
                            this.setUpDependencies(dbTracker, functionsTracker);
                        }
                        loadTaskTracker.update(functionsTracker);
                        functionsTracker.debugLog("functions");
                        break;
                    }
                    case Constraint: {
                        LoadConstraint loadConstraint = new LoadConstraint(context, (ConstraintEvent)next, ((ReplLoadWork)this.work).dbNameToLoadIn, dbTracker);
                        TaskTracker constraintTracker = loadConstraint.tasks();
                        scope.rootTasks.addAll(constraintTracker.tasks());
                        loadTaskTracker.update(constraintTracker);
                        constraintTracker.debugLog("constraints");
                    }
                }
                if (loadingConstraint || iterator.currentDbHasNext()) continue;
                this.createEndReplLogTask(context, scope, iterator.replLogger());
            }
            boolean addAnotherLoadTask = iterator.hasNext() || loadTaskTracker.hasReplicationState() || constraintIterator.hasNext();
            this.createBuilderTask(scope.rootTasks, addAnotherLoadTask);
            if (!iterator.hasNext() && !constraintIterator.hasNext()) {
                loadTaskTracker.update(this.updateDatabaseLastReplID(maxTasks, context, scope));
                ((ReplLoadWork)this.work).updateDbEventState(null);
            }
            this.childTasks = scope.rootTasks;
            LOG.info("Root Tasks / Total Tasks : {} / {} ", (Object)this.childTasks.size(), (Object)loadTaskTracker.numberOfTasks());
            driverContext.getCtx().getFsScratchDirs().putAll(context.pathInfo.getFsScratchDirs());
        }
        catch (Exception e) {
            LOG.error("failed replication", (Throwable)e);
            this.setException(e);
            return ErrorMsg.getErrorMsg(e.getMessage()).getErrorCode();
        }
        LOG.info("completed load task run : {}", (Object)((ReplLoadWork)this.work).executedLoadTask());
        return 0;
    }

    private void createEndReplLogTask(Context context, Scope scope, ReplLogger replLogger) throws SemanticException {
        Database dbInMetadata = ((ReplLoadWork)this.work).databaseEvent(context.hiveConf).dbInMetadata(((ReplLoadWork)this.work).dbNameToLoadIn);
        ReplStateLogWork replLogWork = new ReplStateLogWork(replLogger, dbInMetadata.getParameters());
        Task<ReplStateLogWork> replLogTask = TaskFactory.get(replLogWork);
        if (scope.rootTasks.isEmpty()) {
            scope.rootTasks.add(replLogTask);
        } else {
            DAGTraversal.traverse(scope.rootTasks, new AddDependencyToLeaves(Collections.singletonList(replLogTask)));
        }
    }

    private TaskTracker updateDatabaseLastReplID(int maxTasks, Context context, Scope scope) throws SemanticException {
        TaskTracker taskTracker = new LoadDatabase.AlterDatabase(context, ((ReplLoadWork)this.work).databaseEvent(context.hiveConf), ((ReplLoadWork)this.work).dbNameToLoadIn, new TaskTracker(maxTasks)).tasks();
        AddDependencyToLeaves function = new AddDependencyToLeaves(taskTracker.tasks());
        DAGTraversal.traverse(scope.rootTasks, function);
        return taskTracker;
    }

    private void partitionsPostProcessing(BootstrapEventsIterator iterator, Scope scope, TaskTracker loadTaskTracker, TaskTracker tableTracker, TaskTracker partitionsTracker) throws SemanticException {
        this.setUpDependencies(tableTracker, partitionsTracker);
        if (!scope.database && !scope.table) {
            scope.rootTasks.addAll(partitionsTracker.tasks());
            scope.partition = true;
        }
        loadTaskTracker.update(tableTracker);
        loadTaskTracker.update(partitionsTracker);
        if (partitionsTracker.hasReplicationState()) {
            iterator.setReplicationState(partitionsTracker.replicationState());
        }
    }

    private void setUpDependencies(TaskTracker parentTasks, TaskTracker childTasks) {
        if (parentTasks.hasTasks()) {
            for (Task<? extends Serializable> parentTask : parentTasks.tasks()) {
                for (Task<? extends Serializable> childTask : childTasks.tasks()) {
                    parentTask.addDependentTask(childTask);
                }
            }
        } else {
            for (Task<? extends Serializable> childTask : childTasks.tasks()) {
                parentTasks.addTask(childTask);
            }
        }
    }

    private void createBuilderTask(List<Task<? extends Serializable>> rootTasks, boolean shouldCreateAnotherLoadTask) {
        if (shouldCreateAnotherLoadTask) {
            Task<ReplLoadWork> loadTask = TaskFactory.get((ReplLoadWork)this.work, this.conf);
            DAGTraversal.traverse(rootTasks, new AddDependencyToLeaves(loadTask));
        }
    }

    @Override
    public StageType getType() {
        return StageType.REPL_BOOTSTRAP_LOAD;
    }

    private static class Scope {
        boolean database = false;
        boolean table = false;
        boolean partition = false;
        List<Task<? extends Serializable>> rootTasks = new ArrayList<Task<? extends Serializable>>();

        private Scope() {
        }
    }
}

