/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.security;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge23;
import org.apache.hadoop.hive.metastore.security.ThriftTransportHelper;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.rpcauth.RpcAuthMethod;
import org.apache.hive.scram.CredentialCacheHelper;
import org.apache.hive.scram.ScramUtil;
import org.apache.thrift.transport.TSaslServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class HadoopThriftAuthBridge25Sasl
extends HadoopThriftAuthBridge23 {
    private static final Log LOG = LogFactory.getLog(HadoopThriftAuthBridge25Sasl.class);

    @Override
    public Server createServer(String keytabFile, String principalConf, String clientConf) throws TTransportException {
        if (keytabFile.isEmpty() || principalConf.isEmpty()) {
            return new Server();
        }
        return new Server(keytabFile, principalConf, clientConf);
    }

    @Override
    public Client createClientWithConf(String authType) {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", authType);
        UserGroupInformation.setConfiguration((Configuration)conf);
        return new Client();
    }

    @Override
    public Client createClient() {
        return new Client();
    }

    public static class Client
    extends HadoopThriftAuthBridge.Client {
        @Override
        public TTransport createClientTransport(String principalConfig, String host, String methodStr, String tokenStrForm, TTransport underlyingTransport, Map<String, String> saslProps) throws IOException {
            switch (ThriftTransportHelper.format(methodStr)) {
                case "DIGEST": 
                case "TOKEN": {
                    return ThriftTransportHelper.createTokenTransport(underlyingTransport, tokenStrForm, saslProps);
                }
                case "SCRAM": {
                    return ThriftTransportHelper.createScramTransport(underlyingTransport, tokenStrForm, saslProps);
                }
                case "KERBEROS": {
                    return ThriftTransportHelper.createKerberosTransport(principalConfig, host, underlyingTransport, saslProps);
                }
                case "MAPRSASL": 
                case "PAM": 
                case "LDAP": {
                    return ThriftTransportHelper.createMapRSaslTransport(underlyingTransport, saslProps);
                }
            }
            throw new IOException("Unsupported authentication method: " + methodStr);
        }
    }

    public static class Server
    extends HadoopThriftAuthBridge.Server {
        public Server() throws TTransportException {
        }

        protected Server(String keytabFile, String principalConf, String clientConf) throws TTransportException {
            super(keytabFile, principalConf, clientConf);
        }

        @Override
        public TSaslServerTransport.Factory createSaslServerTransportFactory(Map<String, String> saslProps) {
            List rpcAuthMethods = this.realUgi.getRpcAuthMethodList();
            TSaslServerTransport.Factory transFactory = new TSaslServerTransport.Factory();
            for (RpcAuthMethod rpcAuthMethod : rpcAuthMethods) {
                if (rpcAuthMethod.getAuthenticationMethod().equals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS)) {
                    String kerberosName = this.realUgi.getUserName();
                    String[] names = SaslRpcServer.splitKerberosName((String)kerberosName);
                    if (names.length != 3) continue;
                    transFactory.addServerDefinition(rpcAuthMethod.getMechanismName(), names[0], names[1], saslProps, rpcAuthMethod.createCallbackHandler());
                    continue;
                }
                transFactory.addServerDefinition(rpcAuthMethod.getMechanismName(), null, "default", saslProps, rpcAuthMethod.createCallbackHandler());
            }
            transFactory.addServerDefinition(SaslRpcServer.AuthMethod.DIGEST.getMechanismName(), null, "default", saslProps, new HadoopThriftAuthBridge.Server.SaslDigestCallbackHandler(this.secretManager));
            switch (this.secretManager.getDelegationTokenAuthentication()) {
                case "SCRAM": {
                    transFactory.addServerDefinition(ScramUtil.getScramMechanismName(), null, "default", saslProps, new HadoopThriftAuthBridge.Server.ScramServerCallbackHandler(CredentialCacheHelper.getScramCache(), this.secretManager));
                    LOG.info((Object)String.format("Added SASL Server definition with mechanism %s", ScramUtil.getScramMechanismName()));
                    break;
                }
                case "DIGEST": 
                case "TOKEN": {
                    transFactory.addServerDefinition(SaslRpcServer.AuthMethod.TOKEN.getMechanismName(), null, "default", saslProps, new HadoopThriftAuthBridge.Server.SaslDigestCallbackHandler(this.secretManager));
                    LOG.info((Object)String.format("Added SASL Server definition with mechanism %s", SaslRpcServer.AuthMethod.TOKEN.getMechanismName()));
                    break;
                }
                default: {
                    LOG.warn((Object)String.format("Unknown delegation token auth method: %s", this.secretManager.getDelegationTokenAuthentication()));
                }
            }
            return transFactory;
        }
    }
}

