/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestIUD {
    private static HiveConf conf;
    private ParseDriver pd;

    @BeforeClass
    public static void initialize() {
        conf = new HiveConf(SemanticAnalyzer.class);
        conf.set("fs.defaultFS", "file:///");
        SessionState.start((HiveConf)conf);
    }

    @Before
    public void setup() throws SemanticException, IOException {
        this.pd = new ParseDriver();
    }

    ASTNode parse(String query) throws ParseException {
        return TestIUD.parse(query, this.pd, conf);
    }

    static ASTNode parse(String query, ParseDriver pd, HiveConf conf) throws ParseException {
        ASTNode nd = null;
        try {
            nd = pd.parse(query, new Context((Configuration)conf));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (ASTNode)nd.getChild(0);
    }

    @Test
    public void testDeleteNoWhere() throws ParseException {
        ASTNode ast = this.parse("DELETE FROM src");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(tok_delete_from (tok_tabname src))", (Object)ast.toStringTree());
    }

    @Test
    public void testDeleteWithWhere() throws ParseException {
        ASTNode ast = this.parse("DELETE FROM src WHERE key IS NOT NULL AND src.value < 0");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(tok_delete_from (tok_tabname src) (tok_where (and (tok_function isnotnull (tok_table_or_col key)) (< (. (tok_table_or_col src) value) 0))))", (Object)ast.toStringTree());
    }

    @Test
    public void testUpdateNoWhereSingleSet() throws ParseException {
        ASTNode ast = this.parse("UPDATE src set key = 3");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(tok_update_table (tok_tabname src) (tok_set_columns_clause (= (tok_table_or_col key) 3)))", (Object)ast.toStringTree());
    }

    @Test
    public void testUpdateNoWhereMultiSet() throws ParseException {
        ASTNode ast = this.parse("UPDATE src set key = 3, value = 8");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(tok_update_table (tok_tabname src) (tok_set_columns_clause (= (tok_table_or_col key) 3) (= (tok_table_or_col value) 8)))", (Object)ast.toStringTree());
    }

    @Test
    public void testUpdateWithWhereSingleSet() throws ParseException {
        ASTNode ast = this.parse("UPDATE src SET key = 3 WHERE value IS NULL");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(tok_update_table (tok_tabname src) (tok_set_columns_clause (= (tok_table_or_col key) 3)) (tok_where (tok_function isnull (tok_table_or_col value))))", (Object)ast.toStringTree());
    }

    @Test
    public void testUpdateWithWhereSingleSetExpr() throws ParseException {
        ASTNode ast = this.parse("UPDATE src SET key = -3+(5*9)%8, val = cast(6.1 + c as INT), d = d - 1 WHERE value IS NULL");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(tok_update_table (tok_tabname src) (tok_set_columns_clause (= (tok_table_or_col key) (+ (- 3) (% (* 5 9) 8))) (= (tok_table_or_col val) (tok_function tok_int (+ 6.1 (tok_table_or_col c)))) (= (tok_table_or_col d) (- (tok_table_or_col d) 1))) (tok_where (tok_function isnull (tok_table_or_col value))))", (Object)ast.toStringTree());
    }

    @Test
    public void testUpdateWithWhereMultiSet() throws ParseException {
        ASTNode ast = this.parse("UPDATE src SET key = 3, value = 8 WHERE VALUE = 1230997");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(tok_update_table (tok_tabname src) (tok_set_columns_clause (= (tok_table_or_col key) 3) (= (tok_table_or_col value) 8)) (tok_where (= (tok_table_or_col value) 1230997)))", (Object)ast.toStringTree());
    }

    @Test
    public void testStandardInsertIntoTable() throws ParseException {
        ASTNode ast = this.parse("INSERT into TABLE page_view SELECT pvs.viewTime, pvs.userid from page_view_stg pvs where pvs.userid is null");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(tok_query (tok_from (tok_tabref (tok_tabname page_view_stg) pvs)) (tok_insert (tok_insert_into (tok_tab (tok_tabname page_view))) (tok_select (tok_selexpr (. (tok_table_or_col pvs) viewtime)) (tok_selexpr (. (tok_table_or_col pvs) userid))) (tok_where (tok_function isnull (. (tok_table_or_col pvs) userid)))))", (Object)ast.toStringTree());
    }

    @Test
    public void testSelectStarFromAnonymousVirtTable1Row() throws ParseException {
        try {
            this.parse("select * from `values` (3,4)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:24 cannot recognize input near 'values' '(' '3' in joinSource", (Object)ex.getMessage());
        }
    }

    @Test
    public void testMultiInsert() throws ParseException {
        ASTNode ast = this.parse("from S insert into T1 select a, b insert into T2 select c, d");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(tok_query (tok_from (tok_tabref (tok_tabname s))) (tok_insert (tok_insert_into (tok_tab (tok_tabname t1))) (tok_select (tok_selexpr (tok_table_or_col a)) (tok_selexpr (tok_table_or_col b)))) (tok_insert (tok_insert_into (tok_tab (tok_tabname t2))) (tok_select (tok_selexpr (tok_table_or_col c)) (tok_selexpr (tok_table_or_col d)))))", (Object)ast.toStringTree());
    }
}

