/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.util.Random;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColEqualDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColEqualLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColGreaterDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColGreaterEqualDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColGreaterEqualLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColGreaterLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColLessDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColLessEqualDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColLessEqualLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColLessLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColNotEqualDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColNotEqualLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleScalarEqualDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleScalarEqualLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleScalarGreaterDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleScalarGreaterEqualDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleScalarGreaterEqualLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleScalarGreaterLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleScalarLessDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleScalarLessEqualDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleScalarLessEqualLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleScalarLessLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleScalarNotEqualDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleScalarNotEqualLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColEqualDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColEqualLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColGreaterDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColGreaterEqualDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColGreaterEqualLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColGreaterLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColLessDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColLessEqualDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColLessEqualLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColLessLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColNotEqualDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColNotEqualLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongScalarEqualDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongScalarEqualLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongScalarGreaterDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongScalarGreaterEqualDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongScalarGreaterEqualLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongScalarGreaterLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongScalarLessDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongScalarLessEqualDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongScalarLessEqualLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongScalarLessLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongScalarNotEqualDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongScalarNotEqualLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.util.VectorizedRowGroupGenUtil;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.junit.Assert;
import org.junit.Test;

public class TestColumnScalarFilterVectorExpressionEvaluation {
    private static final int BATCH_SIZE = 100;
    private static final long SEED = 64087L;

    @Test
    public void testFilterLongColEqualDoubleScalarColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColEqualDoubleScalar vectorExpression = new FilterLongColEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] == scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || (double)inputColumnVector.vector[i] != scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "==" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColEqualDoubleScalarColNulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColEqualDoubleScalar vectorExpression = new FilterLongColEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] == scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || (double)inputColumnVector.vector[i] != scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "==" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColEqualDoubleScalar() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColEqualDoubleScalar vectorExpression = new FilterLongColEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] == scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || (double)inputColumnVector.vector[i] != scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "==" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColEqualDoubleScalarColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColEqualDoubleScalar vectorExpression = new FilterLongColEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] == scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || (double)inputColumnVector.vector[i] != scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "==" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColEqualDoubleScalarColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColEqualDoubleScalar vectorExpression = new FilterDoubleColEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] == scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] != scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "==" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColEqualDoubleScalarColNulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColEqualDoubleScalar vectorExpression = new FilterDoubleColEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] == scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] != scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "==" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColEqualDoubleScalar() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColEqualDoubleScalar vectorExpression = new FilterDoubleColEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] == scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] != scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "==" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColEqualDoubleScalarColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColEqualDoubleScalar vectorExpression = new FilterDoubleColEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] == scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] != scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "==" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColNotEqualDoubleScalarColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColNotEqualDoubleScalar vectorExpression = new FilterLongColNotEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] != scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || (double)inputColumnVector.vector[i] == scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "!=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColNotEqualDoubleScalarColNulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColNotEqualDoubleScalar vectorExpression = new FilterLongColNotEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] != scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || (double)inputColumnVector.vector[i] == scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "!=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColNotEqualDoubleScalar() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColNotEqualDoubleScalar vectorExpression = new FilterLongColNotEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] != scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || (double)inputColumnVector.vector[i] == scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "!=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColNotEqualDoubleScalarColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColNotEqualDoubleScalar vectorExpression = new FilterLongColNotEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] != scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || (double)inputColumnVector.vector[i] == scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "!=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColNotEqualDoubleScalarColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColNotEqualDoubleScalar vectorExpression = new FilterDoubleColNotEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] != scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] == scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "!=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColNotEqualDoubleScalarColNulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColNotEqualDoubleScalar vectorExpression = new FilterDoubleColNotEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] != scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] == scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "!=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColNotEqualDoubleScalar() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColNotEqualDoubleScalar vectorExpression = new FilterDoubleColNotEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] != scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] == scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "!=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColNotEqualDoubleScalarColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColNotEqualDoubleScalar vectorExpression = new FilterDoubleColNotEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] != scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] == scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "!=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessDoubleScalarColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColLessDoubleScalar vectorExpression = new FilterLongColLessDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] < scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)inputColumnVector.vector[i] < scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessDoubleScalarColNulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColLessDoubleScalar vectorExpression = new FilterLongColLessDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] < scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)inputColumnVector.vector[i] < scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessDoubleScalar() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColLessDoubleScalar vectorExpression = new FilterLongColLessDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] < scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)inputColumnVector.vector[i] < scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessDoubleScalarColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColLessDoubleScalar vectorExpression = new FilterLongColLessDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] < scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)inputColumnVector.vector[i] < scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessDoubleScalarColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColLessDoubleScalar vectorExpression = new FilterDoubleColLessDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] < scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] < scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessDoubleScalarColNulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColLessDoubleScalar vectorExpression = new FilterDoubleColLessDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] < scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] < scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessDoubleScalar() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColLessDoubleScalar vectorExpression = new FilterDoubleColLessDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] < scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] < scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessDoubleScalarColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColLessDoubleScalar vectorExpression = new FilterDoubleColLessDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] < scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] < scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessEqualDoubleScalarColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColLessEqualDoubleScalar vectorExpression = new FilterLongColLessEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] <= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)inputColumnVector.vector[i] <= scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessEqualDoubleScalarColNulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColLessEqualDoubleScalar vectorExpression = new FilterLongColLessEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] <= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)inputColumnVector.vector[i] <= scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessEqualDoubleScalar() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColLessEqualDoubleScalar vectorExpression = new FilterLongColLessEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] <= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)inputColumnVector.vector[i] <= scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessEqualDoubleScalarColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColLessEqualDoubleScalar vectorExpression = new FilterLongColLessEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] <= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)inputColumnVector.vector[i] <= scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessEqualDoubleScalarColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColLessEqualDoubleScalar vectorExpression = new FilterDoubleColLessEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] <= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] <= scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessEqualDoubleScalarColNulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColLessEqualDoubleScalar vectorExpression = new FilterDoubleColLessEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] <= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] <= scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessEqualDoubleScalar() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColLessEqualDoubleScalar vectorExpression = new FilterDoubleColLessEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] <= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] <= scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessEqualDoubleScalarColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColLessEqualDoubleScalar vectorExpression = new FilterDoubleColLessEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] <= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] <= scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterDoubleScalarColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColGreaterDoubleScalar vectorExpression = new FilterLongColGreaterDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] > scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)inputColumnVector.vector[i] > scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterDoubleScalarColNulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColGreaterDoubleScalar vectorExpression = new FilterLongColGreaterDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] > scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)inputColumnVector.vector[i] > scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterDoubleScalar() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColGreaterDoubleScalar vectorExpression = new FilterLongColGreaterDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] > scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)inputColumnVector.vector[i] > scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterDoubleScalarColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColGreaterDoubleScalar vectorExpression = new FilterLongColGreaterDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] > scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)inputColumnVector.vector[i] > scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterDoubleScalarColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColGreaterDoubleScalar vectorExpression = new FilterDoubleColGreaterDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] > scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] > scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterDoubleScalarColNulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColGreaterDoubleScalar vectorExpression = new FilterDoubleColGreaterDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] > scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] > scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterDoubleScalar() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColGreaterDoubleScalar vectorExpression = new FilterDoubleColGreaterDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] > scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] > scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterDoubleScalarColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColGreaterDoubleScalar vectorExpression = new FilterDoubleColGreaterDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] > scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] > scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterEqualDoubleScalarColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColGreaterEqualDoubleScalar vectorExpression = new FilterLongColGreaterEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] >= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)inputColumnVector.vector[i] >= scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterEqualDoubleScalarColNulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColGreaterEqualDoubleScalar vectorExpression = new FilterLongColGreaterEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] >= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)inputColumnVector.vector[i] >= scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterEqualDoubleScalar() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColGreaterEqualDoubleScalar vectorExpression = new FilterLongColGreaterEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] >= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)inputColumnVector.vector[i] >= scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterEqualDoubleScalarColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColGreaterEqualDoubleScalar vectorExpression = new FilterLongColGreaterEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] >= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)inputColumnVector.vector[i] >= scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterEqualDoubleScalarColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColGreaterEqualDoubleScalar vectorExpression = new FilterDoubleColGreaterEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] >= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] >= scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterEqualDoubleScalarColNulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColGreaterEqualDoubleScalar vectorExpression = new FilterDoubleColGreaterEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] >= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] >= scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterEqualDoubleScalar() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColGreaterEqualDoubleScalar vectorExpression = new FilterDoubleColGreaterEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] >= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] >= scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterEqualDoubleScalarColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColGreaterEqualDoubleScalar vectorExpression = new FilterDoubleColGreaterEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] >= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] >= scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColEqualLongScalarColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColEqualLongScalar vectorExpression = new FilterLongColEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] == scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] != scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "==" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColEqualLongScalarColNulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColEqualLongScalar vectorExpression = new FilterLongColEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] == scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] != scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "==" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColEqualLongScalar() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColEqualLongScalar vectorExpression = new FilterLongColEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] == scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] != scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "==" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColEqualLongScalarColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColEqualLongScalar vectorExpression = new FilterLongColEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] == scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] != scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "==" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColEqualLongScalarColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColEqualLongScalar vectorExpression = new FilterDoubleColEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] == (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] != (double)scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "==" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColEqualLongScalarColNulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColEqualLongScalar vectorExpression = new FilterDoubleColEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] == (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] != (double)scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "==" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColEqualLongScalar() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColEqualLongScalar vectorExpression = new FilterDoubleColEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] == (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] != (double)scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "==" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColEqualLongScalarColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColEqualLongScalar vectorExpression = new FilterDoubleColEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] == (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] != (double)scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "==" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColNotEqualLongScalarColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColNotEqualLongScalar vectorExpression = new FilterLongColNotEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] != scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] == scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "!=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColNotEqualLongScalarColNulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColNotEqualLongScalar vectorExpression = new FilterLongColNotEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] != scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] == scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "!=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColNotEqualLongScalar() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColNotEqualLongScalar vectorExpression = new FilterLongColNotEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] != scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] == scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "!=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColNotEqualLongScalarColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColNotEqualLongScalar vectorExpression = new FilterLongColNotEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] != scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] == scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "!=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColNotEqualLongScalarColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColNotEqualLongScalar vectorExpression = new FilterDoubleColNotEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] != (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] == (double)scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "!=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColNotEqualLongScalarColNulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColNotEqualLongScalar vectorExpression = new FilterDoubleColNotEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] != (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] == (double)scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "!=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColNotEqualLongScalar() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColNotEqualLongScalar vectorExpression = new FilterDoubleColNotEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] != (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] == (double)scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "!=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColNotEqualLongScalarColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColNotEqualLongScalar vectorExpression = new FilterDoubleColNotEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] != (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] == (double)scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "!=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessLongScalarColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColLessLongScalar vectorExpression = new FilterLongColLessLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] < scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] >= scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessLongScalarColNulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColLessLongScalar vectorExpression = new FilterLongColLessLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] < scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] >= scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessLongScalar() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColLessLongScalar vectorExpression = new FilterLongColLessLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] < scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] >= scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessLongScalarColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColLessLongScalar vectorExpression = new FilterLongColLessLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] < scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] >= scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessLongScalarColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColLessLongScalar vectorExpression = new FilterDoubleColLessLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] < (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] < (double)scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessLongScalarColNulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColLessLongScalar vectorExpression = new FilterDoubleColLessLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] < (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] < (double)scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessLongScalar() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColLessLongScalar vectorExpression = new FilterDoubleColLessLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] < (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] < (double)scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessLongScalarColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColLessLongScalar vectorExpression = new FilterDoubleColLessLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] < (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] < (double)scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessEqualLongScalarColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColLessEqualLongScalar vectorExpression = new FilterLongColLessEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] <= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] > scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessEqualLongScalarColNulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColLessEqualLongScalar vectorExpression = new FilterLongColLessEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] <= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] > scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessEqualLongScalar() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColLessEqualLongScalar vectorExpression = new FilterLongColLessEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] <= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] > scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessEqualLongScalarColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColLessEqualLongScalar vectorExpression = new FilterLongColLessEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] <= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] > scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessEqualLongScalarColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColLessEqualLongScalar vectorExpression = new FilterDoubleColLessEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] <= (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] <= (double)scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessEqualLongScalarColNulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColLessEqualLongScalar vectorExpression = new FilterDoubleColLessEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] <= (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] <= (double)scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessEqualLongScalar() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColLessEqualLongScalar vectorExpression = new FilterDoubleColLessEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] <= (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] <= (double)scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessEqualLongScalarColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColLessEqualLongScalar vectorExpression = new FilterDoubleColLessEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] <= (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] <= (double)scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterLongScalarColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColGreaterLongScalar vectorExpression = new FilterLongColGreaterLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] > scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] <= scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterLongScalarColNulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColGreaterLongScalar vectorExpression = new FilterLongColGreaterLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] > scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] <= scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterLongScalar() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColGreaterLongScalar vectorExpression = new FilterLongColGreaterLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] > scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] <= scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterLongScalarColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColGreaterLongScalar vectorExpression = new FilterLongColGreaterLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] > scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] <= scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterLongScalarColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColGreaterLongScalar vectorExpression = new FilterDoubleColGreaterLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] > (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] > (double)scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterLongScalarColNulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColGreaterLongScalar vectorExpression = new FilterDoubleColGreaterLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] > (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] > (double)scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterLongScalar() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColGreaterLongScalar vectorExpression = new FilterDoubleColGreaterLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] > (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] > (double)scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterLongScalarColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColGreaterLongScalar vectorExpression = new FilterDoubleColGreaterLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] > (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] > (double)scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterEqualLongScalarColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColGreaterEqualLongScalar vectorExpression = new FilterLongColGreaterEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] >= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] < scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterEqualLongScalarColNulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColGreaterEqualLongScalar vectorExpression = new FilterLongColGreaterEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] >= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] < scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterEqualLongScalar() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColGreaterEqualLongScalar vectorExpression = new FilterLongColGreaterEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] >= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] < scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterEqualLongScalarColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColGreaterEqualLongScalar vectorExpression = new FilterLongColGreaterEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] >= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] < scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterEqualLongScalarColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColGreaterEqualLongScalar vectorExpression = new FilterDoubleColGreaterEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] >= (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] >= (double)scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterEqualLongScalarColNulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColGreaterEqualLongScalar vectorExpression = new FilterDoubleColGreaterEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] >= (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] >= (double)scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterEqualLongScalar() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColGreaterEqualLongScalar vectorExpression = new FilterDoubleColGreaterEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] >= (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] >= (double)scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterEqualLongScalarColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColGreaterEqualLongScalar vectorExpression = new FilterDoubleColGreaterEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] >= (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] >= (double)scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarEqualDoubleColumnColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarEqualDoubleColumn vectorExpression = new FilterLongScalarEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue == inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || (double)scalarValue != inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "==" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarEqualDoubleColumnColNulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarEqualDoubleColumn vectorExpression = new FilterLongScalarEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue == inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || (double)scalarValue != inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "==" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarEqualDoubleColumn() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarEqualDoubleColumn vectorExpression = new FilterLongScalarEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue == inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || (double)scalarValue != inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "==" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarEqualDoubleColumnColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarEqualDoubleColumn vectorExpression = new FilterLongScalarEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue == inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || (double)scalarValue != inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "==" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarEqualDoubleColumnColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarEqualDoubleColumn vectorExpression = new FilterDoubleScalarEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue == inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue != inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "==" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarEqualDoubleColumnColNulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarEqualDoubleColumn vectorExpression = new FilterDoubleScalarEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue == inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue != inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "==" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarEqualDoubleColumn() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarEqualDoubleColumn vectorExpression = new FilterDoubleScalarEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue == inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue != inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "==" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarEqualDoubleColumnColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarEqualDoubleColumn vectorExpression = new FilterDoubleScalarEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue == inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue != inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "==" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarNotEqualDoubleColumnColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarNotEqualDoubleColumn vectorExpression = new FilterLongScalarNotEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue != inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || (double)scalarValue == inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "!=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarNotEqualDoubleColumnColNulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarNotEqualDoubleColumn vectorExpression = new FilterLongScalarNotEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue != inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || (double)scalarValue == inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "!=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarNotEqualDoubleColumn() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarNotEqualDoubleColumn vectorExpression = new FilterLongScalarNotEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue != inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || (double)scalarValue == inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "!=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarNotEqualDoubleColumnColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarNotEqualDoubleColumn vectorExpression = new FilterLongScalarNotEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue != inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || (double)scalarValue == inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "!=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarNotEqualDoubleColumnColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarNotEqualDoubleColumn vectorExpression = new FilterDoubleScalarNotEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue != inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue == inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "!=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarNotEqualDoubleColumnColNulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarNotEqualDoubleColumn vectorExpression = new FilterDoubleScalarNotEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue != inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue == inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "!=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarNotEqualDoubleColumn() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarNotEqualDoubleColumn vectorExpression = new FilterDoubleScalarNotEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue != inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue == inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "!=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarNotEqualDoubleColumnColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarNotEqualDoubleColumn vectorExpression = new FilterDoubleScalarNotEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue != inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue == inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "!=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarLessDoubleColumnColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarLessDoubleColumn vectorExpression = new FilterLongScalarLessDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue < inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)scalarValue < inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarLessDoubleColumnColNulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarLessDoubleColumn vectorExpression = new FilterLongScalarLessDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue < inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)scalarValue < inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarLessDoubleColumn() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarLessDoubleColumn vectorExpression = new FilterLongScalarLessDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue < inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)scalarValue < inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarLessDoubleColumnColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarLessDoubleColumn vectorExpression = new FilterLongScalarLessDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue < inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)scalarValue < inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarLessDoubleColumnColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarLessDoubleColumn vectorExpression = new FilterDoubleScalarLessDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue < inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue < inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarLessDoubleColumnColNulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarLessDoubleColumn vectorExpression = new FilterDoubleScalarLessDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue < inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue < inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarLessDoubleColumn() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarLessDoubleColumn vectorExpression = new FilterDoubleScalarLessDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue < inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue < inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarLessDoubleColumnColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarLessDoubleColumn vectorExpression = new FilterDoubleScalarLessDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue < inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue < inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarLessEqualDoubleColumnColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarLessEqualDoubleColumn vectorExpression = new FilterLongScalarLessEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue <= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)scalarValue <= inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarLessEqualDoubleColumnColNulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarLessEqualDoubleColumn vectorExpression = new FilterLongScalarLessEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue <= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)scalarValue <= inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarLessEqualDoubleColumn() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarLessEqualDoubleColumn vectorExpression = new FilterLongScalarLessEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue <= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)scalarValue <= inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarLessEqualDoubleColumnColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarLessEqualDoubleColumn vectorExpression = new FilterLongScalarLessEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue <= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)scalarValue <= inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarLessEqualDoubleColumnColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarLessEqualDoubleColumn vectorExpression = new FilterDoubleScalarLessEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue <= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue <= inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarLessEqualDoubleColumnColNulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarLessEqualDoubleColumn vectorExpression = new FilterDoubleScalarLessEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue <= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue <= inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarLessEqualDoubleColumn() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarLessEqualDoubleColumn vectorExpression = new FilterDoubleScalarLessEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue <= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue <= inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarLessEqualDoubleColumnColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarLessEqualDoubleColumn vectorExpression = new FilterDoubleScalarLessEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue <= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue <= inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarGreaterDoubleColumnColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarGreaterDoubleColumn vectorExpression = new FilterLongScalarGreaterDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue > inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)scalarValue > inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarGreaterDoubleColumnColNulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarGreaterDoubleColumn vectorExpression = new FilterLongScalarGreaterDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue > inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)scalarValue > inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarGreaterDoubleColumn() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarGreaterDoubleColumn vectorExpression = new FilterLongScalarGreaterDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue > inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)scalarValue > inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarGreaterDoubleColumnColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarGreaterDoubleColumn vectorExpression = new FilterLongScalarGreaterDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue > inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)scalarValue > inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarGreaterDoubleColumnColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarGreaterDoubleColumn vectorExpression = new FilterDoubleScalarGreaterDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue > inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue > inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarGreaterDoubleColumnColNulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarGreaterDoubleColumn vectorExpression = new FilterDoubleScalarGreaterDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue > inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue > inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarGreaterDoubleColumn() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarGreaterDoubleColumn vectorExpression = new FilterDoubleScalarGreaterDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue > inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue > inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarGreaterDoubleColumnColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarGreaterDoubleColumn vectorExpression = new FilterDoubleScalarGreaterDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue > inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue > inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarGreaterEqualDoubleColumnColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarGreaterEqualDoubleColumn vectorExpression = new FilterLongScalarGreaterEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue >= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)scalarValue >= inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarGreaterEqualDoubleColumnColNulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarGreaterEqualDoubleColumn vectorExpression = new FilterLongScalarGreaterEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue >= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)scalarValue >= inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarGreaterEqualDoubleColumn() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarGreaterEqualDoubleColumn vectorExpression = new FilterLongScalarGreaterEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue >= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)scalarValue >= inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarGreaterEqualDoubleColumnColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarGreaterEqualDoubleColumn vectorExpression = new FilterLongScalarGreaterEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue >= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)scalarValue >= inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarGreaterEqualDoubleColumnColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarGreaterEqualDoubleColumn vectorExpression = new FilterDoubleScalarGreaterEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue >= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue >= inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarGreaterEqualDoubleColumnColNulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarGreaterEqualDoubleColumn vectorExpression = new FilterDoubleScalarGreaterEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue >= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue >= inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarGreaterEqualDoubleColumn() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarGreaterEqualDoubleColumn vectorExpression = new FilterDoubleScalarGreaterEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue >= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue >= inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarGreaterEqualDoubleColumnColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarGreaterEqualDoubleColumn vectorExpression = new FilterDoubleScalarGreaterEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue >= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue >= inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarEqualLongColumnColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarEqualLongColumn vectorExpression = new FilterLongScalarEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue == inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue != inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "==" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarEqualLongColumnColNulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarEqualLongColumn vectorExpression = new FilterLongScalarEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue == inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue != inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "==" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarEqualLongColumn() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarEqualLongColumn vectorExpression = new FilterLongScalarEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue == inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue != inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "==" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarEqualLongColumnColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarEqualLongColumn vectorExpression = new FilterLongScalarEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue == inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue != inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "==" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarEqualLongColumnColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarEqualLongColumn vectorExpression = new FilterDoubleScalarEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue == (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue != (double)inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "==" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarEqualLongColumnColNulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarEqualLongColumn vectorExpression = new FilterDoubleScalarEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue == (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue != (double)inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "==" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarEqualLongColumn() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarEqualLongColumn vectorExpression = new FilterDoubleScalarEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue == (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue != (double)inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "==" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarEqualLongColumnColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarEqualLongColumn vectorExpression = new FilterDoubleScalarEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue == (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue != (double)inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "==" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarNotEqualLongColumnColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarNotEqualLongColumn vectorExpression = new FilterLongScalarNotEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue != inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue == inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "!=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarNotEqualLongColumnColNulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarNotEqualLongColumn vectorExpression = new FilterLongScalarNotEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue != inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue == inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "!=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarNotEqualLongColumn() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarNotEqualLongColumn vectorExpression = new FilterLongScalarNotEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue != inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue == inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "!=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarNotEqualLongColumnColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarNotEqualLongColumn vectorExpression = new FilterLongScalarNotEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue != inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue == inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "!=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarNotEqualLongColumnColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarNotEqualLongColumn vectorExpression = new FilterDoubleScalarNotEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue != (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue == (double)inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "!=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarNotEqualLongColumnColNulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarNotEqualLongColumn vectorExpression = new FilterDoubleScalarNotEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue != (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue == (double)inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "!=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarNotEqualLongColumn() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarNotEqualLongColumn vectorExpression = new FilterDoubleScalarNotEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue != (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue == (double)inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "!=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarNotEqualLongColumnColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarNotEqualLongColumn vectorExpression = new FilterDoubleScalarNotEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue != (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue == (double)inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "!=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarLessLongColumnColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarLessLongColumn vectorExpression = new FilterLongScalarLessLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue < inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue >= inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarLessLongColumnColNulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarLessLongColumn vectorExpression = new FilterLongScalarLessLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue < inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue >= inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarLessLongColumn() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarLessLongColumn vectorExpression = new FilterLongScalarLessLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue < inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue >= inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarLessLongColumnColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarLessLongColumn vectorExpression = new FilterLongScalarLessLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue < inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue >= inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarLessLongColumnColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarLessLongColumn vectorExpression = new FilterDoubleScalarLessLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue < (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue < (double)inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarLessLongColumnColNulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarLessLongColumn vectorExpression = new FilterDoubleScalarLessLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue < (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue < (double)inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarLessLongColumn() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarLessLongColumn vectorExpression = new FilterDoubleScalarLessLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue < (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue < (double)inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarLessLongColumnColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarLessLongColumn vectorExpression = new FilterDoubleScalarLessLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue < (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue < (double)inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarLessEqualLongColumnColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarLessEqualLongColumn vectorExpression = new FilterLongScalarLessEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue <= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue > inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarLessEqualLongColumnColNulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarLessEqualLongColumn vectorExpression = new FilterLongScalarLessEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue <= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue > inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarLessEqualLongColumn() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarLessEqualLongColumn vectorExpression = new FilterLongScalarLessEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue <= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue > inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarLessEqualLongColumnColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarLessEqualLongColumn vectorExpression = new FilterLongScalarLessEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue <= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue > inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarLessEqualLongColumnColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarLessEqualLongColumn vectorExpression = new FilterDoubleScalarLessEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue <= (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue <= (double)inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarLessEqualLongColumnColNulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarLessEqualLongColumn vectorExpression = new FilterDoubleScalarLessEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue <= (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue <= (double)inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarLessEqualLongColumn() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarLessEqualLongColumn vectorExpression = new FilterDoubleScalarLessEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue <= (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue <= (double)inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarLessEqualLongColumnColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarLessEqualLongColumn vectorExpression = new FilterDoubleScalarLessEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue <= (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue <= (double)inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarGreaterLongColumnColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarGreaterLongColumn vectorExpression = new FilterLongScalarGreaterLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue > inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue <= inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarGreaterLongColumnColNulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarGreaterLongColumn vectorExpression = new FilterLongScalarGreaterLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue > inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue <= inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarGreaterLongColumn() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarGreaterLongColumn vectorExpression = new FilterLongScalarGreaterLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue > inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue <= inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarGreaterLongColumnColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarGreaterLongColumn vectorExpression = new FilterLongScalarGreaterLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue > inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue <= inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarGreaterLongColumnColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarGreaterLongColumn vectorExpression = new FilterDoubleScalarGreaterLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue > (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue > (double)inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarGreaterLongColumnColNulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarGreaterLongColumn vectorExpression = new FilterDoubleScalarGreaterLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue > (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue > (double)inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarGreaterLongColumn() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarGreaterLongColumn vectorExpression = new FilterDoubleScalarGreaterLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue > (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue > (double)inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarGreaterLongColumnColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarGreaterLongColumn vectorExpression = new FilterDoubleScalarGreaterLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue > (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue > (double)inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarGreaterEqualLongColumnColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarGreaterEqualLongColumn vectorExpression = new FilterLongScalarGreaterEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue >= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue < inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarGreaterEqualLongColumnColNulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarGreaterEqualLongColumn vectorExpression = new FilterLongScalarGreaterEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue >= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue < inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarGreaterEqualLongColumn() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarGreaterEqualLongColumn vectorExpression = new FilterLongScalarGreaterEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue >= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue < inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarGreaterEqualLongColumnColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarGreaterEqualLongColumn vectorExpression = new FilterLongScalarGreaterEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue >= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue < inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarGreaterEqualLongColumnColNullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarGreaterEqualLongColumn vectorExpression = new FilterDoubleScalarGreaterEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue >= (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue >= (double)inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarGreaterEqualLongColumnColNulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarGreaterEqualLongColumn vectorExpression = new FilterDoubleScalarGreaterEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue >= (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue >= (double)inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarGreaterEqualLongColumn() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarGreaterEqualLongColumn vectorExpression = new FilterDoubleScalarGreaterEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue >= (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue >= (double)inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarGreaterEqualLongColumnColRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarGreaterEqualLongColumn vectorExpression = new FilterDoubleScalarGreaterEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue >= (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue >= (double)inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }
}

