/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.ppr;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class TestPositivePartitionPrunerCompactExpr {
    private final ExprNodeDesc expression;
    private final String expected;

    public TestPositivePartitionPrunerCompactExpr(ExprNodeDesc expression, String expected) {
        this.expression = expression;
        this.expected = expected;
    }

    @Parameterized.Parameters(name="{index}: {0} => {1}")
    public static Iterable<Object[]> data() {
        ExprNodeConstantDesc trueExpr = new ExprNodeConstantDesc((Object)Boolean.TRUE);
        ExprNodeConstantDesc falseExpr = new ExprNodeConstantDesc((Object)Boolean.FALSE);
        ExprNodeColumnDesc col1Expr = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, "col1", "t1", true);
        ExprNodeColumnDesc col2Expr = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, "col2", "t1", true);
        ExprNodeGenericFuncDesc udf1Expr = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, (GenericUDF)new GenericUDFOPNull(), Arrays.asList(col1Expr));
        ExprNodeGenericFuncDesc udf2Expr = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, (GenericUDF)new GenericUDFOPNull(), Arrays.asList(col2Expr));
        return Arrays.asList({null, null}, {TestPositivePartitionPrunerCompactExpr.and(null, null), null}, {TestPositivePartitionPrunerCompactExpr.and((ExprNodeDesc)falseExpr, null), "false"}, {TestPositivePartitionPrunerCompactExpr.and(null, (ExprNodeDesc)falseExpr), "false"}, {TestPositivePartitionPrunerCompactExpr.and((ExprNodeDesc)trueExpr, null), null}, {TestPositivePartitionPrunerCompactExpr.and(null, (ExprNodeDesc)trueExpr), null}, {TestPositivePartitionPrunerCompactExpr.and((ExprNodeDesc)udf1Expr, null), "col1 is null"}, {TestPositivePartitionPrunerCompactExpr.and(null, (ExprNodeDesc)udf2Expr), "col2 is null"}, {TestPositivePartitionPrunerCompactExpr.and((ExprNodeDesc)udf1Expr, (ExprNodeDesc)udf2Expr), "(col1 is null and col2 is null)"}, {TestPositivePartitionPrunerCompactExpr.and((ExprNodeDesc)falseExpr, (ExprNodeDesc)falseExpr), "false"}, {TestPositivePartitionPrunerCompactExpr.and((ExprNodeDesc)trueExpr, (ExprNodeDesc)falseExpr), "false"}, {TestPositivePartitionPrunerCompactExpr.and((ExprNodeDesc)falseExpr, (ExprNodeDesc)trueExpr), "false"}, {TestPositivePartitionPrunerCompactExpr.and((ExprNodeDesc)udf1Expr, (ExprNodeDesc)falseExpr), "false"}, {TestPositivePartitionPrunerCompactExpr.and((ExprNodeDesc)falseExpr, (ExprNodeDesc)udf2Expr), "false"}, {TestPositivePartitionPrunerCompactExpr.and((ExprNodeDesc)trueExpr, (ExprNodeDesc)trueExpr), "true"}, {TestPositivePartitionPrunerCompactExpr.and((ExprNodeDesc)udf1Expr, (ExprNodeDesc)trueExpr), "col1 is null"}, {TestPositivePartitionPrunerCompactExpr.and((ExprNodeDesc)trueExpr, (ExprNodeDesc)udf2Expr), "col2 is null"}, {TestPositivePartitionPrunerCompactExpr.or(null, null), null}, {TestPositivePartitionPrunerCompactExpr.or((ExprNodeDesc)falseExpr, null), null}, {TestPositivePartitionPrunerCompactExpr.or(null, (ExprNodeDesc)falseExpr), null}, {TestPositivePartitionPrunerCompactExpr.or((ExprNodeDesc)trueExpr, null), "true"}, {TestPositivePartitionPrunerCompactExpr.or(null, (ExprNodeDesc)trueExpr), "true"}, {TestPositivePartitionPrunerCompactExpr.or((ExprNodeDesc)udf1Expr, null), null}, {TestPositivePartitionPrunerCompactExpr.or(null, (ExprNodeDesc)udf2Expr), null}, {TestPositivePartitionPrunerCompactExpr.or((ExprNodeDesc)udf1Expr, (ExprNodeDesc)udf2Expr), "(col1 is null or col2 is null)"}, {TestPositivePartitionPrunerCompactExpr.or((ExprNodeDesc)falseExpr, (ExprNodeDesc)falseExpr), "false"}, {TestPositivePartitionPrunerCompactExpr.or((ExprNodeDesc)trueExpr, (ExprNodeDesc)falseExpr), "true"}, {TestPositivePartitionPrunerCompactExpr.or((ExprNodeDesc)falseExpr, (ExprNodeDesc)trueExpr), "true"}, {TestPositivePartitionPrunerCompactExpr.or((ExprNodeDesc)udf1Expr, (ExprNodeDesc)falseExpr), "col1 is null"}, {TestPositivePartitionPrunerCompactExpr.or((ExprNodeDesc)falseExpr, (ExprNodeDesc)udf2Expr), "col2 is null"}, {TestPositivePartitionPrunerCompactExpr.or((ExprNodeDesc)trueExpr, (ExprNodeDesc)trueExpr), "true"}, {TestPositivePartitionPrunerCompactExpr.or((ExprNodeDesc)udf1Expr, (ExprNodeDesc)trueExpr), "true"}, {TestPositivePartitionPrunerCompactExpr.or((ExprNodeDesc)trueExpr, (ExprNodeDesc)udf2Expr), "true"}, {TestPositivePartitionPrunerCompactExpr.or(TestPositivePartitionPrunerCompactExpr.and((ExprNodeDesc)udf1Expr, (ExprNodeDesc)udf2Expr), (ExprNodeDesc)udf2Expr), "((col1 is null and col2 is null) or col2 is null)"}, {TestPositivePartitionPrunerCompactExpr.and(TestPositivePartitionPrunerCompactExpr.or((ExprNodeDesc)udf1Expr, (ExprNodeDesc)udf2Expr), (ExprNodeDesc)udf2Expr), "((col1 is null or col2 is null) and col2 is null)"});
    }

    @Test
    public void testCompactExpr() {
        ExprNodeDesc actual = PartitionPruner.compactExpr((ExprNodeDesc)this.expression);
        if (this.expected == null) {
            Assert.assertNull((Object)actual);
        } else {
            Assert.assertNotNull((String)"Expected not NULL expression", (Object)actual);
            Assert.assertNotNull((String)"Expected not NULL expression string", (Object)actual.getExprString());
            Assert.assertEquals((Object)this.expected, (Object)actual.getExprString());
        }
    }

    private static ExprNodeDesc or(ExprNodeDesc left, ExprNodeDesc right) {
        return new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, (GenericUDF)new GenericUDFOPOr(), Arrays.asList(left, right));
    }

    private static ExprNodeDesc and(ExprNodeDesc left, ExprNodeDesc right) {
        return new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, (GenericUDF)new GenericUDFOPAnd(), Arrays.asList(left, right));
    }
}

