/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.hadoop.hive.metastore.IMetaStoreSchemaInfo;
import org.apache.hadoop.hive.metastore.tools.HiveSchemaHelper;
import org.apache.hadoop.hive.metastore.utils.MetastoreVersionInfo;

public class MetaStoreSchemaInfo
implements IMetaStoreSchemaInfo {
    protected static final String UPGRADE_FILE_PREFIX = "upgrade-";
    protected static final String INIT_FILE_PREFIX = "hive-schema-";
    protected static final String VERSION_UPGRADE_LIST = "upgrade.order";
    protected static final String PRE_UPGRADE_PREFIX = "pre-";
    protected static final String CREATE_USER_PREFIX = "create-user";
    private String[] hiveSchemaVersions;
    private final String metastoreHome;
    protected final String dbType;
    private static final Map<String, String> EQUIVALENT_VERSIONS = ImmutableMap.builder().put("0.13.1", "0.13.0").put("1.0.0", "0.14.0").put("1.0.1", "1.0.0").put("1.1.1", "1.1.0").put("1.2.1", "1.2.0").put("2.3.9", "2.3.0").put("3.1.3", "3.1.0").build();

    public MetaStoreSchemaInfo(String metastoreHome, String dbType) throws HiveMetaException {
        this.metastoreHome = metastoreHome;
        this.dbType = dbType;
    }

    private void loadAllUpgradeScripts(String dbType) throws HiveMetaException {
        ArrayList<String> upgradeOrderList = new ArrayList<String>();
        String upgradeListFile = this.getMetaStoreScriptDir() + File.separator + "upgrade.order." + dbType;
        try (FileReader fr = new FileReader(upgradeListFile);
             BufferedReader bfReader = new BufferedReader(fr);){
            String currSchemaVersion;
            while ((currSchemaVersion = bfReader.readLine()) != null) {
                upgradeOrderList.add(currSchemaVersion.trim());
            }
        }
        catch (FileNotFoundException e) {
            throw new HiveMetaException("File " + upgradeListFile + "not found ", e);
        }
        catch (IOException e) {
            throw new HiveMetaException("Error reading " + upgradeListFile, e);
        }
        this.hiveSchemaVersions = upgradeOrderList.toArray(new String[0]);
    }

    @Override
    public List<String> getUpgradeScripts(String fromVersion) throws HiveMetaException {
        int i;
        ArrayList<String> upgradeScriptList = new ArrayList<String>();
        if (this.getHiveSchemaVersion().equals(fromVersion)) {
            return upgradeScriptList;
        }
        this.loadAllUpgradeScripts(this.dbType);
        int firstScript = this.hiveSchemaVersions.length;
        for (i = 0; i < this.hiveSchemaVersions.length; ++i) {
            if (!this.hiveSchemaVersions[i].startsWith(fromVersion)) continue;
            firstScript = i;
        }
        if (firstScript == this.hiveSchemaVersions.length) {
            throw new HiveMetaException("Unknown version specified for upgrade " + fromVersion + " Metastore schema may be too old or newer");
        }
        for (i = firstScript; i < this.hiveSchemaVersions.length; ++i) {
            String scriptFile = this.generateUpgradeFileName(this.hiveSchemaVersions[i]);
            upgradeScriptList.add(scriptFile);
        }
        return upgradeScriptList;
    }

    @Override
    public String generateInitFileName(String toVersion) throws HiveMetaException {
        if (toVersion == null) {
            toVersion = this.getHiveSchemaVersion();
        }
        String initScriptName = INIT_FILE_PREFIX + toVersion + "." + this.dbType + ".sql";
        if (!new File(this.getMetaStoreScriptDir() + File.separatorChar + initScriptName).exists()) {
            throw new HiveMetaException("Unknown version specified for initialization: " + toVersion);
        }
        return initScriptName;
    }

    @Override
    public String getCreateUserScript() throws HiveMetaException {
        String createScript = "create-user." + this.dbType + ".sql";
        if (!new File(this.getMetaStoreScriptDir() + File.separatorChar + createScript).exists()) {
            throw new HiveMetaException("Unable to find create user file, expected: " + createScript);
        }
        return createScript;
    }

    @Override
    public String getMetaStoreScriptDir() {
        return this.metastoreHome + File.separatorChar + "scripts" + File.separatorChar + "metastore" + File.separatorChar + "upgrade" + File.separatorChar + this.dbType;
    }

    private String generateUpgradeFileName(String fileVersion) {
        return UPGRADE_FILE_PREFIX + fileVersion + "." + this.dbType + ".sql";
    }

    @Override
    public String getPreUpgradeScriptName(int index, String upgradeScriptName) {
        return PRE_UPGRADE_PREFIX + index + "-" + upgradeScriptName;
    }

    @Override
    public String getHiveSchemaVersion() {
        String versionFromJar = MetastoreVersionInfo.getShortVersion();
        String hiveVersion = versionFromJar.substring(0, versionFromJar.indexOf("-eep"));
        return MetaStoreSchemaInfo.getEquivalentVersion(hiveVersion);
    }

    private static String getEquivalentVersion(String hiveVersion) {
        String equivalentVersion = EQUIVALENT_VERSIONS.get(hiveVersion);
        if (equivalentVersion != null) {
            return equivalentVersion;
        }
        return hiveVersion;
    }

    @Override
    public boolean isVersionCompatible(String hiveVersion, String dbVersion) {
        if ((hiveVersion = MetaStoreSchemaInfo.getEquivalentVersion(hiveVersion)).equals(dbVersion = MetaStoreSchemaInfo.getEquivalentVersion(dbVersion))) {
            return true;
        }
        String[] hiveVerParts = hiveVersion.split("\\.");
        String[] dbVerParts = dbVersion.split("\\.");
        if (hiveVerParts.length != 3 || dbVerParts.length != 3) {
            return false;
        }
        for (int i = 0; i < dbVerParts.length; ++i) {
            int hiveVerPart;
            int dbVerPart = Integer.parseInt(dbVerParts[i]);
            if (dbVerPart > (hiveVerPart = Integer.parseInt(hiveVerParts[i]))) {
                return true;
            }
            if (dbVerPart >= hiveVerPart) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getMetaStoreSchemaVersion(HiveSchemaHelper.MetaStoreConnectionInfo connectionInfo) throws HiveMetaException {
        boolean needsQuotedIdentifier = HiveSchemaHelper.getDbCommandParser(connectionInfo.getDbType(), connectionInfo.getMetaDbType(), false).needsQuotedIdentifier();
        String versionQuery = needsQuotedIdentifier ? "select t.\"SCHEMA_VERSION\" from \"VERSION\" t" : "select t.SCHEMA_VERSION from VERSION t";
        String schema = "hive".equals(connectionInfo.getDbType()) ? "SYS" : null;
        try (Connection metastoreDbConnection = HiveSchemaHelper.getConnectionToMetastore(connectionInfo, schema);){
            String string;
            block16: {
                Statement stmt = metastoreDbConnection.createStatement();
                try {
                    ResultSet res = stmt.executeQuery(versionQuery);
                    if (!res.next()) {
                        throw new HiveMetaException("Could not find version info in metastore VERSION table.");
                    }
                    String currentSchemaVersion = res.getString(1);
                    if (res.next()) {
                        throw new HiveMetaException("Multiple versions were found in metastore.");
                    }
                    string = currentSchemaVersion;
                    if (stmt == null) break block16;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return string;
        }
        catch (SQLException e) {
            throw new HiveMetaException("Failed to get schema version, Cause:" + e.getMessage());
        }
    }
}

