/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFStringToMap;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFStringToMap {
    @Test
    public void testStringToMapWithCustomDelimiters() throws HiveException {
        GenericUDFStringToMap udf = new GenericUDFStringToMap();
        this.initGenericUDF(udf);
        LinkedHashMap<String, String> expResult = new LinkedHashMap<String, String>();
        expResult.put("key1", "value1");
        expResult.put("key2", "value2");
        expResult.put("key3", "value3");
        this.runAndVerify("key1=value1;key2=value2;key3=value3", ";", "=", expResult, (GenericUDF)udf);
    }

    @Test
    public void testStringToMapWithDefaultDelimiters() throws HiveException {
        GenericUDFStringToMap udf = new GenericUDFStringToMap();
        this.initGenericUDFWithNoDelimiters(udf);
        LinkedHashMap<String, String> expResult = new LinkedHashMap<String, String>();
        expResult.put("key1", "value1");
        expResult.put("key2", "value2");
        expResult.put("key3", "value3");
        this.runAndVerify("key1:value1,key2:value2,key3:value3", expResult, (GenericUDF)udf);
    }

    @Test
    public void testStringToMapWithNullDelimiters() throws HiveException {
        GenericUDFStringToMap udf = new GenericUDFStringToMap();
        this.initGenericUDF(udf);
        LinkedHashMap<String, String> expResult = new LinkedHashMap<String, String>();
        expResult.put("key1", "value1");
        expResult.put("key2", "value2");
        expResult.put("key3", "value3");
        this.runAndVerify("key1:value1,key2:value2,key3:value3", null, null, expResult, (GenericUDF)udf);
    }

    @Test
    public void testStringToMapWithNullText() throws HiveException {
        GenericUDFStringToMap udf = new GenericUDFStringToMap();
        this.initGenericUDFWithNoDelimiters(udf);
        LinkedHashMap<String, String> expResult = new LinkedHashMap<String, String>();
        this.runAndVerify(null, expResult, (GenericUDF)udf);
    }

    @Test
    public void testStringToMapWithEmptyText() throws HiveException {
        GenericUDFStringToMap udf = new GenericUDFStringToMap();
        this.initGenericUDFWithNoDelimiters(udf);
        LinkedHashMap<String, String> expResult = new LinkedHashMap<String, String>();
        expResult.put("", null);
        this.runAndVerify("", expResult, (GenericUDF)udf);
    }

    @Test
    public void testStringToMapNoKey() throws HiveException {
        GenericUDFStringToMap udf = new GenericUDFStringToMap();
        this.initGenericUDFWithNoDelimiters(udf);
        LinkedHashMap<String, String> expResult = new LinkedHashMap<String, String>();
        expResult.put("", "value");
        this.runAndVerify(":value", expResult, (GenericUDF)udf);
    }

    @Test
    public void testStringToMapNoValue() throws HiveException {
        GenericUDFStringToMap udf = new GenericUDFStringToMap();
        this.initGenericUDFWithNoDelimiters(udf);
        LinkedHashMap<String, String> expResult = new LinkedHashMap<String, String>();
        expResult.put("key", "");
        this.runAndVerify("key:", expResult, (GenericUDF)udf);
    }

    @Test
    public void testStringToMapNotMatchingDelimiter() throws HiveException {
        GenericUDFStringToMap udf = new GenericUDFStringToMap();
        this.initGenericUDFWithNoDelimiters(udf);
        LinkedHashMap<String, String> expResult = new LinkedHashMap<String, String>();
        expResult.put("key=value", null);
        this.runAndVerify("key=value", expResult, (GenericUDF)udf);
    }

    private void initGenericUDF(GenericUDFStringToMap udf) throws UDFArgumentException {
        JavaStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        JavaStringObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        JavaStringObjectInspector valueOI2 = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1, valueOI2};
        udf.initialize(arguments);
    }

    private void initGenericUDFWithNoDelimiters(GenericUDFStringToMap udf) throws UDFArgumentException {
        JavaStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0};
        udf.initialize(arguments);
    }

    private void runAndVerify(String text, String delimiter1, String delimiter2, Map<String, String> expResult, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)text);
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)delimiter1);
        GenericUDF.DeferredJavaObject valueObj2 = new GenericUDF.DeferredJavaObject((Object)delimiter2);
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj0, valueObj1, valueObj2};
        LinkedHashMap output = (LinkedHashMap)udf.evaluate(args);
        Assert.assertTrue((String)"str_to_map() test", (boolean)expResult.equals(output));
    }

    private void runAndVerify(String text, Map<String, String> expResult, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)text);
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj0};
        LinkedHashMap output = (LinkedHashMap)udf.evaluate(args);
        Assert.assertTrue((String)"str_to_map() test", (boolean)expResult.equals(output));
    }
}

