/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import junit.framework.TestCase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFCrc32;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

public class TestUDFCrc32
extends TestCase {
    public void testCrc32Str() throws HiveException {
        UDFCrc32 udf = new UDFCrc32();
        this.runAndVerifyStr("ABC", 2743272264L, udf);
        this.runAndVerifyStr("", 0L, udf);
        this.runAndVerifyStr("ABC", 2743272264L, udf);
        this.runAndVerifyStr("", 0L, udf);
        this.runAndVerifyStr(null, null, udf);
    }

    public void testCrc32Bin() throws HiveException {
        UDFCrc32 udf = new UDFCrc32();
        this.runAndVerifyBin(new byte[]{65, 66, 67}, 2743272264L, udf);
        this.runAndVerifyBin(new byte[0], 0L, udf);
        this.runAndVerifyBin(new byte[]{65, 66, 67}, 2743272264L, udf);
        this.runAndVerifyBin(new byte[0], 0L, udf);
        this.runAndVerifyBin(null, null, udf);
    }

    private void runAndVerifyStr(String str, Long expResult, UDFCrc32 udf) throws HiveException {
        Text t = str != null ? new Text(str) : null;
        LongWritable output = udf.evaluate(t);
        if (expResult == null) {
            TestUDFCrc32.assertNull((Object)output);
        } else {
            TestUDFCrc32.assertNotNull((Object)output);
            TestUDFCrc32.assertEquals((String)"crc32() test ", (long)expResult, (long)output.get());
        }
    }

    private void runAndVerifyBin(byte[] binV, Long expResult, UDFCrc32 udf) throws HiveException {
        BytesWritable binWr = binV != null ? new BytesWritable(binV) : null;
        LongWritable output = udf.evaluate(binWr);
        if (expResult == null) {
            TestUDFCrc32.assertNull((Object)output);
        } else {
            TestUDFCrc32.assertNotNull((Object)output);
            TestUDFCrc32.assertEquals((String)"crc32() test ", (long)expResult, (long)output.get());
        }
    }
}

