/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata.formatting;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatUtils;

public class TextMetaDataTable {
    List<List<String>> table = new ArrayList<List<String>>();

    public void addRow(String ... values) {
        this.table.add(Lists.newArrayList(values));
    }

    public String renderTable(boolean isOutputPadded) {
        StringBuilder str = new StringBuilder();
        for (List<String> row : this.table) {
            MetaDataFormatUtils.formatOutput(row.toArray(new String[0]), str, isOutputPadded, isOutputPadded);
        }
        return str.toString();
    }

    public void transpose() {
        if (this.table.size() == 0) {
            return;
        }
        ArrayList<List<String>> newTable = new ArrayList<List<String>>();
        for (int i = 0; i < this.table.get(0).size(); ++i) {
            newTable.add(new ArrayList());
        }
        for (List<String> srcRow : this.table) {
            if (newTable.size() != srcRow.size()) {
                throw new RuntimeException("invalid table size");
            }
            for (int i = 0; i < srcRow.size(); ++i) {
                ((List)newTable.get(i)).add(srcRow.get(i));
            }
        }
        this.table = newTable;
    }
}

