/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.util.batchgen;

import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.util.batchgen.VectorBatchGenerateStream;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class VectorBatchGenerateUtil {
    public static Object[][] generateRowObjectArray(TypeInfo[] typeInfos, VectorBatchGenerateStream batchStream, VectorizedRowBatch batch, ObjectInspector[] objectInspectors) throws HiveException {
        VectorExtractRow vectorExtractRow = new VectorExtractRow();
        vectorExtractRow.init(typeInfos);
        int rowCount = batchStream.getRowCount();
        int columnCount = typeInfos.length;
        Object[][] rowObjectArray = new Object[rowCount][];
        Object[] row = new Object[columnCount];
        int index = 0;
        batchStream.reset();
        while (batchStream.isNext()) {
            batch.reset();
            batchStream.fillNext(batch);
            int size = batch.size;
            for (int r = 0; r < size; ++r) {
                vectorExtractRow.extractRow(batch, r, row);
                Object[] resultObjectArray = new Object[columnCount];
                for (int c = 0; c < columnCount; ++c) {
                    resultObjectArray[c] = ((PrimitiveObjectInspector)objectInspectors[c]).copyObject(row[c]);
                }
                rowObjectArray[index++] = resultObjectArray;
            }
        }
        return rowObjectArray;
    }

    public static VectorizedRowBatch[] generateBatchArray(VectorBatchGenerateStream batchStream, VectorizedRowBatch batch) throws HiveException {
        int rowCount = batchStream.getRowCount();
        int batchCount = (rowCount + 1024 - 1) / 1024;
        VectorizedRowBatch[] batches = new VectorizedRowBatch[batchCount];
        int index = 0;
        batchStream.reset();
        while (batchStream.isNext()) {
            VectorizedRowBatch nextBatch = VectorizedBatchUtil.makeLike((VectorizedRowBatch)batch);
            batchStream.fillNext(nextBatch);
            batches[index++] = nextBatch;
        }
        return batches;
    }
}

