/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.read;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;
import org.apache.hadoop.hive.ql.io.parquet.HiveParquetSchemaTestUtils;
import org.apache.hadoop.hive.ql.io.parquet.read.DataWritableReadSupport;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.junit.Test;

public class TestDataWritableReadSupport {
    @Test
    public void testGetProjectedSchema1() throws Exception {
        MessageType originalMsg = MessageTypeParser.parseMessageType((String)"message hive_schema {\n  optional group structCol {\n    optional int32 a;\n    optional double b;\n    optional boolean c;\n    optional fixed_len_byte_array(3) d (DECIMAL(5,2));\n  }\n}\n");
        HiveParquetSchemaTestUtils.testConversion("structCol", "struct<a:int>", DataWritableReadSupport.getProjectedSchema((MessageType)originalMsg, Arrays.asList("structCol"), Arrays.asList(0), (Set)Sets.newHashSet((Object[])new String[]{"structCol.a"})).toString());
    }

    @Test
    public void testGetProjectedSchema2() throws Exception {
        MessageType originalMsg = MessageTypeParser.parseMessageType((String)"message hive_schema {\n  optional group structCol {\n    optional int32 a;\n    optional double b;\n  }\n}\n");
        HiveParquetSchemaTestUtils.testConversion("structCol", "struct<a:int,b:double>", DataWritableReadSupport.getProjectedSchema((MessageType)originalMsg, Arrays.asList("structCol"), Arrays.asList(0), (Set)Sets.newHashSet((Object[])new String[]{"structCol.a", "structCol.b"})).toString());
    }

    @Test
    public void testGetProjectedSchema3() throws Exception {
        MessageType originalMsg = MessageTypeParser.parseMessageType((String)"message hive_schema {\n  optional group structCol {\n    optional int32 a;\n    optional double b;\n  }\n  optional boolean c;\n}\n");
        HiveParquetSchemaTestUtils.testConversion("structCol,c", "struct<b:double>,boolean", DataWritableReadSupport.getProjectedSchema((MessageType)originalMsg, Arrays.asList("structCol", "c"), Arrays.asList(0, 1), (Set)Sets.newHashSet((Object[])new String[]{"structCol.b", "c"})).toString());
    }

    @Test
    public void testGetProjectedSchema4() throws Exception {
        MessageType originalMsg = MessageTypeParser.parseMessageType((String)"message hive_schema {\n  optional group structCol {\n    optional int32 a;\n    optional group subStructCol {\n      optional int64 b;\n      optional boolean c;\n    }\n  }\n  optional boolean d;\n}\n");
        HiveParquetSchemaTestUtils.testConversion("structCol", "struct<subStructCol:struct<b:bigint>>", DataWritableReadSupport.getProjectedSchema((MessageType)originalMsg, Arrays.asList("structCol"), Arrays.asList(0), (Set)Sets.newHashSet((Object[])new String[]{"structCol.subStructCol.b"})).toString());
    }

    @Test
    public void testGetProjectedSchema5() throws Exception {
        MessageType originalMsg = MessageTypeParser.parseMessageType((String)"message hive_schema {\n  optional group structCol {\n    optional int32 a;\n    optional group subStructCol {\n      optional int64 b;\n      optional boolean c;\n    }\n  }\n  optional boolean d;\n}\n");
        HiveParquetSchemaTestUtils.testConversion("structCol", "struct<subStructCol:struct<b:bigint,c:boolean>>", DataWritableReadSupport.getProjectedSchema((MessageType)originalMsg, Arrays.asList("structCol"), Arrays.asList(0), (Set)Sets.newHashSet((Object[])new String[]{"structCol.subStructCol", "structCol.subStructCol.b", "structCol.subStructCol.c"})).toString());
    }
}

