/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet;

import java.io.IOException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.io.parquet.VectorizedColumnReaderTestBase;
import org.apache.hadoop.hive.ql.io.parquet.vector.VectorizedParquetRecordReader;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.io.api.Binary;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorizedMapColumnReader
extends VectorizedColumnReaderTestBase {
    protected static void writeMapData(ParquetWriter<Group> writer, boolean isDictionaryEncoding, int elementNum) throws IOException {
        SimpleGroupFactory f = new SimpleGroupFactory(schema);
        int mapMaxSize = 4;
        int mapElementIndex = 0;
        for (int i = 0; i < elementNum; ++i) {
            boolean isNull = TestVectorizedMapColumnReader.isNull(i);
            Group group = f.newGroup();
            int mapSize = i % mapMaxSize + 1;
            if (!isNull) {
                Group multipleLevelGroup = group.addGroup("map_field");
                for (int j = 0; j < mapSize; ++j) {
                    int intValForMap = TestVectorizedMapColumnReader.getIntValue(isDictionaryEncoding, mapElementIndex);
                    long longValForMap = TestVectorizedMapColumnReader.getLongValue(isDictionaryEncoding, mapElementIndex);
                    double doubleValForMap = TestVectorizedMapColumnReader.getDoubleValue(isDictionaryEncoding, mapElementIndex);
                    float floatValForMap = TestVectorizedMapColumnReader.getFloatValue(isDictionaryEncoding, mapElementIndex);
                    Binary binaryValForMap = TestVectorizedMapColumnReader.getBinaryValue(isDictionaryEncoding, mapElementIndex);
                    HiveDecimal hd = TestVectorizedMapColumnReader.getDecimal(isDictionaryEncoding, mapElementIndex).setScale(2);
                    HiveDecimalWritable hdw = new HiveDecimalWritable(hd);
                    Binary decimalValForMap = Binary.fromConstantByteArray((byte[])hdw.getInternalStorage());
                    group.addGroup("map_int32").append("key", intValForMap).append("value", intValForMap);
                    group.addGroup("map_int64").append("key", longValForMap).append("value", longValForMap);
                    group.addGroup("map_double").append("key", doubleValForMap).append("value", doubleValForMap);
                    group.addGroup("map_float").append("key", floatValForMap).append("value", floatValForMap);
                    group.addGroup("map_binary").append("key", binaryValForMap).append("value", binaryValForMap);
                    group.addGroup("map_decimal").append("key", decimalValForMap).append("value", decimalValForMap);
                    multipleLevelGroup.addGroup("map").append("key", binaryValForMap).append("value", binaryValForMap);
                    ++mapElementIndex;
                }
            }
            writer.write((Object)group);
        }
        writer.close();
    }

    protected static void writeRepeateMapData(ParquetWriter<Group> writer, int elementNum, boolean isNull) throws IOException {
        SimpleGroupFactory f = new SimpleGroupFactory(schema);
        int mapMaxSize = 4;
        for (int i = 0; i < elementNum; ++i) {
            Group group = f.newGroup();
            if (!isNull) {
                for (int j = 0; j < mapMaxSize; ++j) {
                    group.addGroup("map_int32_for_repeat_test").append("key", j).append("value", j);
                }
            }
            writer.write((Object)group);
        }
        writer.close();
    }

    @Test
    public void testMapReadLessOneBatch() throws Exception {
        boolean isDictionaryEncoding = false;
        TestVectorizedMapColumnReader.removeFile();
        TestVectorizedMapColumnReader.writeMapData(TestVectorizedMapColumnReader.initWriterFromFile(), isDictionaryEncoding, 1023);
        this.testMapReadAllType(isDictionaryEncoding, 1023);
        TestVectorizedMapColumnReader.removeFile();
        isDictionaryEncoding = true;
        TestVectorizedMapColumnReader.writeMapData(TestVectorizedMapColumnReader.initWriterFromFile(), isDictionaryEncoding, 1023);
        this.testMapReadAllType(isDictionaryEncoding, 1023);
        TestVectorizedMapColumnReader.removeFile();
    }

    @Test
    public void testMapReadEqualOneBatch() throws Exception {
        boolean isDictionaryEncoding = false;
        TestVectorizedMapColumnReader.removeFile();
        TestVectorizedMapColumnReader.writeMapData(TestVectorizedMapColumnReader.initWriterFromFile(), isDictionaryEncoding, 1024);
        this.testMapReadAllType(isDictionaryEncoding, 1024);
        TestVectorizedMapColumnReader.removeFile();
        isDictionaryEncoding = true;
        TestVectorizedMapColumnReader.writeMapData(TestVectorizedMapColumnReader.initWriterFromFile(), isDictionaryEncoding, 1024);
        this.testMapReadAllType(isDictionaryEncoding, 1024);
        TestVectorizedMapColumnReader.removeFile();
    }

    @Test
    public void testMapReadMoreOneBatch() throws Exception {
        boolean isDictionaryEncoding = false;
        TestVectorizedMapColumnReader.removeFile();
        TestVectorizedMapColumnReader.writeMapData(TestVectorizedMapColumnReader.initWriterFromFile(), isDictionaryEncoding, 1025);
        this.testMapReadAllType(isDictionaryEncoding, 1025);
        TestVectorizedMapColumnReader.removeFile();
        isDictionaryEncoding = true;
        TestVectorizedMapColumnReader.writeMapData(TestVectorizedMapColumnReader.initWriterFromFile(), isDictionaryEncoding, 1025);
        this.testMapReadAllType(isDictionaryEncoding, 1025);
        TestVectorizedMapColumnReader.removeFile();
    }

    @Test
    public void testRepeateMapRead() throws Exception {
        TestVectorizedMapColumnReader.removeFile();
        TestVectorizedMapColumnReader.writeRepeateMapData(TestVectorizedMapColumnReader.initWriterFromFile(), 1023, false);
        this.testRepeateMapRead(1023, false);
        TestVectorizedMapColumnReader.removeFile();
        TestVectorizedMapColumnReader.writeRepeateMapData(TestVectorizedMapColumnReader.initWriterFromFile(), 1023, true);
        this.testRepeateMapRead(1023, true);
        TestVectorizedMapColumnReader.removeFile();
        TestVectorizedMapColumnReader.writeRepeateMapData(TestVectorizedMapColumnReader.initWriterFromFile(), 1024, false);
        this.testRepeateMapRead(1024, false);
        TestVectorizedMapColumnReader.removeFile();
        TestVectorizedMapColumnReader.writeRepeateMapData(TestVectorizedMapColumnReader.initWriterFromFile(), 1024, true);
        this.testRepeateMapRead(1024, true);
        TestVectorizedMapColumnReader.removeFile();
        TestVectorizedMapColumnReader.writeRepeateMapData(TestVectorizedMapColumnReader.initWriterFromFile(), 1025, false);
        this.testRepeateMapRead(1025, false);
        TestVectorizedMapColumnReader.removeFile();
        TestVectorizedMapColumnReader.writeRepeateMapData(TestVectorizedMapColumnReader.initWriterFromFile(), 1025, true);
        this.testRepeateMapRead(1025, true);
        TestVectorizedMapColumnReader.removeFile();
    }

    @Test
    public void testMultipleDefinitionMapRead() throws Exception {
        TestVectorizedMapColumnReader.removeFile();
        TestVectorizedMapColumnReader.writeMapData(TestVectorizedMapColumnReader.initWriterFromFile(), false, 1023);
        this.testMapRead(false, "multipleLevel", 1023);
        TestVectorizedMapColumnReader.removeFile();
    }

    private void testMapReadAllType(boolean isDictionaryEncoding, int elementNum) throws Exception {
        this.testMapRead(isDictionaryEncoding, "int", elementNum);
        this.testMapRead(isDictionaryEncoding, "long", elementNum);
        this.testMapRead(isDictionaryEncoding, "double", elementNum);
        this.testMapRead(isDictionaryEncoding, "float", elementNum);
        this.testMapRead(isDictionaryEncoding, "binary", elementNum);
        this.testMapRead(isDictionaryEncoding, "decimal", elementNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMapRead(boolean isDictionaryEncoding, String type, int elementNum) throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        this.setTypeConfiguration(type, conf);
        conf.setBoolean("hive.io.file.read.all.columns", false);
        conf.set("hive.io.file.readcolumn.ids", "0");
        VectorizedParquetRecordReader reader = TestVectorizedMapColumnReader.createTestParquetReader(this.getSchema(type), conf);
        VectorizedRowBatch previous = reader.createValue();
        int row = 0;
        int index = 0;
        try {
            block3: while (reader.next(NullWritable.get(), previous)) {
                MapColumnVector mapVector = (MapColumnVector)previous.cols[0];
                Assert.assertEquals((Object)(mapVector.offsets.length == 1 ? 1 : 0), (Object)mapVector.isRepeating);
                for (int i = 0; i < mapVector.offsets.length; ++i) {
                    if (row == elementNum) {
                        Assert.assertEquals((long)i, (long)(mapVector.offsets.length - 1));
                        continue block3;
                    }
                    long start = mapVector.offsets[i];
                    long length = mapVector.lengths[i];
                    boolean isNull = TestVectorizedMapColumnReader.isNull(row);
                    if (isNull) {
                        Assert.assertEquals((Object)mapVector.isNull[i], (Object)true);
                    } else {
                        for (long j = 0L; j < length; ++j) {
                            this.assertValue(type, mapVector.keys, isDictionaryEncoding, index, (int)(start + j));
                            this.assertValue(type, mapVector.values, isDictionaryEncoding, index, (int)(start + j));
                            ++index;
                        }
                    }
                    ++row;
                }
            }
            Assert.assertEquals((String)"It doesn't exit at expected position", (long)elementNum, (long)row);
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRepeateMapRead(int elementNum, boolean isNull) throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        conf.set("columns", "map_int32_for_repeat_test");
        conf.set("columns.types", "map<int,int>");
        conf.setBoolean("hive.io.file.read.all.columns", false);
        conf.set("hive.io.file.readcolumn.ids", "0");
        String schema = "message hive_schema {\n  repeated group map_int32_for_repeat_test (MAP_KEY_VALUE) {\n    required int32 key;\n    optional int32 value;\n  }\n}\n";
        VectorizedParquetRecordReader reader = TestVectorizedMapColumnReader.createTestParquetReader(schema, conf);
        VectorizedRowBatch previous = reader.createValue();
        int row = 0;
        try {
            block3: while (reader.next(NullWritable.get(), previous)) {
                MapColumnVector mapVector = (MapColumnVector)previous.cols[0];
                Assert.assertTrue((boolean)mapVector.isRepeating);
                Assert.assertEquals((Object)isNull, (Object)mapVector.isNull[0]);
                for (int i = 0; i < mapVector.offsets.length; ++i) {
                    if (row == elementNum) {
                        Assert.assertEquals((long)i, (long)(mapVector.offsets.length - 1));
                        continue block3;
                    }
                    ++row;
                }
            }
            Assert.assertEquals((String)"It doesn't exit at expected position", (long)elementNum, (long)row);
        }
        finally {
            reader.close();
        }
    }

    private void setTypeConfiguration(String type, Configuration conf) {
        if ("int".equals(type)) {
            conf.set("columns", "map_int32");
            conf.set("columns.types", "map<int,int>");
        } else if ("long".equals(type)) {
            conf.set("columns", "map_int64");
            conf.set("columns.types", "map<bigint,bigint>");
        } else if ("double".equals(type)) {
            conf.set("columns", "map_double");
            conf.set("columns.types", "map<double,double>");
        } else if ("float".equals(type)) {
            conf.set("columns", "map_float");
            conf.set("columns.types", "map<float,float>");
        } else if ("binary".equals(type)) {
            conf.set("columns", "map_binary");
            conf.set("columns.types", "map<string,string>");
        } else if ("decimal".equals(type)) {
            conf.set("columns", "map_decimal");
            conf.set("columns.types", "map<decimal(5,2),decimal(5,2)>");
        } else if ("multipleLevel".equals(type)) {
            conf.set("columns", "map_field");
            conf.set("columns.types", "map<string,string>");
        }
    }

    private String getSchema(String type) {
        String schemaFormat = "message hive_schema {\n  repeated group map_%s (MAP_KEY_VALUE) {\n    required %s key %s;\n    optional %s value %s;\n  }\n}\n";
        switch (type) {
            case "int": {
                return String.format(schemaFormat, "int32", "int32", "", "int32", "");
            }
            case "long": {
                return String.format(schemaFormat, "int64", "int64", "", "int64", "");
            }
            case "double": {
                return String.format(schemaFormat, "double", "double", "", "double", "");
            }
            case "float": {
                return String.format(schemaFormat, "float", "float", "", "float", "");
            }
            case "binary": {
                return String.format(schemaFormat, "binary", "binary", "", "binary", "");
            }
            case "decimal": {
                return String.format(schemaFormat, "decimal", "binary", "(DECIMAL(5,2))", "binary", "(DECIMAL(5,2))");
            }
            case "multipleLevel": {
                return "message hive_schema {\noptional group map_field (MAP) {\n  repeated group map (MAP_KEY_VALUE) {\n    required binary key;\n    optional binary value;\n  }\n}\n}\n";
            }
        }
        throw new RuntimeException("Unsupported type for TestVectorizedMapColumnReader!");
    }

    private void assertValue(String type, ColumnVector childVector, boolean isDictionaryEncoding, int valueIndex, int position) {
        if ("int".equals(type)) {
            Assert.assertEquals((long)TestVectorizedMapColumnReader.getIntValue(isDictionaryEncoding, valueIndex), (long)((LongColumnVector)childVector).vector[position]);
        } else if ("long".equals(type)) {
            Assert.assertEquals((long)TestVectorizedMapColumnReader.getLongValue(isDictionaryEncoding, valueIndex), (long)((LongColumnVector)childVector).vector[position]);
        } else if ("double".equals(type)) {
            Assert.assertEquals((double)TestVectorizedMapColumnReader.getDoubleValue(isDictionaryEncoding, valueIndex), (double)((DoubleColumnVector)childVector).vector[position], (double)0.0);
        } else if ("float".equals(type)) {
            Assert.assertEquals((double)TestVectorizedMapColumnReader.getFloatValue(isDictionaryEncoding, valueIndex), (double)((DoubleColumnVector)childVector).vector[position], (double)0.0);
        } else if ("binary".equals(type) || "multipleLevel".equals(type)) {
            String actual = new String(ArrayUtils.subarray((byte[])((BytesColumnVector)childVector).vector[position], (int)((BytesColumnVector)childVector).start[position], (int)(((BytesColumnVector)childVector).start[position] + ((BytesColumnVector)childVector).length[position])));
            Assert.assertEquals((Object)TestVectorizedMapColumnReader.getStr(isDictionaryEncoding, valueIndex), (Object)actual);
        } else if ("decimal".equals(type)) {
            Assert.assertEquals((Object)TestVectorizedMapColumnReader.getDecimal(isDictionaryEncoding, valueIndex), (Object)((DecimalColumnVector)childVector).vector[position].getHiveDecimal());
        } else {
            throw new RuntimeException("Unsupported type for TestVectorizedMapColumnReader!");
        }
    }
}

