/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.optimizer.ColumnPrunerProcCtx;
import org.apache.hadoop.hive.ql.optimizer.FieldNode;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFPower;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestColumnPrunerProcCtx {
    private static TypeInfo col1Type;
    private static TypeInfo col2Type;
    private static TypeInfo col3Type;

    @BeforeClass
    public static void setup() {
        ArrayList<String> ns = new ArrayList<String>();
        ns.add("a");
        ns.add("b");
        ArrayList<PrimitiveTypeInfo> tis = new ArrayList<PrimitiveTypeInfo>();
        PrimitiveTypeInfo aType = TypeInfoFactory.booleanTypeInfo;
        PrimitiveTypeInfo bType = TypeInfoFactory.doubleTypeInfo;
        tis.add(aType);
        tis.add(bType);
        col1Type = TypeInfoFactory.getStructTypeInfo(ns, tis);
        col2Type = TypeInfoFactory.doubleTypeInfo;
        ArrayList<String> names = new ArrayList<String>();
        names.add("col1");
        names.add("col2");
        ArrayList<TypeInfo> typeInfos = new ArrayList<TypeInfo>();
        typeInfos.add(col1Type);
        typeInfos.add(col2Type);
        col3Type = TypeInfoFactory.getStructTypeInfo(names, typeInfos);
    }

    @Test
    public void testGetSelectNestedColPathsFromChildren1() {
        ColumnPrunerProcCtx ctx = new ColumnPrunerProcCtx(null);
        ExprNodeColumnDesc colDesc = new ExprNodeColumnDesc(col3Type, "root", "test", false);
        ExprNodeFieldDesc col1 = new ExprNodeFieldDesc(col1Type, (ExprNodeDesc)colDesc, "col1", Boolean.valueOf(false));
        ExprNodeFieldDesc fieldDesc = new ExprNodeFieldDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, (ExprNodeDesc)col1, "a", Boolean.valueOf(false));
        List<FieldNode> paths = Arrays.asList(new FieldNode("_col0"));
        SelectOperator selectOperator = this.buildSelectOperator(Arrays.asList(fieldDesc), paths);
        List groups = ctx.getSelectColsFromChildren(selectOperator, paths);
        this.compareTestResults(groups, "root.col1.a");
    }

    @Test
    public void testGetSelectNestedColPathsFromChildren2() {
        ColumnPrunerProcCtx ctx = new ColumnPrunerProcCtx(null);
        ExprNodeColumnDesc colDesc = new ExprNodeColumnDesc(col3Type, "root", "test", false);
        ExprNodeFieldDesc fieldDesc = new ExprNodeFieldDesc(col1Type, (ExprNodeDesc)colDesc, "col1", Boolean.valueOf(false));
        List<FieldNode> paths = Arrays.asList(new FieldNode("_col0"));
        SelectOperator selectOperator = this.buildSelectOperator(Arrays.asList(fieldDesc), paths);
        List groups = ctx.getSelectColsFromChildren(selectOperator, paths);
        this.compareTestResults(groups, "root.col1");
    }

    @Test
    public void testGetSelectNestedColPathsFromChildren3() {
        ColumnPrunerProcCtx ctx = new ColumnPrunerProcCtx(null);
        ExprNodeColumnDesc colDesc = new ExprNodeColumnDesc(col3Type, "root", "test", false);
        ExprNodeFieldDesc fieldDesc = new ExprNodeFieldDesc(col1Type, (ExprNodeDesc)colDesc, "col2", Boolean.valueOf(false));
        List<FieldNode> paths = Arrays.asList(new FieldNode("_col0"));
        SelectOperator selectOperator = this.buildSelectOperator(Arrays.asList(fieldDesc), paths);
        List groups = ctx.getSelectColsFromChildren(selectOperator, paths);
        this.compareTestResults(groups, "root.col2");
    }

    @Test
    public void testGetSelectNestedColPathsFromChildren4() {
        ColumnPrunerProcCtx ctx = new ColumnPrunerProcCtx(null);
        ExprNodeColumnDesc colDesc = new ExprNodeColumnDesc(col3Type, "root", "test", false);
        List<FieldNode> paths = Arrays.asList(new FieldNode("_col0"));
        SelectOperator selectOperator = this.buildSelectOperator(Arrays.asList(colDesc), paths);
        List groups = ctx.getSelectColsFromChildren(selectOperator, paths);
        this.compareTestResults(groups, "root");
    }

    @Test
    public void testGetSelectNestedColPathsFromChildren5() {
        ColumnPrunerProcCtx ctx = new ColumnPrunerProcCtx(null);
        ExprNodeConstantDesc constADesc = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, (Object)"a");
        ExprNodeConstantDesc constBDesc = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.doubleTypeInfo, (Object)"b");
        ArrayList<ExprNodeConstantDesc> list = new ArrayList<ExprNodeConstantDesc>();
        list.add(constADesc);
        list.add(constBDesc);
        GenericUDF udf = (GenericUDF)Mockito.mock(GenericUDF.class);
        ExprNodeGenericFuncDesc funcDesc = new ExprNodeGenericFuncDesc(col1Type, udf, "named_struct", list);
        ExprNodeFieldDesc fieldDesc = new ExprNodeFieldDesc((TypeInfo)TypeInfoFactory.doubleTypeInfo, (ExprNodeDesc)funcDesc, "foo", Boolean.valueOf(false));
        List<FieldNode> paths = Arrays.asList(new FieldNode("_col0"));
        SelectOperator selectOperator = this.buildSelectOperator(Arrays.asList(fieldDesc), paths);
        List groups = ctx.getSelectColsFromChildren(selectOperator, paths);
        Assert.assertEquals((long)0L, (long)groups.size());
    }

    @Test
    public void testGetSelectNestedColPathsFromChildren6() {
        ColumnPrunerProcCtx ctx = new ColumnPrunerProcCtx(null);
        ExprNodeColumnDesc colDesc = new ExprNodeColumnDesc(col3Type, "root", "test", false);
        ExprNodeFieldDesc col1 = new ExprNodeFieldDesc(col1Type, (ExprNodeDesc)colDesc, "col1", Boolean.valueOf(false));
        ExprNodeFieldDesc fieldDesc = new ExprNodeFieldDesc((TypeInfo)TypeInfoFactory.doubleTypeInfo, (ExprNodeDesc)col1, "b", Boolean.valueOf(false));
        List<FieldNode> paths = Arrays.asList(new FieldNode("_col0"));
        GenericUDF udf = (GenericUDF)Mockito.mock(GenericUDFBridge.class);
        ArrayList<ExprNodeFieldDesc> list = new ArrayList<ExprNodeFieldDesc>();
        list.add(fieldDesc);
        ExprNodeGenericFuncDesc funcDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.binaryTypeInfo, udf, "abs", list);
        SelectOperator selectOperator = this.buildSelectOperator(Arrays.asList(funcDesc), paths);
        List groups = ctx.getSelectColsFromChildren(selectOperator, paths);
        this.compareTestResults(groups, "root.col1.b");
    }

    @Test
    public void testGetSelectNestedColPathsFromChildren7() {
        ColumnPrunerProcCtx ctx = new ColumnPrunerProcCtx(null);
        ExprNodeColumnDesc colDesc = new ExprNodeColumnDesc(col3Type, "root", "test", false);
        ExprNodeFieldDesc col1 = new ExprNodeFieldDesc(col1Type, (ExprNodeDesc)colDesc, "col1", Boolean.valueOf(false));
        ExprNodeFieldDesc fieldDesc1 = new ExprNodeFieldDesc((TypeInfo)TypeInfoFactory.doubleTypeInfo, (ExprNodeDesc)col1, "b", Boolean.valueOf(false));
        colDesc = new ExprNodeColumnDesc(col3Type, "root", "test", false);
        ExprNodeFieldDesc col2 = new ExprNodeFieldDesc(col2Type, (ExprNodeDesc)colDesc, "col2", Boolean.valueOf(false));
        List<FieldNode> paths = Arrays.asList(new FieldNode("_col0"));
        GenericUDF udf = (GenericUDF)Mockito.mock(GenericUDFPower.class);
        ArrayList<ExprNodeFieldDesc> list = new ArrayList<ExprNodeFieldDesc>();
        list.add(fieldDesc1);
        list.add(col2);
        ExprNodeGenericFuncDesc funcDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.doubleTypeInfo, udf, "pow", list);
        SelectOperator selectOperator = this.buildSelectOperator(Arrays.asList(funcDesc), paths);
        List groups = ctx.getSelectColsFromChildren(selectOperator, paths);
        this.compareTestResults(groups, "root.col1.b", "root.col2");
    }

    @Test
    public void testFieldNodeFromString() {
        FieldNode fn = FieldNode.fromPath((String)"s.a.b");
        Assert.assertEquals((Object)"s", (Object)fn.getFieldName());
        Assert.assertEquals((long)1L, (long)fn.getNodes().size());
        FieldNode childFn = (FieldNode)fn.getNodes().get(0);
        Assert.assertEquals((Object)"a", (Object)childFn.getFieldName());
        Assert.assertEquals((long)1L, (long)childFn.getNodes().size());
        Assert.assertEquals((Object)"b", (Object)((FieldNode)childFn.getNodes().get(0)).getFieldName());
    }

    @Test
    public void testMergeFieldNode() {
        FieldNode fn1 = FieldNode.fromPath((String)"s.a.b");
        FieldNode fn2 = FieldNode.fromPath((String)"s.a");
        Assert.assertEquals((Object)fn2, (Object)FieldNode.mergeFieldNode((FieldNode)fn1, (FieldNode)fn2));
        Assert.assertEquals((Object)fn2, (Object)FieldNode.mergeFieldNode((FieldNode)fn2, (FieldNode)fn1));
        fn1 = FieldNode.fromPath((String)"s.a");
        fn2 = FieldNode.fromPath((String)"p.b");
        Assert.assertNull((Object)FieldNode.mergeFieldNode((FieldNode)fn1, (FieldNode)fn2));
        fn1 = FieldNode.fromPath((String)"s.a.b");
        fn2 = FieldNode.fromPath((String)"s.a.c");
        FieldNode fn = FieldNode.mergeFieldNode((FieldNode)fn1, (FieldNode)fn2);
        Assert.assertEquals((Object)"s", (Object)fn.getFieldName());
        FieldNode childFn = (FieldNode)fn.getNodes().get(0);
        Assert.assertEquals((Object)"a", (Object)childFn.getFieldName());
        Assert.assertEquals((long)2L, (long)childFn.getNodes().size());
        Assert.assertEquals((Object)"b", (Object)((FieldNode)childFn.getNodes().get(0)).getFieldName());
        Assert.assertEquals((Object)"c", (Object)((FieldNode)childFn.getNodes().get(1)).getFieldName());
    }

    private void compareTestResults(List<FieldNode> fieldNodes, String ... paths) {
        ArrayList expectedPaths = new ArrayList();
        for (FieldNode fn : fieldNodes) {
            expectedPaths.addAll(fn.toPaths());
        }
        Assert.assertEquals((String)("Expected paths to have length " + expectedPaths + ", but got " + paths.length), (long)expectedPaths.size(), (long)paths.length);
        for (int i = 0; i < expectedPaths.size(); ++i) {
            Assert.assertEquals((String)("Element at index " + i + " doesn't match"), expectedPaths.get(i), (Object)paths[i]);
        }
    }

    private SelectOperator buildSelectOperator(List<ExprNodeDesc> colList, List<FieldNode> outputCols) {
        SelectOperator selectOperator = (SelectOperator)Mockito.mock(SelectOperator.class);
        SelectDesc selectDesc = new SelectDesc(colList, (List)ColumnPrunerProcCtx.toColumnNames(outputCols));
        selectDesc.setSelStarNoCompute(false);
        Mockito.when((Object)((SelectDesc)selectOperator.getConf())).thenReturn((Object)selectDesc);
        return selectOperator;
    }
}

