/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.llap.plugin.rpc.LlapPluginProtocolProtos;
import org.apache.hadoop.hive.ql.exec.tez.AmPluginNode;
import org.apache.hadoop.hive.ql.exec.tez.GuaranteedTasksAllocator;
import org.apache.hadoop.hive.ql.exec.tez.LlapPluginEndpointClient;
import org.apache.hadoop.hive.ql.exec.tez.SampleTezSessionState;
import org.apache.hadoop.hive.ql.exec.tez.WmTezSession;
import org.junit.Assert;
import org.junit.Test;

public class TestGuaranteedTaskAllocator {
    @Test
    public void testEqualAllocations() {
        this.testEqualAllocation(8, 5, 1.0);
        this.testEqualAllocation(0, 3, 1.0);
        this.testEqualAllocation(3, 1, 1.0);
        this.testEqualAllocation(5, 5, 1.0);
        this.testEqualAllocation(7, 10, 1.0);
        this.testEqualAllocation(98, 10, 1.0);
        this.testEqualAllocation(40, 5, 0.5);
        this.testEqualAllocation(40, 5, 0.25);
        this.testEqualAllocation(40, 5, 0.1f);
        this.testEqualAllocation(40, 5, 0.01f);
    }

    @Test
    public void testAllocations() {
        this.testAllocation(8, 1.0, new double[]{0.5, 0.25, 0.25}, new int[]{4, 2, 2});
        this.testAllocation(10, 1.0, new double[]{0.33f, 0.4f, 0.27f}, new int[]{3, 4, 3});
        this.testAllocation(10, 1.0, new double[]{0.5, 0.5, 0.5}, new int[]{5, 5, 0});
        this.testAllocation(100, 0.5, new double[]{0.15f, 0.15f, 0.15f}, new int[]{15, 15, 20});
    }

    private void testAllocation(int ducks, double total, double[] in, int[] out) {
        MockCommunicator comm = new MockCommunicator();
        GuaranteedTasksAllocatorForTest qam = new GuaranteedTasksAllocatorForTest(comm);
        ArrayList<WmTezSession> sessionsToUpdate = new ArrayList<WmTezSession>();
        comm.messages.clear();
        for (int i = 0; i < in.length; ++i) {
            this.addSession(in[i], sessionsToUpdate, i);
        }
        qam.executorCount = ducks;
        qam.updateSessionsAsync(total, sessionsToUpdate);
        Integer[] results = this.getAllocationResults(comm, in.length);
        for (int i = 0; i < results.length; ++i) {
            Assert.assertNotNull((Object)results[i]);
            Assert.assertEquals((long)out[i], (long)results[i].intValue());
        }
    }

    private void testEqualAllocation(int ducks, int sessions, double total) {
        MockCommunicator comm = new MockCommunicator();
        GuaranteedTasksAllocatorForTest qam = new GuaranteedTasksAllocatorForTest(comm);
        ArrayList<WmTezSession> sessionsToUpdate = new ArrayList<WmTezSession>();
        comm.messages.clear();
        double fraction = total / (double)sessions;
        for (int i = 0; i < sessions; ++i) {
            this.addSession(fraction, sessionsToUpdate, i);
        }
        qam.executorCount = ducks;
        qam.updateSessionsAsync(total, sessionsToUpdate);
        Integer[] results = this.getAllocationResults(comm, sessions);
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        int totalAssigned = 0;
        for (int i = 0; i < results.length; ++i) {
            Assert.assertNotNull((Object)results[i]);
            int val = results[i];
            min = Math.min(val, min);
            max = Math.max(val, max);
            totalAssigned += val;
        }
        Assert.assertTrue((max - min <= 1 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(total * (double)ducks - (double)totalAssigned) <= 0.5 ? 1 : 0) != 0);
    }

    private Integer[] getAllocationResults(MockCommunicator comm, int sessions) {
        Assert.assertEquals((long)sessions, (long)comm.messages.size());
        Integer[] results = new Integer[sessions];
        for (Map.Entry<Integer, Integer> e : comm.messages.entrySet()) {
            Assert.assertNull((Object)results[e.getKey()]);
            results[e.getKey().intValue()] = e.getValue();
        }
        return results;
    }

    private void addSession(double alloc, List<WmTezSession> sessionsToUpdate, int i) {
        SampleTezSessionState session = new SampleTezSessionState("" + i, null, null);
        session.setClusterFraction(alloc);
        sessionsToUpdate.add(session);
    }

    static class GuaranteedTasksAllocatorForTest
    extends GuaranteedTasksAllocator {
        int executorCount = 0;

        public GuaranteedTasksAllocatorForTest(LlapPluginEndpointClient amCommunicator) {
            super(new Configuration(), amCommunicator);
        }

        protected int getExecutorCount(boolean allowUpdate) {
            return this.executorCount;
        }
    }

    static class MockCommunicator
    implements LlapPluginEndpointClient {
        HashMap<Integer, Integer> messages = new HashMap();

        MockCommunicator() {
        }

        public void sendUpdateQuery(LlapPluginProtocolProtos.UpdateQueryRequestProto request, AmPluginNode node, LlapPluginEndpointClient.UpdateRequestContext callback) {
            WmTezSession session = (WmTezSession)node;
            this.messages.put(Integer.parseInt(session.getSessionId()), request.getGuaranteedTaskCount());
            callback.setResponse((Message)LlapPluginProtocolProtos.UpdateQueryResponseProto.getDefaultInstance());
        }
    }
}

