/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.metastore;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessControlException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzSessionContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.fallback.FallbackHiveAuthorizer;
import org.apache.hadoop.security.UserGroupInformation;

public class DummyHiveAuthorizer
extends FallbackHiveAuthorizer {
    static final List<String> allowedUsers = Arrays.asList("sam", "rob");

    DummyHiveAuthorizer(HiveConf hiveConf, HiveAuthenticationProvider hiveAuthenticator, HiveAuthzSessionContext ctx) {
        super(hiveConf, hiveAuthenticator, ctx);
    }

    public void checkPrivileges(HiveOperationType hiveOpType, List<HivePrivilegeObject> inputHObjs, List<HivePrivilegeObject> outputHObjs, HiveAuthzContext context) throws HiveAuthzPluginException, HiveAccessControlException {
        String user = null;
        Object errorMessage = "";
        try {
            user = UserGroupInformation.getLoginUser().getShortUserName();
        }
        catch (Exception e) {
            throw new HiveAuthzPluginException("Unable to get UserGroupInformation");
        }
        if (!this.isOperationAllowed(user)) {
            errorMessage = "Operation type " + hiveOpType + " not allowed for user:" + user;
            throw new HiveAuthzPluginException((String)errorMessage);
        }
    }

    private boolean isOperationAllowed(String user) {
        return allowedUsers.contains(user);
    }
}

