/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan.mapping;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.DriverFactory;
import org.apache.hadoop.hive.ql.IDriver;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.plan.mapper.EmptyStatsSource;
import org.apache.hadoop.hive.ql.plan.mapper.PlanMapper;
import org.apache.hadoop.hive.ql.plan.mapper.StatsSource;
import org.apache.hadoop.hive.ql.plan.mapper.StatsSources;
import org.apache.hadoop.hive.ql.reexec.ReExecDriver;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.OperatorStats;
import org.apache.hadoop.hive.ql.stats.OperatorStatsReaderHook;
import org.apache.hive.testutils.HiveTestEnvSetup;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@Ignore
public class TestCounterMapping {
    @ClassRule
    public static HiveTestEnvSetup env_setup = new HiveTestEnvSetup();
    @Rule
    public TestRule methodRule = env_setup.getMethodRule();
    static Comparator<Operator<?>> OPERATOR_ID_COMPARATOR = new Comparator<Operator<?>>(){

        @Override
        public int compare(Operator<?> o1, Operator<?> o2) {
            Long id1 = Long.valueOf(o1.getIdentifier());
            Long id2 = Long.valueOf(o2.getIdentifier());
            int c0 = Objects.compare(Operator.getOperatorName(), Operator.getOperatorName(), Comparator.naturalOrder());
            if (c0 != 0) {
                return c0;
            }
            return Long.compare(id1, id2);
        }
    };

    @BeforeClass
    public static void beforeClass() throws Exception {
        String[] cmds;
        IDriver driver = TestCounterMapping.createDriver();
        TestCounterMapping.dropTables(driver);
        for (String cmd : cmds = new String[]{"create table s (x int)", "insert into s values (1),(2),(3),(4),(5),(6),(7),(8),(9),(10)", "create table tu(id_uv int,id_uw int,u int)", "create table tv(id_uv int,v int)", "create table tw(id_uw int,w int)", "from s\ninsert overwrite table tu\n        select x,x,x\n        where x<=6 or x=10\ninsert overwrite table tv\n        select x,x\n        where x<=3 or x=10\ninsert overwrite table tw\n        select x,x\n"}) {
            int ret = driver.run(cmd).getResponseCode();
            Assert.assertEquals((String)"Checking command success", (long)0L, (long)ret);
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        IDriver driver = TestCounterMapping.createDriver();
        TestCounterMapping.dropTables(driver);
    }

    public static void dropTables(IDriver driver) throws Exception {
        String[] tables;
        for (String t : tables = new String[]{"s", "tu", "tv", "tw"}) {
            int ret = driver.run("drop table if exists " + t).getResponseCode();
            Assert.assertEquals((String)"Checking command success", (long)0L, (long)ret);
        }
    }

    private PlanMapper getMapperForQuery(IDriver driver, String query) {
        int ret = driver.run(query).getResponseCode();
        Assert.assertEquals((String)"Checking command success", (long)0L, (long)ret);
        PlanMapper pm0 = driver.getContext().getPlanMapper();
        return pm0;
    }

    @Test
    public void testUsageOfRuntimeInfo() throws ParseException {
        IDriver driver = TestCounterMapping.createDriver();
        String query = "select sum(u) from tu where u>1";
        PlanMapper pm1 = this.getMapperForQuery(driver, query);
        List filters1 = pm1.getAll(FilterOperator.class);
        filters1.sort(OPERATOR_ID_COMPARATOR.reversed());
        FilterOperator filter1 = (FilterOperator)filters1.get(0);
        driver = TestCounterMapping.createDriver();
        ((ReExecDriver)driver).setStatsSource(StatsSources.getStatsSourceContaining((StatsSource)EmptyStatsSource.INSTANCE, (PlanMapper)pm1));
        PlanMapper pm2 = this.getMapperForQuery(driver, query);
        List filters2 = pm2.getAll(FilterOperator.class);
        filters2.sort(OPERATOR_ID_COMPARATOR.reversed());
        FilterOperator filter2 = (FilterOperator)filters2.get(0);
        Assert.assertEquals((String)"original check", (long)7L, (long)filter1.getStatistics().getNumRows());
        Assert.assertEquals((String)"optimized check", (long)6L, (long)filter2.getStatistics().getNumRows());
    }

    @Test
    @Ignore(value="needs HiveFilter mapping")
    public void testMappingJoinLookup() throws ParseException {
        IDriver driver = TestCounterMapping.createDriver();
        PlanMapper pm0 = this.getMapperForQuery(driver, "select sum(tu.id_uv),sum(u) from tu join tv on (tu.id_uv = tv.id_uv) where u>1 and v>1");
        Iterator itG = pm0.iterateGroups();
        int checkedOperators = 0;
        while (itG.hasNext()) {
            OperatorStats os;
            PlanMapper.EquivGroup g = (PlanMapper.EquivGroup)itG.next();
            List hfs = g.getAll(HiveFilter.class);
            List oss = g.getAll(OperatorStats.class);
            List fos = g.getAll(FilterOperator.class);
            if (fos.size() <= 0 || oss.size() <= 0) continue;
            if (hfs.size() == 0) {
                Assert.fail((String)"HiveFilter is not connected?");
            }
            if ((os = (OperatorStats)oss.get(0)).getOutputRecords() != 3L && os.getOutputRecords() != 6L) {
                Assert.fail((String)"nonexpected number of records produced");
            }
            ++checkedOperators;
        }
        Assert.assertEquals((long)2L, (long)checkedOperators);
    }

    private static IDriver createDriver() {
        HiveConf conf = TestCounterMapping.env_setup.getTestCtx().hiveConf;
        conf.setBoolVar(HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_ENABLED, true);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_ALWAYS_COLLECT_OPERATOR_STATS, true);
        conf.set("hive.auto.convert.join", "false");
        conf.set("hive.optimize.ppd", "false");
        conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, (boolean)false);
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.POSTEXECHOOKS, (String)OperatorStatsReaderHook.class.getName());
        SessionState.start((HiveConf)conf);
        IDriver driver = DriverFactory.newDriver((HiveConf)conf);
        return driver;
    }
}

