/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import org.apache.hadoop.hive.ql.exec.persistence.HashMapWrapper;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinEagerRowContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKey;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKeyObject;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinRowContainer;
import org.apache.hadoop.hive.ql.exec.persistence.Utilities;
import org.apache.hadoop.io.Text;
import org.junit.Before;
import org.junit.Test;

public class TestMapJoinEqualityTableContainer {
    private static final MapJoinKeyObject KEY1 = new MapJoinKeyObject(new Object[]{new Text("key1")});
    private static final MapJoinKeyObject KEY2 = new MapJoinKeyObject(new Object[]{new Text("key2")});
    private static final MapJoinKeyObject KEY3 = new MapJoinKeyObject(new Object[]{new Text("key3")});
    private static final MapJoinKeyObject KEY4 = new MapJoinKeyObject(new Object[]{new Text("key4")});
    private static final Object[] VALUE = new Object[]{new Text("value")};
    private HashMapWrapper container;
    private MapJoinRowContainer rowContainer;

    @Before
    public void setup() throws Exception {
        this.rowContainer = new MapJoinEagerRowContainer();
        this.rowContainer.addRow(VALUE);
        this.container = new HashMapWrapper();
    }

    @Test
    public void testContainerBasics() throws Exception {
        this.container.put((MapJoinKey)KEY1, this.rowContainer);
        this.container.put((MapJoinKey)KEY2, this.rowContainer);
        this.container.put((MapJoinKey)KEY3, this.rowContainer);
        this.container.put((MapJoinKey)KEY4, this.rowContainer);
        Assert.assertEquals((int)4, (int)this.container.size());
        HashMap<MapJoinKey, MapJoinRowContainer> localContainer = new HashMap<MapJoinKey, MapJoinRowContainer>();
        for (Map.Entry entry : this.container.entrySet()) {
            localContainer.put((MapJoinKey)entry.getKey(), (MapJoinRowContainer)entry.getValue());
        }
        Utilities.testEquality(this.container.get((MapJoinKey)KEY1), (MapJoinRowContainer)localContainer.get(KEY1));
        Utilities.testEquality(this.container.get((MapJoinKey)KEY2), (MapJoinRowContainer)localContainer.get(KEY2));
        Utilities.testEquality(this.container.get((MapJoinKey)KEY3), (MapJoinRowContainer)localContainer.get(KEY3));
        Utilities.testEquality(this.container.get((MapJoinKey)KEY4), (MapJoinRowContainer)localContainer.get(KEY4));
        this.container.clear();
        Assert.assertEquals((int)0, (int)this.container.size());
        Assert.assertTrue((boolean)this.container.entrySet().isEmpty());
    }
}

